/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.direct;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.concurrent.Semaphore;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_display_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_lock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_unlock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_cleanup_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_format_cb;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.player.DefaultMediaPlayer;
import uk.co.caprica.vlcj.player.direct.BufferFormat;
import uk.co.caprica.vlcj.player.direct.BufferFormatCallback;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;

public class DefaultDirectMediaPlayer
extends DefaultMediaPlayer
implements DirectMediaPlayer {
    private final Semaphore semaphore = new Semaphore(1);
    private final BufferFormatCallback bufferFormatCallback;
    private final RenderCallback renderCallback;
    private final libvlc_video_format_cb setup;
    private final libvlc_video_cleanup_cb cleanup;
    private final libvlc_lock_callback_t lock;
    private final libvlc_unlock_callback_t unlock;
    private final libvlc_display_callback_t display;
    private BufferFormat bufferFormat;
    private Memory[] nativeBuffers;

    public DefaultDirectMediaPlayer(LibVlc libvlc, libvlc_instance_t instance, String format, int width, int height, int pitch, RenderCallback renderCallback) {
        this(libvlc, instance, new DefaultBufferFormatCallback(format, width, height, pitch), renderCallback);
    }

    public DefaultDirectMediaPlayer(LibVlc libvlc, libvlc_instance_t instance, BufferFormatCallback bufferFormatCallback, RenderCallback renderCallback) {
        super(libvlc, instance);
        this.bufferFormatCallback = bufferFormatCallback;
        this.renderCallback = renderCallback;
        this.setup = new SetupCallback();
        this.cleanup = new CleanupCallback();
        this.lock = new LockCallback();
        this.unlock = new UnlockCallback();
        this.display = new DisplayCallback();
        libvlc.libvlc_video_set_format_callbacks(this.mediaPlayerInstance(), this.setup, this.cleanup);
        libvlc.libvlc_video_set_callbacks(this.mediaPlayerInstance(), this.lock, this.unlock, this.display, null);
    }

    public final BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    static /* synthetic */ Memory[] access$802(DefaultDirectMediaPlayer x0, Memory[] x1) {
        x0.nativeBuffers = x1;
        return x1;
    }

    private static final class DefaultBufferFormatCallback
    implements BufferFormatCallback {
        private final BufferFormat bufferFormat;

        private DefaultBufferFormatCallback(String format, int width, int height, int pitch) {
            this.bufferFormat = new BufferFormat(format, width, height, new int[]{pitch}, new int[]{height});
        }

        @Override
        public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
            return this.bufferFormat;
        }
    }

    private final class DisplayCallback
    implements libvlc_display_callback_t {
        private DisplayCallback() {
        }

        @Override
        public void display(Pointer opaque, Pointer picture) {
            Logger.trace("display", new Object[0]);
            DefaultDirectMediaPlayer.this.renderCallback.display(DefaultDirectMediaPlayer.this, DefaultDirectMediaPlayer.this.nativeBuffers, DefaultDirectMediaPlayer.this.bufferFormat);
            Logger.trace("display finished", new Object[0]);
        }
    }

    private final class UnlockCallback
    implements libvlc_unlock_callback_t {
        private UnlockCallback() {
        }

        @Override
        public void unlock(Pointer opaque, Pointer picture, Pointer plane) {
            Logger.trace("unlock", new Object[0]);
            Logger.trace("release", new Object[0]);
            DefaultDirectMediaPlayer.this.semaphore.release();
            Logger.trace("released", new Object[0]);
            Logger.trace("unlock finished", new Object[0]);
        }
    }

    private final class LockCallback
    implements libvlc_lock_callback_t {
        private LockCallback() {
        }

        @Override
        public Pointer lock(Pointer opaque, PointerByReference planes) {
            Logger.trace("lock", new Object[0]);
            Logger.trace("acquire", new Object[0]);
            DefaultDirectMediaPlayer.this.semaphore.acquireUninterruptibly();
            Logger.trace("acquired", new Object[0]);
            planes.getPointer().write(0L, DefaultDirectMediaPlayer.this.nativeBuffers, 0, DefaultDirectMediaPlayer.this.nativeBuffers.length);
            Logger.trace("lock finished", new Object[0]);
            return null;
        }
    }

    private final class CleanupCallback
    implements libvlc_video_cleanup_cb {
        private CleanupCallback() {
        }

        @Override
        public void cleanup(Pointer opaque) {
            Logger.trace("cleanup", new Object[0]);
            if (DefaultDirectMediaPlayer.this.nativeBuffers != null) {
                DefaultDirectMediaPlayer.access$802(DefaultDirectMediaPlayer.this, null);
            }
            Logger.trace("cleanup finished", new Object[0]);
        }
    }

    private final class SetupCallback
    implements libvlc_video_format_cb {
        private SetupCallback() {
        }

        @Override
        public int format(PointerByReference opaque, PointerByReference chroma, IntByReference width, IntByReference height, PointerByReference pitches, PointerByReference lines) {
            Logger.debug("format(chroma={},width={},height={})", chroma.getPointer().getString(0L), width.getValue(), height.getValue());
            DefaultDirectMediaPlayer.this.bufferFormat = DefaultDirectMediaPlayer.this.bufferFormatCallback.getBufferFormat(width.getValue(), height.getValue());
            Logger.debug("bufferFormat={}", DefaultDirectMediaPlayer.this.bufferFormat);
            if (DefaultDirectMediaPlayer.this.bufferFormat == null) {
                throw new IllegalStateException("buffer format can not be null");
            }
            byte[] chromaBytes = DefaultDirectMediaPlayer.this.bufferFormat.getChroma().getBytes();
            chroma.getPointer().write(0L, chromaBytes, 0, chromaBytes.length > 4 ? 4 : chromaBytes.length);
            width.setValue(DefaultDirectMediaPlayer.this.bufferFormat.getWidth());
            height.setValue(DefaultDirectMediaPlayer.this.bufferFormat.getHeight());
            int[] pitchValues = DefaultDirectMediaPlayer.this.bufferFormat.getPitches();
            int[] lineValues = DefaultDirectMediaPlayer.this.bufferFormat.getLines();
            pitches.getPointer().write(0L, pitchValues, 0, pitchValues.length);
            lines.getPointer().write(0L, lineValues, 0, lineValues.length);
            DefaultDirectMediaPlayer.access$802(DefaultDirectMediaPlayer.this, new Memory[DefaultDirectMediaPlayer.this.bufferFormat.getPlaneCount()]);
            for (int i = 0; i < DefaultDirectMediaPlayer.this.bufferFormat.getPlaneCount(); ++i) {
                ((DefaultDirectMediaPlayer)DefaultDirectMediaPlayer.this).nativeBuffers[i] = new Memory(pitchValues[i] * lineValues[i] + 32).align(32);
            }
            Logger.trace("format finished", new Object[0]);
            return pitchValues.length;
        }
    }
}

