/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.component;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.videosurface.CanvasVideoSurface;

public class EmbeddedMediaPlayerComponent
extends Panel
implements MediaPlayerEventListener {
    protected static final String[] DEFAULT_FACTORY_ARGUMENTS = new String[]{"--video-title=vlcj video output", "--no-snapshot-preview", "--quiet", "--quiet-synchro", "--sub-filter=logo:marq", "--intf=dummy"};
    private final MediaPlayerFactory mediaPlayerFactory = this.onGetMediaPlayerFactory();
    private final EmbeddedMediaPlayer mediaPlayer = this.mediaPlayerFactory.newEmbeddedMediaPlayer(this.onGetFullScreenStrategy());
    private final Canvas canvas = this.onGetCanvas();
    private final CanvasVideoSurface videoSurface = this.mediaPlayerFactory.newVideoSurface(this.canvas);
    private Cursor blankCursor;

    public EmbeddedMediaPlayerComponent() {
        this.mediaPlayer.setVideoSurface(this.videoSurface);
        this.setBackground(Color.black);
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
        this.mediaPlayer.addMediaPlayerEventListener(this);
        this.mediaPlayer.setOverlay(this.onGetOverlay());
        this.onAfterConstruct();
    }

    public final MediaPlayerFactory getMediaPlayerFactory() {
        return this.mediaPlayerFactory;
    }

    public final EmbeddedMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public final Canvas getVideoSurface() {
        return this.canvas;
    }

    public final void setCursorEnabled(boolean enabled) {
        this.setCursor(enabled ? null : this.getBlankCursor());
    }

    public final void release() {
        this.onBeforeRelease();
        this.mediaPlayer.release();
        this.onAfterRelease();
    }

    public final void release(boolean releaseFactory) {
        Logger.debug("release(releaseFactory={})", releaseFactory);
        this.release();
        if (releaseFactory) {
            Logger.debug("Releasing media player factory", new Object[0]);
            this.mediaPlayerFactory.release();
        }
    }

    private Cursor getBlankCursor() {
        if (this.blankCursor == null) {
            BufferedImage blankImage = new BufferedImage(1, 1, 2);
            this.blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(blankImage, new Point(0, 0), "");
        }
        return this.blankCursor;
    }

    protected MediaPlayerFactory onGetMediaPlayerFactory() {
        return new MediaPlayerFactory(this.onGetMediaPlayerFactoryArgs());
    }

    protected String[] onGetMediaPlayerFactoryArgs() {
        return DEFAULT_FACTORY_ARGUMENTS;
    }

    protected FullScreenStrategy onGetFullScreenStrategy() {
        return null;
    }

    protected Canvas onGetCanvas() {
        Canvas canvas = new Canvas();
        canvas.setBackground(Color.black);
        return canvas;
    }

    protected Window onGetOverlay() {
        return null;
    }

    protected void onAfterConstruct() {
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }

    @Override
    public void mediaChanged(MediaPlayer mediaPlayer, libvlc_media_t media, String mrl) {
    }

    @Override
    public void opening(MediaPlayer mediaPlayer) {
    }

    @Override
    public void buffering(MediaPlayer mediaPlayer, float newCache) {
    }

    @Override
    public void playing(MediaPlayer mediaPlayer) {
    }

    @Override
    public void paused(MediaPlayer mediaPlayer) {
    }

    @Override
    public void stopped(MediaPlayer mediaPlayer) {
    }

    @Override
    public void forward(MediaPlayer mediaPlayer) {
    }

    @Override
    public void backward(MediaPlayer mediaPlayer) {
    }

    @Override
    public void finished(MediaPlayer mediaPlayer) {
    }

    @Override
    public void timeChanged(MediaPlayer mediaPlayer, long newTime) {
    }

    @Override
    public void positionChanged(MediaPlayer mediaPlayer, float newPosition) {
    }

    @Override
    public void seekableChanged(MediaPlayer mediaPlayer, int newSeekable) {
    }

    @Override
    public void pausableChanged(MediaPlayer mediaPlayer, int newSeekable) {
    }

    @Override
    public void titleChanged(MediaPlayer mediaPlayer, int newTitle) {
    }

    @Override
    public void snapshotTaken(MediaPlayer mediaPlayer, String filename) {
    }

    @Override
    public void lengthChanged(MediaPlayer mediaPlayer, long newLength) {
    }

    @Override
    public void videoOutput(MediaPlayer mediaPlayer, int newCount) {
    }

    @Override
    public void error(MediaPlayer mediaPlayer) {
    }

    @Override
    public void mediaMetaChanged(MediaPlayer mediaPlayer, int metaType) {
    }

    @Override
    public void mediaSubItemAdded(MediaPlayer mediaPlayer, libvlc_media_t subItem) {
    }

    @Override
    public void mediaDurationChanged(MediaPlayer mediaPlayer, long newDuration) {
    }

    @Override
    public void mediaParsedChanged(MediaPlayer mediaPlayer, int newStatus) {
    }

    @Override
    public void mediaFreed(MediaPlayer mediaPlayer) {
    }

    @Override
    public void mediaStateChanged(MediaPlayer mediaPlayer, int newState) {
    }

    @Override
    public void newMedia(MediaPlayer mediaPlayer) {
    }

    @Override
    public void subItemPlayed(MediaPlayer mediaPlayer, int subItemIndex) {
    }

    @Override
    public void subItemFinished(MediaPlayer mediaPlayer, int subItemIndex) {
    }

    @Override
    public void endOfSubItems(MediaPlayer mediaPlayer) {
    }
}

