/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.Native;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.COM.IUnknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;

public class COMObject {
    public static final WinDef.LCID LOCALE_USER_DEFAULT = Kernel32.INSTANCE.GetUserDefaultLCID();
    public static final WinDef.LCID LOCALE_SYSTEM_DEFAULT = Kernel32.INSTANCE.GetSystemDefaultLCID();
    protected IUnknown iUnknown;
    protected IDispatch iDispatch;
    private PointerByReference pDispatch = new PointerByReference();
    private PointerByReference pUnknown = new PointerByReference();

    public COMObject(IDispatch iDispatch) {
        this.iDispatch = iDispatch;
    }

    public COMObject(String progId, boolean useActiveInstance) throws COMException {
        Native.setProtected(true);
        WinNT.HRESULT hr = Ole32.INSTANCE.CoInitialize(null);
        if (COMUtils.FAILED(hr)) {
            this.release();
            throw new COMException("CoInitialize() failed!");
        }
        Guid.CLSID.ByReference clsid = new Guid.CLSID.ByReference();
        hr = Ole32.INSTANCE.CLSIDFromProgID(progId, clsid);
        if (COMUtils.FAILED(hr)) {
            Ole32.INSTANCE.CoUninitialize();
            throw new COMException("CLSIDFromProgID() failed!");
        }
        if (useActiveInstance) {
            hr = OleAuto.INSTANCE.GetActiveObject(clsid, null, this.pUnknown);
            if (COMUtils.SUCCEEDED(hr)) {
                this.iUnknown = new IUnknown(this.pUnknown.getValue());
                hr = this.iUnknown.QueryInterface(IDispatch.IID_IDispatch, this.pDispatch);
            } else {
                hr = Ole32.INSTANCE.CoCreateInstance(clsid, null, 21, IDispatch.IID_IDispatch, this.pDispatch);
            }
        } else {
            hr = Ole32.INSTANCE.CoCreateInstance(clsid, null, 21, IDispatch.IID_IDispatch, this.pDispatch);
        }
        if (COMUtils.FAILED(hr)) {
            throw new COMException("COM object with ProgID '" + progId + "' and CLSID " + clsid.toGuidString() + " not registered properly!");
        }
        this.iDispatch = new IDispatch(this.pDispatch.getValue());
    }

    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, String name, Variant.VARIANT[] pArgs) throws COMException {
        if (pDisp == null) {
            throw new COMException("pDisp (IDispatch) parameter is null!");
        }
        WString[] ptName = new WString[]{new WString(name)};
        OleAuto.DISPPARAMS dp = new OleAuto.DISPPARAMS();
        OaIdl.DISPIDbyReference pdispID = new OaIdl.DISPIDbyReference();
        Variant.VariantArg.ByReference variantArg = new Variant.VariantArg.ByReference();
        variantArg.variantArg = pArgs;
        OaIdl.EXCEPINFO.ByReference pExcepInfo = new OaIdl.EXCEPINFO.ByReference();
        IntByReference puArgErr = new IntByReference();
        WinNT.HRESULT hr = pDisp.GetIDsOfNames(Guid.IID_NULL, ptName, 1, LOCALE_USER_DEFAULT, pdispID);
        COMUtils.checkAutoRC(hr);
        if (nType == 4) {
            dp.cNamedArgs = new WinDef.UINT((long)pArgs.length);
            dp.rgdispidNamedArgs = new OaIdl.DISPIDbyReference(OaIdl.DISPID_PROPERTYPUT);
        }
        if (pArgs != null && pArgs.length > 0) {
            dp.cArgs = new WinDef.UINT((long)pArgs.length);
            dp.rgvarg = variantArg;
            dp.write();
        }
        hr = pDisp.Invoke(pdispID.getValue(), Guid.IID_NULL, LOCALE_SYSTEM_DEFAULT, new OaIdl.DISPID(nType), dp, pvResult, pExcepInfo, puArgErr);
        COMUtils.checkAutoRC(hr, pExcepInfo, puArgErr);
        return hr;
    }

    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, String name, Variant.VARIANT pArg) throws COMException {
        return this.oleMethod(nType, pvResult, pDisp, name, new Variant.VARIANT[]{pArg});
    }

    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, String name) throws COMException {
        return this.oleMethod(nType, pvResult, pDisp, name, (Variant.VARIANT[])null);
    }

    protected void checkFailed(WinNT.HRESULT hr) {
        COMUtils.checkAutoRC(hr, null, null);
    }

    public IDispatch getIDispatch() {
        return this.iDispatch;
    }

    public PointerByReference getIDispatchPointer() {
        return this.pDispatch;
    }

    public IUnknown getIUnknown() {
        return this.iUnknown;
    }

    public PointerByReference getIUnknownPointer() {
        return this.pUnknown;
    }

    public void release() {
        if (this.iDispatch != null) {
            this.iDispatch.Release();
        }
        Ole32.INSTANCE.CoUninitialize();
    }
}

