/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.proposal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalContainer;

public class ProposalDatabase
implements TreeModel {
    protected List<ProposalContainer> changeSet = new ArrayList<ProposalContainer>();
    protected List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    protected String root = new String("Navrhovan\u00e9 zm\u011bny");

    public void addContainer(ProposalContainer newContainer) {
        assert (!this.changeSet.contains(newContainer)) : "Containers in the database must unique.";
        this.changeSet.add(newContainer);
    }

    public void removeContainer(ProposalContainer containerToAdd) {
        this.changeSet.remove(containerToAdd);
    }

    public ProposalContainer findContainer(OsmPrimitive primitive) {
        for (ProposalContainer pac : this.changeSet) {
            if (!pac.getTarget().equals((Object)primitive)) continue;
            return pac;
        }
        return null;
    }

    public void addProposals(OsmPrimitive primitive, Collection<Proposal> proposal) {
        ProposalContainer container = this.findContainer(primitive);
        if (container == null) {
            container = new ProposalContainer(primitive);
            this.addContainer(container);
        }
        container.addProposals(proposal);
    }

    public void setContainers(ArrayList<ProposalContainer> newChangeSet) {
        this.changeSet = newChangeSet;
    }

    public void clear() {
        this.changeSet.clear();
    }

    public List<ProposalContainer> getContainers() {
        return this.changeSet;
    }

    public void applyAll() {
        for (ProposalContainer a : this.changeSet) {
            a.applyAll();
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent.equals(this.root)) {
            return this.changeSet.get(index);
        }
        if (parent instanceof ProposalContainer) {
            return ((ProposalContainer)parent).getProposals().get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent.equals(this.root)) {
            return this.changeSet.size();
        }
        if (parent instanceof ProposalContainer) {
            return ((ProposalContainer)parent).getProposals().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node.equals(this.root)) {
            return this.changeSet.size() == 0;
        }
        if (node instanceof ProposalContainer) {
            return ((ProposalContainer)node).getProposals().size() == 0;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent.equals(this.root)) {
            return this.changeSet.indexOf(child);
        }
        if (parent instanceof ProposalContainer) {
            return ((ProposalContainer)parent).getProposals().indexOf(child);
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public void deteleObjectAtPath(TreePath path) {
        if (path.getPathCount() <= 1) {
            return;
        }
        if (path.getPathCount() == 2) {
            this.changeSet.remove((ProposalContainer)path.getPathComponent(1));
            TreeModelEvent event = new TreeModelEvent((Object)this, path);
            for (TreeModelListener l : this.listeners) {
                l.treeNodesRemoved(event);
            }
            return;
        }
        ProposalContainer ac = (ProposalContainer)path.getPathComponent(1);
        if (path.getPathCount() == 3) {
            ac.getProposals().remove((Proposal)path.getPathComponent(2));
            TreeModelEvent event = new TreeModelEvent((Object)this, path);
            for (TreeModelListener l : this.listeners) {
                l.treeNodesRemoved(event);
            }
            return;
        }
        assert (false) : path;
    }
}

