/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.gui.ChooserLauncher;
import org.openstreetmap.josm.plugins.opendata.core.io.InputStreamReaderUnbuffered;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.AbstractMapInfoReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifDatum;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifProjection;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;

public class MifReader
extends AbstractMapInfoReader {
    private final AbstractDataSetHandler handler;
    private File file;
    private InputStream stream;
    protected Charset charset;
    protected BufferedReader midReader;
    private Character delimiter = Character.valueOf('\t');
    private State state = State.UNKNOWN;
    private Projection josmProj;
    private DataSet ds;
    private Relation region;
    private Way polygon;
    private Node node;
    private Way polyline;
    private String units;
    private Double originLon;
    private Double originLat;
    private Double stdP1;
    private Double stdP2;
    private Double scaleFactor;
    private Double falseEasting;
    private Double falseNorthing;
    private Double minx;
    private Double miny;
    private Double maxx;
    private Double maxy;
    private int numpolygons = -1;
    private int numpts = -1;
    private int numsections = -1;

    private MifReader(AbstractDataSetHandler handler) {
        this.handler = handler;
    }

    public static DataSet parseDataSet(InputStream in, File file, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        return new MifReader(handler).parse(in, file, instance, Charset.forName("ISO-8859-15"));
    }

    private void parseDelimiter(String[] words) {
        this.delimiter = Character.valueOf(words[1].charAt(1));
    }

    private void parseUnique(String[] words) {
        Main.warn((String)("TODO Unique: " + this.line));
    }

    private void parseIndex(String[] words) {
        Main.warn((String)("TODO Index: " + this.line));
    }

    private static String param(CustomProjection.Param p, Object value) {
        return " +" + p.key + "=" + value;
    }

    private void parseCoordSysSyntax1(String[] words) {
        int offset;
        MifProjection proj = MifProjection.forCode(Integer.parseInt(words[3]));
        MifDatum datum = MifDatum.forCode(Integer.parseInt(words[4]));
        int n = offset = datum == MifDatum.CUSTOM ? 4 : 0;
        if (proj == MifProjection.Longitude_Latitude) {
            this.josmProj = Projections.getProjectionByCode((String)"EPSG:4326");
            return;
        }
        String params = MifReader.param(CustomProjection.Param.proj, proj.getProj4Id());
        this.units = words[5 + offset];
        params = params + MifReader.param(CustomProjection.Param.units, this.units);
        this.originLon = Double.parseDouble(words[6 + offset]);
        params = params + MifReader.param(CustomProjection.Param.lon_0, this.originLon);
        switch (proj) {
            case Albers_Equal_Area_Conic: 
            case Azimuthal_Equidistant_polar_aspect_only: 
            case Equidistant_Conic_also_known_as_Simple_Conic: 
            case Hotine_Oblique_Mercator: 
            case Lambert_Azimuthal_Equal_Area_polar_aspect_only: 
            case Lambert_Conformal_Conic: 
            case Lambert_Conformal_Conic_modified_for_Belgium_1972: 
            case New_Zealand_Map_Grid: 
            case Stereographic: 
            case Swiss_Oblique_Mercator: 
            case Transverse_Mercator_also_known_as_Gauss_Kruger: 
            case Transverse_Mercator_modified_for_Danish_System_34_Jylland_Fyn: 
            case Transverse_Mercator_modified_for_Danish_System_45_Bornholm: 
            case Transverse_Mercator_modified_for_Finnish_KKJ: 
            case Transverse_Mercator_modified_for_Sjaelland: 
            case Polyconic: {
                this.originLat = Double.parseDouble(words[7 + offset]);
                params = params + MifReader.param(CustomProjection.Param.lat_0, this.originLat);
            }
        }
        switch (proj) {
            case Cylindrical_Equal_Area: 
            case Regional_Mercator: {
                this.stdP1 = Double.parseDouble(words[7 + offset]);
                params = params + MifReader.param(CustomProjection.Param.lat_1, this.stdP1);
                break;
            }
            case Albers_Equal_Area_Conic: 
            case Equidistant_Conic_also_known_as_Simple_Conic: 
            case Lambert_Conformal_Conic: 
            case Lambert_Conformal_Conic_modified_for_Belgium_1972: {
                this.stdP1 = Double.parseDouble(words[8 + offset]);
                params = params + MifReader.param(CustomProjection.Param.lat_1, this.stdP1);
            }
        }
        switch (proj) {
            case Albers_Equal_Area_Conic: 
            case Equidistant_Conic_also_known_as_Simple_Conic: 
            case Lambert_Conformal_Conic: 
            case Lambert_Conformal_Conic_modified_for_Belgium_1972: {
                this.stdP2 = Double.parseDouble(words[9 + offset]);
                params = params + MifReader.param(CustomProjection.Param.lat_2, this.stdP2);
            }
        }
        if (proj == MifProjection.Hotine_Oblique_Mercator) {
            Double.parseDouble(words[8 + offset]);
        }
        switch (proj) {
            case Hotine_Oblique_Mercator: {
                this.scaleFactor = Double.parseDouble(words[9 + offset]);
                params = params + MifReader.param(CustomProjection.Param.k_0, this.scaleFactor);
                break;
            }
            case Stereographic: 
            case Transverse_Mercator_also_known_as_Gauss_Kruger: 
            case Transverse_Mercator_modified_for_Danish_System_34_Jylland_Fyn: 
            case Transverse_Mercator_modified_for_Danish_System_45_Bornholm: 
            case Transverse_Mercator_modified_for_Finnish_KKJ: 
            case Transverse_Mercator_modified_for_Sjaelland: {
                this.scaleFactor = Double.parseDouble(words[8 + offset]);
                params = params + MifReader.param(CustomProjection.Param.k_0, this.scaleFactor);
            }
        }
        switch (proj) {
            case Albers_Equal_Area_Conic: 
            case Equidistant_Conic_also_known_as_Simple_Conic: 
            case Hotine_Oblique_Mercator: 
            case Lambert_Conformal_Conic: 
            case Lambert_Conformal_Conic_modified_for_Belgium_1972: {
                this.falseEasting = Double.parseDouble(words[10 + offset]);
                this.falseNorthing = Double.parseDouble(words[11 + offset]);
                params = params + MifReader.param(CustomProjection.Param.x_0, this.falseEasting);
                params = params + MifReader.param(CustomProjection.Param.y_0, this.falseNorthing);
                break;
            }
            case Stereographic: 
            case Transverse_Mercator_also_known_as_Gauss_Kruger: 
            case Transverse_Mercator_modified_for_Danish_System_34_Jylland_Fyn: 
            case Transverse_Mercator_modified_for_Danish_System_45_Bornholm: 
            case Transverse_Mercator_modified_for_Finnish_KKJ: 
            case Transverse_Mercator_modified_for_Sjaelland: {
                this.falseEasting = Double.parseDouble(words[9 + offset]);
                this.falseNorthing = Double.parseDouble(words[10 + offset]);
                params = params + MifReader.param(CustomProjection.Param.x_0, this.falseEasting);
                params = params + MifReader.param(CustomProjection.Param.y_0, this.falseNorthing);
                break;
            }
            case New_Zealand_Map_Grid: 
            case Swiss_Oblique_Mercator: 
            case Polyconic: {
                this.falseEasting = Double.parseDouble(words[8 + offset]);
                this.falseNorthing = Double.parseDouble(words[9 + offset]);
                params = params + MifReader.param(CustomProjection.Param.x_0, this.falseEasting);
                params = params + MifReader.param(CustomProjection.Param.y_0, this.falseNorthing);
            }
        }
        switch (proj) {
            case Azimuthal_Equidistant_polar_aspect_only: 
            case Lambert_Azimuthal_Equal_Area_polar_aspect_only: {
                Double.parseDouble(words[8 + offset]);
            }
        }
        switch (proj) {
            case Lambert_Conformal_Conic: {
                if (datum != MifDatum.GEODETIC_REFERENCE_SYSTEM_1980_GRS_80 && datum != MifDatum.CUSTOM || !MifReader.equals(this.originLon, 3.0)) break;
                if (MifReader.equals(this.originLat, 46.5) && MifReader.equals(this.stdP1, 44.0) && MifReader.equals(this.stdP2, 49.0) && MifReader.equals(this.falseEasting, 700000.0) && MifReader.equals(this.falseNorthing, 6600000.0)) {
                    this.josmProj = Projections.getProjectionByCode((String)"EPSG:2154");
                    break;
                }
                if (!MifReader.equals(this.falseEasting, 1700000.0)) break;
                for (int i = 0; this.josmProj == null && i < 9; ++i) {
                    if (!MifReader.equals(this.originLat, 42.0 + (double)i) || !MifReader.equals(this.stdP1, 41.25 + (double)i) || !MifReader.equals(this.stdP2, 42.75 + (double)i) || !MifReader.equals(this.falseNorthing, (double)(i + 1) * 1000000.0 + 200000.0)) continue;
                    this.josmProj = Projections.getProjectionByCode((String)("EPSG:" + Integer.toString(3942 + i)));
                }
                break;
            }
        }
        int index = this.parseAffineUnits(words);
        this.parseBounds(words, index);
        if (this.josmProj == null) {
            Main.info((String)this.line);
            Main.info((String)params);
            this.josmProj = new CustomProjection(params);
        }
    }

    private void parseCoordSysSyntax2(String[] words) {
        int index = this.parseAffineUnits(words);
        this.units = words[index + 1];
        this.parseBounds(words, index + 2);
    }

    private int parseAffineUnits(String[] words) {
        return 2;
    }

    private void parseBounds(String[] words, int index) {
        if (index < words.length && "Bounds".equals(words[index])) {
            this.minx = Double.parseDouble(words[index + 1].substring(1));
            this.miny = Double.parseDouble(words[index + 2].substring(0, words[index + 2].length() - 1));
            this.maxx = Double.parseDouble(words[index + 3].substring(1));
            this.maxy = Double.parseDouble(words[index + 4].substring(0, words[index + 4].length() - 1));
            if (Main.isTraceEnabled()) {
                Main.trace((String)(Arrays.toString(words) + " -> " + this.minx + "," + this.miny + "," + this.maxx + "," + this.maxy));
            }
        }
    }

    private void parseCoordSys(String[] words) {
        for (int i = 0; i < words.length; ++i) {
            words[i] = words[i].replace(",", "");
        }
        switch (words[1].toLowerCase()) {
            case "earth": {
                this.parseCoordSysSyntax1(words);
                break;
            }
            case "nonearth": {
                this.parseCoordSysSyntax2(words);
                if (this.handler != null && this.handler.getMifHandler() != null && this.handler.getMifHandler().getCoordSysNonEarthProjection() != null) {
                    this.josmProj = this.handler.getMifHandler().getCoordSysNonEarthProjection();
                    break;
                }
                this.josmProj = ChooserLauncher.askForProjection(NullProgressMonitor.INSTANCE);
                break;
            }
            case "layout": 
            case "table": 
            case "window": {
                Main.error((String)("Unsupported CoordSys clause: " + this.line));
                break;
            }
            default: {
                Main.error((String)("Line " + this.lineNum + ". Invalid CoordSys clause: " + this.line));
            }
        }
    }

    private void parseTransform(String[] words) {
        Main.warn((String)("TODO Transform: " + this.line));
    }

    @Override
    protected void parseColumns(String[] words) {
        super.parseColumns(words);
        this.state = State.READING_COLUMNS;
    }

    private void parseData(String[] words) {
        if (this.ds == null) {
            this.ds = new DataSet();
        }
    }

    private void parsePoint(String[] words) throws IOException {
        this.readAttributes((OsmPrimitive)this.createNode(words[1], words[2]));
    }

    private void parseLine(String[] words) throws IOException {
        Way line = new Way();
        this.ds.addPrimitive((OsmPrimitive)line);
        this.readAttributes((OsmPrimitive)line);
        line.addNode(this.createNode(words[1], words[2]));
        line.addNode(this.createNode(words[3], words[4]));
    }

    private void startPolyLineSegment(boolean initial) throws IOException {
        Way previousPolyline = this.polyline;
        this.polyline = new Way();
        this.ds.addPrimitive((OsmPrimitive)this.polyline);
        if (initial) {
            this.readAttributes((OsmPrimitive)this.polyline);
        } else if (previousPolyline != null) {
            this.polyline.setKeys(previousPolyline.getKeys());
        }
        this.state = State.READING_POINTS;
    }

    private void parsePLine(String[] words) throws IOException {
        this.numsections = 1;
        if (words.length <= 1 || "MULTIPLE".equalsIgnoreCase(words[1])) {
            this.numpts = -1;
            this.state = State.START_POLYLINE_SEGMENT;
            if (words.length >= 3) {
                this.numsections = Integer.parseInt(words[2]);
            }
        } else {
            this.numpts = Integer.parseInt(words[1]);
            this.startPolyLineSegment(true);
        }
    }

    private void parseRegion(String[] words) throws IOException {
        this.numpolygons = Integer.parseInt(words[1]);
        if (this.numpolygons > 1) {
            this.region = new Relation();
            this.region.put("type", "multipolygon");
            this.ds.addPrimitive((OsmPrimitive)this.region);
            this.readAttributes((OsmPrimitive)this.region);
        } else {
            this.region = null;
        }
        this.state = State.START_POLYGON;
    }

    private void parseArc(String[] words) {
        Main.warn((String)("TODO Arc: " + this.line));
    }

    private void parseText(String[] words) {
        Main.warn((String)("TODO Text: " + this.line));
    }

    private void parseRect(String[] words) {
        Main.warn((String)("TODO Rect: " + this.line));
    }

    private void parseRoundRect(String[] words) {
        Main.warn((String)("TODO RoundRect: " + this.line));
    }

    private void parseEllipse(String[] words) {
        Main.warn((String)("TODO Ellipse: " + this.line));
    }

    private void initializeReaders(InputStream in, File f, Charset cs, int bufSize) throws IOException {
        this.stream = in;
        this.charset = cs;
        this.file = f;
        Reader isr = bufSize < 8192 ? new InputStreamReaderUnbuffered(in, this.charset) : new InputStreamReader(in, this.charset);
        this.headerReader = new BufferedReader(isr, bufSize);
        if (this.midReader != null) {
            this.midReader.close();
        }
        this.midReader = this.getDataReader(this.file, ".mid", this.charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet parse(InputStream in, File file, ProgressMonitor instance, Charset cs) throws IOException {
        DataSet dataSet;
        block6: {
            try {
                this.initializeReaders(in, file, cs, 1);
                this.parseHeader();
                dataSet = this.ds;
                if (this.midReader == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (this.midReader != null) {
                        this.midReader.close();
                    }
                    throw throwable;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IOException(e);
                }
            }
            this.midReader.close();
        }
        return dataSet;
    }

    @Override
    protected void parseHeaderLine(String[] words) throws IOException {
        if (words[0].equalsIgnoreCase("Version")) {
            this.parseVersion(words);
        } else if (words[0].equalsIgnoreCase("Charset")) {
            this.initializeReaders(this.stream, this.file, this.parseCharset(words), 8192);
        } else if (words[0].equalsIgnoreCase("Delimiter")) {
            this.parseDelimiter(words);
        } else if (words[0].equalsIgnoreCase("Unique")) {
            this.parseUnique(words);
        } else if (words[0].equalsIgnoreCase("Index")) {
            this.parseIndex(words);
        } else if (words[0].equalsIgnoreCase("CoordSys")) {
            this.parseCoordSys(words);
        } else if (words[0].equalsIgnoreCase("Transform")) {
            this.parseTransform(words);
        } else if (words[0].equalsIgnoreCase("Columns")) {
            this.parseColumns(words);
        } else if (words[0].equalsIgnoreCase("Data")) {
            this.parseData(words);
        } else if (this.ds != null) {
            if (this.state == State.START_POLYGON) {
                this.numpts = Integer.parseInt(words[0]);
                this.polygon = new Way();
                this.ds.addPrimitive((OsmPrimitive)this.polygon);
                if (this.region != null) {
                    this.region.addMember(new RelationMember("outer", (OsmPrimitive)this.polygon));
                } else {
                    this.readAttributes((OsmPrimitive)this.polygon);
                }
                this.state = State.READING_POINTS;
            } else if (this.state == State.START_POLYLINE_SEGMENT) {
                this.numpts = Integer.parseInt(words[0]);
                this.startPolyLineSegment(this.polyline != null);
            } else if (this.state == State.READING_POINTS && this.numpts > 0) {
                if (this.josmProj != null) {
                    this.node = this.createNode(words[0], words[1]);
                    if (this.polygon != null) {
                        this.polygon.addNode(this.node);
                    } else if (this.polyline != null) {
                        this.polyline.addNode(this.node);
                    }
                }
                if (--this.numpts == 0) {
                    if (this.numpolygons > -1) {
                        if (!this.polygon.isClosed()) {
                            this.polygon.addNode(this.polygon.firstNode());
                        }
                        if (--this.numpolygons > 0) {
                            this.state = State.START_POLYGON;
                        } else {
                            this.state = State.END_POLYGON;
                            this.polygon = null;
                        }
                    } else if (this.polyline != null) {
                        if (--this.numsections > 0) {
                            this.state = State.START_POLYLINE_SEGMENT;
                        } else {
                            this.state = State.UNKNOWN;
                            this.polyline = null;
                        }
                    }
                }
            } else if (words[0].equalsIgnoreCase("Point")) {
                this.parsePoint(words);
            } else if (words[0].equalsIgnoreCase("Line")) {
                this.parseLine(words);
            } else if (words[0].equalsIgnoreCase("PLine")) {
                this.parsePLine(words);
            } else if (words[0].equalsIgnoreCase("Region")) {
                this.parseRegion(words);
            } else if (words[0].equalsIgnoreCase("Arc")) {
                this.parseArc(words);
            } else if (words[0].equalsIgnoreCase("Text")) {
                this.parseText(words);
            } else if (words[0].equalsIgnoreCase("Rect")) {
                this.parseRect(words);
            } else if (words[0].equalsIgnoreCase("RoundRect")) {
                this.parseRoundRect(words);
            } else if (words[0].equalsIgnoreCase("Ellipse")) {
                this.parseEllipse(words);
            } else if (!(words[0].equalsIgnoreCase("Pen") || words[0].equalsIgnoreCase("Brush") || words[0].equalsIgnoreCase("Center") || words[0].equalsIgnoreCase("Symbol") || words[0].equalsIgnoreCase("Font") || words[0].isEmpty())) {
                Main.warn((String)("Line " + this.lineNum + ". Unknown clause in data section: " + this.line));
            }
        } else if (this.state == State.READING_COLUMNS && this.numcolumns > 0) {
            this.columns.add(words[0]);
            if (--this.numcolumns == 0) {
                this.state = State.UNKNOWN;
            }
        } else if (!this.line.isEmpty()) {
            Main.warn((String)("Line " + this.lineNum + ". Unknown clause in header: " + this.line));
        }
    }

    protected void readAttributes(OsmPrimitive p) throws IOException {
        String midLine;
        if (this.midReader != null && (midLine = this.midReader.readLine()) != null) {
            String[] fields = OdUtils.stripQuotesAndExtraChars(midLine.split(this.delimiter.toString()), this.delimiter.toString());
            if (this.columns.size() != fields.length) {
                Main.error((String)("Incoherence between MID and MIF files (" + this.columns.size() + " columns vs " + fields.length + " fields)"));
            }
            for (int i = 0; i < Math.min(this.columns.size(), fields.length); ++i) {
                String field = fields[i].trim();
                if (field.isEmpty()) continue;
                p.put((String)this.columns.get(i), field);
            }
        }
    }

    protected final Node createNode(String x, String y) {
        Node node = new Node(this.josmProj.eastNorth2latlon(new EastNorth(Double.parseDouble(x), Double.parseDouble(y))));
        this.ds.addPrimitive((OsmPrimitive)node);
        return node;
    }

    public static boolean equals(Double a, Double b) {
        if (a == b) {
            return true;
        }
        return Math.abs(a - b) < 1.0E-7;
    }

    private static enum State {
        UNKNOWN,
        READING_COLUMNS,
        START_POLYGON,
        READING_POINTS,
        END_POLYGON,
        START_POLYLINE_SEGMENT,
        END_POLYLINE;

    }
}

