/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.model.RecordOrderer;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.model.RowBlocksReader;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.CalcCountRecord;
import org.apache.poi.hssf.record.CalcModeRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.DeltaRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.GridsetRecord;
import org.apache.poi.hssf.record.GutsRecord;
import org.apache.poi.hssf.record.IterationRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.RefModeRecord;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SaveRecalcRecord;
import org.apache.poi.hssf.record.SelectionRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.WindowTwoRecord;
import org.apache.poi.hssf.record.aggregates.ColumnInfoRecordsAggregate;
import org.apache.poi.hssf.record.aggregates.DataValidityTable;
import org.apache.poi.hssf.record.aggregates.MergedCellsTable;
import org.apache.poi.hssf.record.aggregates.RowRecordsAggregate;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

@Internal
public final class InternalSheet {
    private static POILogger log = POILogFactory.getLogger(InternalSheet.class);
    private List<RecordBase> _records;
    protected GridsetRecord gridset = null;
    private GutsRecord _gutsRecord;
    protected WindowTwoRecord windowTwo = null;
    protected SelectionRecord _selection = null;
    private final MergedCellsTable _mergedCellsTable = new MergedCellsTable();
    ColumnInfoRecordsAggregate _columnInfos;
    private DimensionsRecord _dimensions;
    protected final RowRecordsAggregate _rowsAggregate;
    private DataValidityTable _dataValidityTable = null;
    private Iterator<RowRecord> rowRecIterator = null;

    public static InternalSheet createSheet(RecordStream recordStream) {
        return new InternalSheet(recordStream);
    }

    private InternalSheet(RecordStream recordStream) {
        RowRecordsAggregate rowRecordsAggregate = null;
        ArrayList<RecordBase> arrayList = new ArrayList<RecordBase>(128);
        this._records = arrayList;
        int n = -1;
        if (recordStream.peekNextSid() != 2057) {
            throw new RuntimeException("BOF record expected");
        }
        BOFRecord bOFRecord = (BOFRecord)recordStream.getNext();
        if (bOFRecord.getType() != 16) {
            // empty if block
        }
        arrayList.add(bOFRecord);
        while (recordStream.hasNext()) {
            Object object;
            int n2 = recordStream.peekNextSid();
            if (n2 == 125) {
                this._columnInfos = new ColumnInfoRecordsAggregate(recordStream);
                arrayList.add(this._columnInfos);
                continue;
            }
            if (n2 == 434) {
                this._dataValidityTable = new DataValidityTable(recordStream);
                arrayList.add(this._dataValidityTable);
                continue;
            }
            if (RecordOrderer.isRowBlockRecord(n2)) {
                if (rowRecordsAggregate != null) {
                    throw new RuntimeException("row/cell records found in the wrong place");
                }
                object = new RowBlocksReader(recordStream);
                this._mergedCellsTable.addRecords(((RowBlocksReader)object).getLooseMergedCells());
                rowRecordsAggregate = new RowRecordsAggregate(((RowBlocksReader)object).getPlainRecordStream(), ((RowBlocksReader)object).getSharedFormulaManager());
                arrayList.add(rowRecordsAggregate);
                continue;
            }
            if (n2 == 229) {
                this._mergedCellsTable.read(recordStream);
                continue;
            }
            if (n2 == 2057) continue;
            object = recordStream.getNext();
            if (n2 == 523 || n2 == 94) continue;
            if (n2 == 2152 || n2 == 2151) {
                arrayList.add((RecordBase)object);
                continue;
            }
            if (n2 == 10) {
                arrayList.add((RecordBase)object);
                break;
            }
            if (n2 == 512) {
                if (this._columnInfos == null) {
                    this._columnInfos = new ColumnInfoRecordsAggregate();
                    arrayList.add(this._columnInfos);
                }
                this._dimensions = (DimensionsRecord)object;
                n = arrayList.size();
            } else if (n2 == 130) {
                this.gridset = (GridsetRecord)object;
            } else if (n2 == 29) {
                this._selection = (SelectionRecord)object;
            } else if (n2 == 574) {
                this.windowTwo = (WindowTwoRecord)object;
            } else if (n2 == 128) {
                this._gutsRecord = (GutsRecord)object;
            }
            arrayList.add((RecordBase)object);
        }
        if (this.windowTwo == null) {
            throw new RuntimeException("WINDOW2 was not found");
        }
        if (this._dimensions == null) {
            if (rowRecordsAggregate == null) {
                rowRecordsAggregate = new RowRecordsAggregate();
            } else {
                log.log(POILogger.WARN, "DIMENSION record not found even though row/cells present");
            }
            n = this.findFirstRecordLocBySid((short)574);
            this._dimensions = rowRecordsAggregate.createDimensions();
            arrayList.add(n, this._dimensions);
        }
        if (rowRecordsAggregate == null) {
            rowRecordsAggregate = new RowRecordsAggregate();
            arrayList.add(n + 1, rowRecordsAggregate);
        }
        this._rowsAggregate = rowRecordsAggregate;
        RecordOrderer.addNewSheetRecord(arrayList, this._mergedCellsTable);
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "sheet createSheet (existing file) exited");
        }
    }

    private InternalSheet() {
        ArrayList<RecordBase> arrayList = new ArrayList<RecordBase>(32);
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "Sheet createsheet from scratch called");
        }
        arrayList.add(InternalSheet.createBOF());
        arrayList.add(InternalSheet.createCalcMode());
        arrayList.add(InternalSheet.createCalcCount());
        arrayList.add(InternalSheet.createRefMode());
        arrayList.add(InternalSheet.createIteration());
        arrayList.add(InternalSheet.createDelta());
        arrayList.add(InternalSheet.createSaveRecalc());
        this.gridset = InternalSheet.createGridset();
        arrayList.add(this.gridset);
        this._gutsRecord = InternalSheet.createGuts();
        arrayList.add(this._gutsRecord);
        arrayList.add(InternalSheet.createWSBool());
        ColumnInfoRecordsAggregate columnInfoRecordsAggregate = new ColumnInfoRecordsAggregate();
        arrayList.add(columnInfoRecordsAggregate);
        this._columnInfos = columnInfoRecordsAggregate;
        this._dimensions = InternalSheet.createDimensions();
        arrayList.add(this._dimensions);
        this._rowsAggregate = new RowRecordsAggregate();
        arrayList.add(this._rowsAggregate);
        this.windowTwo = InternalSheet.createWindowTwo();
        arrayList.add(this.windowTwo);
        this._selection = InternalSheet.createSelection();
        arrayList.add(this._selection);
        arrayList.add(this._mergedCellsTable);
        arrayList.add(EOFRecord.instance);
        this._records = arrayList;
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "Sheet createsheet from scratch exit");
        }
    }

    public RowRecordsAggregate getRowsAggregate() {
        return this._rowsAggregate;
    }

    public void addValueRecord(int n, CellValueRecordInterface cellValueRecordInterface) {
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "add value record  row" + n);
        }
        DimensionsRecord dimensionsRecord = this._dimensions;
        if (cellValueRecordInterface.getColumn() > dimensionsRecord.getLastCol()) {
            dimensionsRecord.setLastCol((short)(cellValueRecordInterface.getColumn() + 1));
        }
        if (cellValueRecordInterface.getColumn() < dimensionsRecord.getFirstCol()) {
            dimensionsRecord.setFirstCol(cellValueRecordInterface.getColumn());
        }
        this._rowsAggregate.insertCell(cellValueRecordInterface);
    }

    public void replaceValueRecord(CellValueRecordInterface cellValueRecordInterface) {
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "replaceValueRecord ");
        }
        this._rowsAggregate.removeCell(cellValueRecordInterface);
        this._rowsAggregate.insertCell(cellValueRecordInterface);
    }

    public void addRow(RowRecord rowRecord) {
        RowRecord rowRecord2;
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "addRow ");
        }
        DimensionsRecord dimensionsRecord = this._dimensions;
        if (rowRecord.getRowNumber() >= dimensionsRecord.getLastRow()) {
            dimensionsRecord.setLastRow(rowRecord.getRowNumber() + 1);
        }
        if (rowRecord.getRowNumber() < dimensionsRecord.getFirstRow()) {
            dimensionsRecord.setFirstRow(rowRecord.getRowNumber());
        }
        if ((rowRecord2 = this._rowsAggregate.getRow(rowRecord.getRowNumber())) != null) {
            this._rowsAggregate.removeRow(rowRecord2);
        }
        this._rowsAggregate.insertRow(rowRecord);
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "exit addRow");
        }
    }

    public CellValueRecordInterface[] getValueRecords() {
        return this._rowsAggregate.getValueRecords();
    }

    public RowRecord getNextRow() {
        if (this.rowRecIterator == null) {
            this.rowRecIterator = this._rowsAggregate.getIterator();
        }
        if (!this.rowRecIterator.hasNext()) {
            return null;
        }
        return this.rowRecIterator.next();
    }

    static BOFRecord createBOF() {
        BOFRecord bOFRecord = new BOFRecord();
        bOFRecord.setVersion(1536);
        bOFRecord.setType(16);
        bOFRecord.setBuild(3515);
        bOFRecord.setBuildYear(1996);
        bOFRecord.setHistoryBitMask(193);
        bOFRecord.setRequiredVersion(6);
        return bOFRecord;
    }

    private static CalcModeRecord createCalcMode() {
        CalcModeRecord calcModeRecord = new CalcModeRecord();
        calcModeRecord.setCalcMode((short)1);
        return calcModeRecord;
    }

    private static CalcCountRecord createCalcCount() {
        CalcCountRecord calcCountRecord = new CalcCountRecord();
        calcCountRecord.setIterations((short)100);
        return calcCountRecord;
    }

    private static RefModeRecord createRefMode() {
        RefModeRecord refModeRecord = new RefModeRecord();
        refModeRecord.setMode((short)1);
        return refModeRecord;
    }

    private static IterationRecord createIteration() {
        return new IterationRecord(false);
    }

    private static DeltaRecord createDelta() {
        return new DeltaRecord(0.001);
    }

    private static SaveRecalcRecord createSaveRecalc() {
        SaveRecalcRecord saveRecalcRecord = new SaveRecalcRecord();
        saveRecalcRecord.setRecalc(true);
        return saveRecalcRecord;
    }

    private static GridsetRecord createGridset() {
        GridsetRecord gridsetRecord = new GridsetRecord();
        gridsetRecord.setGridset(true);
        return gridsetRecord;
    }

    private static GutsRecord createGuts() {
        GutsRecord gutsRecord = new GutsRecord();
        gutsRecord.setLeftRowGutter((short)0);
        gutsRecord.setTopColGutter((short)0);
        gutsRecord.setRowLevelMax((short)0);
        gutsRecord.setColLevelMax((short)0);
        return gutsRecord;
    }

    private static WSBoolRecord createWSBool() {
        WSBoolRecord wSBoolRecord = new WSBoolRecord();
        wSBoolRecord.setWSBool1((byte)4);
        wSBoolRecord.setWSBool2((byte)-63);
        return wSBoolRecord;
    }

    public short getXFIndexForColAt(short s) {
        ColumnInfoRecord columnInfoRecord = this._columnInfos.findColumnInfo(s);
        if (columnInfoRecord != null) {
            return (short)columnInfoRecord.getXFIndex();
        }
        return 15;
    }

    private static DimensionsRecord createDimensions() {
        DimensionsRecord dimensionsRecord = new DimensionsRecord();
        dimensionsRecord.setFirstCol((short)0);
        dimensionsRecord.setLastRow(1);
        dimensionsRecord.setFirstRow(0);
        dimensionsRecord.setLastCol((short)1);
        return dimensionsRecord;
    }

    private static WindowTwoRecord createWindowTwo() {
        WindowTwoRecord windowTwoRecord = new WindowTwoRecord();
        windowTwoRecord.setOptions((short)1718);
        windowTwoRecord.setTopRow((short)0);
        windowTwoRecord.setLeftCol((short)0);
        windowTwoRecord.setHeaderColor(64);
        windowTwoRecord.setPageBreakZoom((short)0);
        windowTwoRecord.setNormalZoom((short)0);
        return windowTwoRecord;
    }

    private static SelectionRecord createSelection() {
        return new SelectionRecord(0, 0);
    }

    public int findFirstRecordLocBySid(short s) {
        int n = this._records.size();
        for (int i = 0; i < n; ++i) {
            Record record;
            RecordBase recordBase = this._records.get(i);
            if (!(recordBase instanceof Record) || (record = (Record)recordBase).getSid() != s) continue;
            return i;
        }
        return -1;
    }
}

