/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;

public class PhotoAdjustWorker {
    private ImageEntry dragPhoto = null;
    private GeoImageLayer dragLayer = null;
    private Point2D dragOffset = null;

    public void reset() {
        this.dragPhoto = null;
        this.dragLayer = null;
        this.dragOffset = null;
    }

    public void doMousePressed(MouseEvent evt, List<GeoImageLayer> imageLayers) {
        block1: {
            block2: {
                this.reset();
                if (evt.getButton() != 1 || imageLayers == null || imageLayers.size() <= 0) break block1;
                if ((evt.getModifiers() & 1) == 0) break block2;
                GeoImageLayer viewerLayer = ImageViewerDialog.getCurrentLayer();
                ImageEntry img = ImageViewerDialog.getCurrentImage();
                if (img == null || viewerLayer == null || !viewerLayer.isVisible() || !imageLayers.contains(viewerLayer)) break block1;
                img.setPos(Main.map.mapView.getLatLon(evt.getX(), evt.getY()));
                img.flagNewGpsData();
                viewerLayer.updateBufferAndRepaint();
                ImageViewerDialog.showImage((GeoImageLayer)viewerLayer, (ImageEntry)img);
                this.dragPhoto = img;
                this.dragLayer = viewerLayer;
                break block1;
            }
            for (GeoImageLayer layer : imageLayers) {
                if (!layer.isVisible()) continue;
                this.dragPhoto = layer.getPhotoUnderMouse(evt);
                if (this.dragPhoto == null) continue;
                this.dragLayer = layer;
                Point2D centerPoint = Main.map.mapView.getPoint2D((LatLon)this.dragPhoto.getPos());
                this.dragOffset = new Point2D.Double(centerPoint.getX() - (double)evt.getX(), centerPoint.getY() - (double)evt.getY());
                break;
            }
        }
    }

    public void doMouseDragged(MouseEvent evt) {
        if (this.dragLayer != null && this.dragLayer.isVisible() && this.dragPhoto != null) {
            LatLon newPos = this.dragOffset != null ? Main.map.mapView.getLatLon(this.dragOffset.getX() + (double)evt.getX(), this.dragOffset.getY() + (double)evt.getY()) : Main.map.mapView.getLatLon(evt.getX(), evt.getY());
            this.dragPhoto.setPos(newPos);
            this.dragPhoto.flagNewGpsData();
            this.dragLayer.updateBufferAndRepaint();
        }
    }
}

