/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2;

import org.openstreetmap.josm.data.coor.LatLon;

public class TracerGeometry {
    public static double angleOfLines(LatLon a, LatLon b, LatLon c, LatLon d) {
        return Math.abs(Math.atan2(a.lat() - b.lat(), a.lon() - b.lon()) - Math.atan2(c.lat() - d.lat(), c.lon() - d.lon())) / Math.PI * 180.0 % 360.0;
    }

    public static double distanceFromSegment(LatLon c, LatLon a, LatLon b) {
        return TracerGeometry.distanceFromSegment(c.getX(), c.getY(), a.getX(), a.getY(), b.getX(), b.getY());
    }

    private static double distanceFromSegment(double cx, double cy, double ax, double ay, double bx, double by) {
        double r_numerator = (cx - ax) * (bx - ax) + (cy - ay) * (by - ay);
        double r_denomenator = (bx - ax) * (bx - ax) + (by - ay) * (by - ay);
        if (r_denomenator == 0.0) {
            System.out.println("r_denomenator == 0    ------------");
        }
        double r = r_numerator / r_denomenator;
        double s = ((ay - cy) * (bx - ax) - (ax - cx) * (by - ay)) / r_denomenator;
        double distanceLine = Math.abs(s) * Math.sqrt(r_denomenator);
        if (r >= 0.0 && r <= 1.0) {
            return distanceLine;
        }
        double dist1 = (cx - ax) * (cx - ax) + (cy - ay) * (cy - ay);
        double dist2 = (cx - bx) * (cx - bx) + (cy - by) * (cy - by);
        if (dist1 < dist2) {
            return Math.sqrt(dist1);
        }
        return Math.sqrt(dist2);
    }
}

