/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.multitagger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;

public class MultiTaggerTableModel
extends AbstractTableModel
implements SelectionChangedListener {
    ArrayList<OsmPrimitive> list = new ArrayList(50);
    String[] mainTags = new String[0];
    boolean[] isSpecialTag = new boolean[0];
    Set<OsmPrimitiveType> shownTypes = new HashSet<OsmPrimitiveType>();
    private boolean autoCommit = true;
    List<Command> cmds = new ArrayList<Command>();
    private boolean watchSelection = true;
    private JTable table;

    public MultiTaggerTableModel() {
        Collections.addAll(this.shownTypes, OsmPrimitiveType.values());
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.mainTags.length + 1;
    }

    public void setWatchSelection(boolean watchSelection) {
        this.watchSelection = watchSelection;
        if (watchSelection && Main.main.hasEditLayer()) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.list.get(rowIndex).getDisplayType();
        }
        if (!this.isSpecialTag[columnIndex - 1]) {
            return this.list.get(rowIndex).get(this.mainTags[columnIndex - 1]);
        }
        String var = this.mainTags[columnIndex - 1];
        OsmPrimitive p = this.list.get(rowIndex);
        if (var.equals("id")) {
            return String.valueOf(p.getUniqueId());
        }
        if (var.equals("type")) {
            return OsmPrimitiveType.from((IPrimitive)p).getAPIName().substring(0, 1).toUpperCase();
        }
        if (var.equals("area")) {
            if (p.getDisplayType() == OsmPrimitiveType.CLOSEDWAY) {
                return String.format("%.1f", Geometry.closedWayArea((Way)((Way)p)));
            }
            return "";
        }
        if (var.equals("length") && p instanceof Way) {
            return String.format("%.1f", ((Way)p).getLength());
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return OsmPrimitiveType.class;
        }
        return String.class;
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (this.watchSelection) {
            this.updateData(newSelection);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        return !this.isSpecialTag[columnIndex - 1];
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        String key;
        if (columnIndex == 0 || this.isSpecialTag[columnIndex - 1]) {
            return;
        }
        if (columnIndex >= this.getColumnCount() || rowIndex >= this.getRowCount()) {
            return;
        }
        if (value == null) {
            value = "";
        }
        String val = ((String)value).trim();
        OsmPrimitive sel = this.list.get(rowIndex);
        String newValue = sel.get(key = this.mainTags[columnIndex - 1]);
        if (newValue == null) {
            newValue = "";
        }
        if (!val.equals(newValue)) {
            ChangePropertyCommand cmd = new ChangePropertyCommand(sel, key, (String)value);
            if (this.autoCommit) {
                Main.main.undoRedo.add((Command)cmd);
            } else {
                this.cmds.add((Command)cmd);
            }
        }
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "";
        }
        return this.mainTags[column - 1];
    }

    public OsmPrimitive getPrimitiveAt(int number) {
        if (number < 0 || number >= this.list.size()) {
            return null;
        }
        return this.list.get(number);
    }

    public void setupColumnsFromText(String txt) {
        String[] tags = txt.trim().split("[\\s,]+");
        this.mainTags = new String[tags.length];
        this.isSpecialTag = new boolean[tags.length];
        int i = 0;
        for (String t : tags) {
            if (t.startsWith("${") && t.endsWith("}")) {
                this.mainTags[i] = t.substring(2, t.length() - 1).trim();
                this.isSpecialTag[i] = true;
            } else {
                this.mainTags[i] = t;
                this.isSpecialTag[i] = false;
            }
            ++i;
        }
    }

    public String getSearchExpression() {
        StringBuilder sb = new StringBuilder();
        boolean notFirst = false;
        for (int i = 0; i < this.mainTags.length; ++i) {
            if (this.isSpecialTag[i]) continue;
            if (notFirst) {
                sb.append(" | ");
            }
            sb.append("\"");
            sb.append(this.mainTags[i]);
            sb.append("\":");
            notFirst = true;
        }
        return sb.toString();
    }

    void updateData(Collection<? extends OsmPrimitive> sel) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.list.clear();
        for (OsmPrimitive osmPrimitive : sel) {
            if (!this.shownTypes.contains(osmPrimitive.getDisplayType())) continue;
            this.list.add(osmPrimitive);
        }
        this.fireTableDataChanged();
    }

    void setAutoCommit(boolean b) {
        this.autoCommit = b;
    }

    void commit(String commandTitle) {
        Main.main.undoRedo.add((Command)new SequenceCommand(commandTitle, this.cmds));
        this.cmds.clear();
    }

    void setTable(JTable t) {
        this.table = t;
    }
}

