/*
 * Decompiled with CFR 0.152.
 */
package geochat;

import java.util.Date;
import org.openstreetmap.josm.data.coor.LatLon;

public class ChatMessage
implements Comparable<ChatMessage> {
    private LatLon pos;
    private Date time;
    private String author;
    private String recipient;
    private String message;
    private long id;
    private boolean priv;
    private boolean incoming;

    public ChatMessage(long id, LatLon pos, String author, boolean incoming, String message, Date time) {
        this.id = id;
        this.author = author;
        this.message = message;
        this.pos = pos;
        this.time = time;
        this.incoming = incoming;
        this.priv = false;
        this.recipient = null;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setPrivate(boolean priv) {
        this.priv = priv;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public long getId() {
        return this.id;
    }

    public LatLon getPosition() {
        return this.pos;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isPrivate() {
        return this.priv;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public Date getTime() {
        return this.time;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChatMessage other = (ChatMessage)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }

    @Override
    public int compareTo(ChatMessage o) {
        long otherId = o.id;
        return otherId < this.id ? 1 : (otherId == this.id ? 0 : 1);
    }
}

