/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.WeakReference;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Fun;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;
import org.mapdb.SerializerPojo;
import org.mapdb.Utils;

public class AsyncWriteEngine
extends EngineWrapper
implements Engine {
    protected static final AtomicLong threadCounter = new AtomicLong();
    protected final long threadNum = threadCounter.incrementAndGet();
    protected final BlockingQueue<Long> newRecids = new ArrayBlockingQueue<Long>(128);
    protected volatile boolean closeInProgress = false;
    protected final CountDownLatch shutdownCondition = new CountDownLatch(2);
    protected final int asyncFlushDelay;
    protected static final Object DELETED = new Object();
    protected final ReentrantLock[] writeLocks = Utils.newLocks(32);
    protected final ReentrantReadWriteLock commitLock;
    protected Throwable writerFailedException = null;
    protected final LongConcurrentHashMap<Fun.Tuple2<Object, Serializer<Object>>> items = new LongConcurrentHashMap();
    protected final Thread newRecidsThread = new Thread("MapDB prealloc #" + this.threadNum){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!AsyncWriteEngine.this.closeInProgress) {
                    if (AsyncWriteEngine.this.parentEngineWeakRef != null) {
                        if (AsyncWriteEngine.this.parentEngineWeakRef.get() == null) return;
                    }
                    if (AsyncWriteEngine.this.writerFailedException != null) {
                        return;
                    }
                    Long newRecid = AsyncWriteEngine.this.getWrappedEngine().put("", Serializer.EMPTY_SERIALIZER);
                    AsyncWriteEngine.this.newRecids.put(newRecid);
                }
                return;
            }
            catch (Throwable e) {
                AsyncWriteEngine.this.writerFailedException = e;
                return;
            }
            finally {
                AsyncWriteEngine.this.shutdownCondition.countDown();
            }
        }
    };
    protected final Thread writerThread = new Thread("MapDB writer #" + this.threadNum){

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 0[TRYBLOCK], 13[WHILELOOP]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };
    protected WeakReference<Engine> parentEngineWeakRef = null;

    protected AsyncWriteEngine(Engine engine, boolean _transactionsDisabled, boolean _powerSavingMode, int _asyncFlushDelay) {
        super(engine);
        this.newRecidsThread.setDaemon(true);
        this.writerThread.setDaemon(true);
        this.commitLock = _transactionsDisabled ? null : new ReentrantReadWriteLock();
        this.newRecidsThread.start();
        this.writerThread.start();
        this.asyncFlushDelay = _asyncFlushDelay;
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        if (this.commitLock != null) {
            this.commitLock.readLock().lock();
        }
        try {
            Long recid = this.newRecids.take();
            this.update(recid, value, serializer);
            long l = recid;
            return l;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.commitLock != null) {
                this.commitLock.readLock().unlock();
            }
        }
    }

    protected void checkState() {
        if (this.closeInProgress) {
            throw new IllegalAccessError("db has been closed");
        }
        if (this.writerFailedException != null) {
            throw new RuntimeException("Writer thread failed", this.writerFailedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        if (this.commitLock != null) {
            this.commitLock.readLock().lock();
        }
        try {
            block12: {
                Fun.Tuple2<Object, Serializer<Object>> item;
                block13: {
                    A a;
                    Utils.lock(this.writeLocks, recid);
                    try {
                        this.checkState();
                        item = this.items.get(recid);
                        if (item == null) break block12;
                        if (item.a != DELETED) break block13;
                        a = null;
                    }
                    catch (Throwable throwable) {
                        Utils.unlock(this.writeLocks, recid);
                        throw throwable;
                    }
                    Utils.unlock(this.writeLocks, recid);
                    return a;
                }
                Object a = item.a;
                Utils.unlock(this.writeLocks, recid);
                return a;
            }
            A a = super.get(recid, serializer);
            Utils.unlock(this.writeLocks, recid);
            return a;
        }
        finally {
            if (this.commitLock != null) {
                this.commitLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        if (this.commitLock != null && serializer != SerializerPojo.serializer) {
            this.commitLock.readLock().lock();
        }
        try {
            Utils.lock(this.writeLocks, recid);
            try {
                this.checkState();
                this.items.put(recid, new Fun.Tuple2<A, Serializer<A>>(value, serializer));
            }
            finally {
                Utils.unlock(this.writeLocks, recid);
            }
        }
        finally {
            if (this.commitLock != null && serializer != SerializerPojo.serializer) {
                this.commitLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        Utils.lock(this.writeLocks, recid);
        try {
            Object oldValue;
            this.checkState();
            Fun.Tuple2<Object, Serializer<Object>> existing = this.items.get(recid);
            Object a = oldValue = existing != null ? existing.a : super.get(recid, serializer);
            if (oldValue == expectedOldValue || oldValue != null && oldValue.equals(expectedOldValue)) {
                this.items.put(recid, new Fun.Tuple2<A, Serializer<A>>(newValue, serializer));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Utils.unlock(this.writeLocks, recid);
        }
    }

    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        this.update(recid, DELETED, serializer);
    }

    @Override
    public void close() {
        try {
            if (this.closeInProgress) {
                return;
            }
            this.closeInProgress = true;
            Long recid = (Long)this.newRecids.poll();
            while (recid != null) {
                super.delete(recid, Serializer.EMPTY_SERIALIZER);
                recid = (Long)this.newRecids.poll();
            }
            this.shutdownCondition.await();
            super.close();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setParentEngineReference(Engine parentEngineReference) {
        this.parentEngineWeakRef = new WeakReference<Engine>(parentEngineReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.checkState();
        if (this.commitLock == null) {
            super.commit();
            return;
        }
        this.commitLock.writeLock().lock();
        try {
            while (!this.items.isEmpty()) {
                this.checkState();
                LockSupport.parkNanos(100L);
            }
            super.commit();
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        this.checkState();
        if (this.commitLock == null) {
            throw new UnsupportedOperationException("transactions disabled");
        }
        this.commitLock.writeLock().lock();
        try {
            while (!this.items.isEmpty()) {
                LockSupport.parkNanos(100L);
            }
            this.newRecids.clear();
            super.rollback();
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    static /* synthetic */ void access$001(AsyncWriteEngine x0, long x1, Serializer x2) {
        super.delete(x1, x2);
    }

    static /* synthetic */ void access$101(AsyncWriteEngine x0, long x1, Object x2, Serializer x3) {
        super.update(x1, x2, x3);
    }

    static /* synthetic */ void access$201(AsyncWriteEngine x0, long x1, Serializer x2) {
        super.delete(x1, x2);
    }

    static /* synthetic */ void access$301(AsyncWriteEngine x0, long x1, Object x2, Serializer x3) {
        super.update(x1, x2, x3);
    }
}

