/*
 * Decompiled with CFR 0.152.
 */
package nanolog;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import nanolog.NanoLogEntry;
import nanolog.NanoLogLayer;
import nanolog.NanoLogPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;

public class NanoLogPlugin
extends Plugin {
    public NanoLogPlugin(PluginInformation info) {
        super(info);
        Main.main.menu.fileMenu.insert((Action)((Object)new OpenNanoLogLayerAction()), 4);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            NanoLogPanel panel = new NanoLogPanel();
            newFrame.addToggleDialog((ToggleDialog)panel);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)panel);
        }
    }

    private class OpenNanoLogLayerAction
    extends JosmAction {
        public OpenNanoLogLayerAction() {
            super(I18n.tr((String)"Open NanoLog file...", (Object[])new Object[0]), "nanolog.png", I18n.tr((String)"Open NanoLog file...", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            if (fc.showOpenDialog(Main.parent) == 0) {
                try {
                    List<NanoLogEntry> entries = NanoLogLayer.readNanoLog(fc.getSelectedFile());
                    if (!entries.isEmpty()) {
                        NanoLogLayer layer = new NanoLogLayer(entries);
                        Main.main.addLayer((Layer)layer);
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read NanoLog file:", (Object[])new Object[0]) + "\n" + ex.getMessage());
                }
            }
        }
    }
}

