/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geotools;

import com.sun.media.jai.imageioimpl.ImageReadWriteSpi;
import java.io.IOException;
import java.io.InputStream;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;

public class GeoToolsPlugin
extends Plugin {
    public GeoToolsPlugin(PluginInformation info) {
        super(info);
        this.initJAI();
        this.initGeoTools();
        this.checkEPSG();
    }

    private void initJAI() {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
        if (registry == null) {
            Main.error((String)"geotools: error in JAI initialization. Cannot access default operation registry");
        } else {
            try {
                new ImageReadWriteSpi().updateRegistry(registry);
            }
            catch (IllegalArgumentException e) {
                Main.warn((String)("geotools: error in JAI/ImageReadWriteSpi initialization: " + e.getMessage()));
            }
            try (InputStream in = GeoToolsPlugin.class.getResourceAsStream("/META-INF/registryFile.jai");){
                if (in == null) {
                    Main.error((String)"geotools: error in JAI initialization. Cannot access META-INF/registryFile.jai");
                } else {
                    registry.updateFromStream(in);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                Main.error((String)("geotools: error in JAI/GeoTools initialization: " + e.getMessage()));
            }
        }
    }

    private void initGeoTools() {
        System.setProperty("org.geotools.referencing.forceXY", "true");
    }

    private void checkEPSG() {
        try {
            CRS.decode("EPSG:4326");
        }
        catch (NoSuchAuthorityCodeException e) {
            Main.error((String)("geotools: error in EPSG database initialization. NoSuchAuthorityCodeException: " + e.getMessage()));
        }
        catch (FactoryException e) {
            Main.error((String)("geotools: error in EPSG database initialization. FactoryException: " + e.getMessage()));
        }
    }
}

