/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.VolatileFunction;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.GmlObjectId;
import org.opengis.filter.identity.Identifier;

public class SimplifyingFilterVisitor
extends DuplicatingFilterVisitor {
    FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
    public static final FIDValidator ANY_FID_VALID = new FIDValidator(){

        @Override
        public boolean isValid(String fid) {
            return true;
        }
    };
    private FIDValidator fidValidator = ANY_FID_VALID;

    public void setFIDValidator(FIDValidator validator) {
        this.fidValidator = validator == null ? ANY_FID_VALID : validator;
    }

    @Override
    public Object visit(And filter, Object extraData) {
        ArrayList<Filter> newChildren = new ArrayList<Filter>(filter.getChildren().size());
        for (Filter child : filter.getChildren()) {
            Filter cloned = (Filter)child.accept(this, extraData);
            if (cloned == Filter.EXCLUDE) {
                return Filter.EXCLUDE;
            }
            if (cloned == Filter.INCLUDE) continue;
            if (cloned instanceof And) {
                And and = (And)cloned;
                newChildren.addAll(and.getChildren());
                continue;
            }
            newChildren.add(cloned);
        }
        for (int i = 0; i < newChildren.size(); ++i) {
            int j = i + 1;
            while (j < newChildren.size()) {
                Filter f2;
                Filter f1 = (Filter)newChildren.get(i);
                if (f1.equals(f2 = (Filter)newChildren.get(j))) {
                    newChildren.remove(j);
                    continue;
                }
                if (this.dualFilters(f1, f2)) {
                    return Filter.EXCLUDE;
                }
                ++j;
            }
        }
        if (newChildren.size() == 0) {
            return Filter.INCLUDE;
        }
        if (newChildren.size() == 1) {
            return newChildren.get(0);
        }
        return this.getFactory(extraData).and(newChildren);
    }

    private boolean dualFilters(Filter f1, Filter f2) {
        if (f1 instanceof Not) {
            Not not = (Not)f1;
            return f2.equals(not.getFilter());
        }
        if (f2 instanceof Not) {
            Not not = (Not)f2;
            return f1.equals(not.getFilter());
        }
        return false;
    }

    @Override
    public Object visit(Or filter, Object extraData) {
        ArrayList<Filter> newChildren = new ArrayList<Filter>(filter.getChildren().size());
        for (Filter child : filter.getChildren()) {
            Filter cloned = (Filter)child.accept(this, extraData);
            if (cloned == Filter.INCLUDE) {
                return Filter.INCLUDE;
            }
            if (cloned == Filter.EXCLUDE) continue;
            if (cloned instanceof Or) {
                Or or = (Or)cloned;
                newChildren.addAll(or.getChildren());
                continue;
            }
            newChildren.add(cloned);
        }
        for (int i = 0; i < newChildren.size(); ++i) {
            int j = i + 1;
            while (j < newChildren.size()) {
                Filter f2;
                Filter f1 = (Filter)newChildren.get(i);
                if (f1.equals(f2 = (Filter)newChildren.get(j))) {
                    newChildren.remove(j);
                    continue;
                }
                if (this.dualFilters(f1, f2)) {
                    return Filter.INCLUDE;
                }
                ++j;
            }
        }
        if (newChildren.size() == 0) {
            return Filter.EXCLUDE;
        }
        if (newChildren.size() == 1) {
            return newChildren.get(0);
        }
        return this.getFactory(extraData).or(newChildren);
    }

    @Override
    public Object visit(Id filter, Object extraData) {
        if (filter.getIDs().size() == 0) {
            return Filter.EXCLUDE;
        }
        HashSet<Identifier> validFids = new HashSet<Identifier>();
        for (Identifier id : filter.getIdentifiers()) {
            if (!(id instanceof FeatureId) && !(id instanceof GmlObjectId) || !this.fidValidator.isValid((String)id.getID())) continue;
            validFids.add(id);
        }
        Filter validIdFilter = validFids.size() == 0 ? Filter.EXCLUDE : this.getFactory(extraData).id(validFids);
        return validIdFilter;
    }

    @Override
    public Object visit(Not filter, Object extraData) {
        if (filter.getFilter() instanceof Not) {
            Not inner = (Not)filter.getFilter();
            return inner.getFilter().accept(this, extraData);
        }
        return super.visit(filter, extraData);
    }

    @Override
    public Object visit(Function function, Object extraData) {
        if (function instanceof VolatileFunction) {
            return super.visit(function, extraData);
        }
        if (this.attributeExtractor == null) {
            this.attributeExtractor = new FilterAttributeExtractor();
        } else {
            this.attributeExtractor.clear();
        }
        function.accept(this.attributeExtractor, null);
        if (this.attributeExtractor.isConstantExpression()) {
            Object result = function.evaluate(null);
            return this.ff.literal(result);
        }
        return super.visit(function, extraData);
    }

    public static Filter simplify(Filter filter) {
        if (filter == Filter.INCLUDE || filter == Filter.EXCLUDE || filter == null) {
            return filter;
        }
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        return (Filter)filter.accept(visitor, null);
    }

    private boolean isConstant(Expression ex) {
        if (ex instanceof Literal) {
            return true;
        }
        if (ex instanceof NilExpression) {
            return true;
        }
        if (ex instanceof PropertyName) {
            return false;
        }
        this.attributeExtractor.clear();
        ex.accept(this.attributeExtractor, null);
        return this.attributeExtractor.isConstantExpression();
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) {
        PropertyIsBetween clone = (PropertyIsBetween)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression()) && this.isConstant(clone.getLowerBoundary()) && this.isConstant(clone.getUpperBoundary())) {
            return this.staticFilterEvaluate(clone);
        }
        return clone;
    }

    private Object staticFilterEvaluate(Filter filter) {
        if (filter.evaluate(null)) {
            return Filter.INCLUDE;
        }
        return Filter.EXCLUDE;
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    private Object simplifyBinaryComparisonOperator(BinaryComparisonOperator clone) {
        if (this.isConstant(clone.getExpression1()) && this.isConstant(clone.getExpression2())) {
            return this.staticFilterEvaluate(clone);
        }
        return clone;
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsLike filter, Object extraData) {
        PropertyIsLike clone = (PropertyIsLike)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression())) {
            return this.staticFilterEvaluate(clone);
        }
        return clone;
    }

    @Override
    public Object visit(PropertyIsNil filter, Object extraData) {
        PropertyIsNil clone = (PropertyIsNil)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression())) {
            return this.staticFilterEvaluate(clone);
        }
        return clone;
    }

    @Override
    public Object visit(PropertyIsNull filter, Object extraData) {
        PropertyIsNull clone = (PropertyIsNull)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression())) {
            return this.staticFilterEvaluate(clone);
        }
        return clone;
    }

    public static class TypeNameDotNumberFidValidator
    extends RegExFIDValidator {
        public TypeNameDotNumberFidValidator(String typeName) {
            super(typeName + "\\.\\d+");
        }
    }

    public static class RegExFIDValidator
    implements FIDValidator {
        private Pattern pattern;

        public RegExFIDValidator(String regularExpression) {
            this.pattern = Pattern.compile(regularExpression);
        }

        @Override
        public boolean isValid(String fid) {
            return this.pattern.matcher(fid).matches();
        }
    }

    public static interface FIDValidator {
        public boolean isValid(String var1);
    }
}

