/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.beans.PropertyChangeEvent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXSearchField;
import org.jdesktop.swingx.plaf.AbstractUIChangeHandler;
import org.jdesktop.swingx.plaf.BuddyTextFieldUI;
import org.jdesktop.swingx.plaf.PromptTextAreaUI;
import org.jdesktop.swingx.plaf.PromptTextUI;
import org.jdesktop.swingx.plaf.SearchFieldUI;
import org.jdesktop.swingx.prompt.BuddySupport;

public abstract class TextUIWrapper<UI extends TextUI> {
    private static final DefaultWrapper defaultWrapper = new DefaultWrapper();
    private Class<UI> wrapperClass;
    private final TextUIChangeHandler uiChangeHandler = new TextUIChangeHandler();

    public static final TextUIWrapper<? extends PromptTextUI> getDefaultWrapper() {
        return defaultWrapper;
    }

    protected TextUIWrapper(Class<UI> wrapperClass) {
        this.wrapperClass = wrapperClass;
    }

    public final void install(JTextComponent textComponent, boolean stayOnUIChange) {
        this.replaceUIIfNeeded(textComponent);
        if (stayOnUIChange) {
            this.uiChangeHandler.install(textComponent);
        }
    }

    protected boolean replaceUIIfNeeded(JTextComponent textComponent) {
        if (this.wrapperClass.isAssignableFrom(textComponent.getUI().getClass())) {
            return false;
        }
        textComponent.setUI((TextUI)this.wrapUI(textComponent));
        return true;
    }

    public abstract UI wrapUI(JTextComponent var1);

    public Class<UI> getWrapperClass() {
        return this.wrapperClass;
    }

    public final void uninstall(JTextComponent textComponent) {
        this.uiChangeHandler.uninstall(textComponent);
        textComponent.updateUI();
    }

    public static final class DefaultWrapper
    extends TextUIWrapper<PromptTextUI> {
        private DefaultWrapper() {
            super(PromptTextUI.class);
        }

        @Override
        public PromptTextUI wrapUI(JTextComponent textComponent) {
            TextUI textUI = textComponent.getUI();
            if (textUI instanceof PromptTextUI) {
                return (PromptTextUI)textUI;
            }
            if (textComponent instanceof JXSearchField) {
                return new SearchFieldUI(textUI);
            }
            if (textComponent instanceof JTextField) {
                return new BuddyTextFieldUI(textUI);
            }
            if (textComponent instanceof JTextArea) {
                return new PromptTextAreaUI(textUI);
            }
            throw new IllegalArgumentException("ui implementation not supported: " + textUI.getClass());
        }

        @Override
        protected boolean replaceUIIfNeeded(JTextComponent textComponent) {
            boolean replaced = super.replaceUIIfNeeded(textComponent);
            if (replaced && textComponent instanceof JTextField) {
                BuddySupport.ensureBuddiesAreInComponentHierarchy((JTextField)textComponent);
            }
            return replaced;
        }
    }

    private final class TextUIChangeHandler
    extends AbstractUIChangeHandler {
        private TextUIChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JTextComponent txt = (JTextComponent)evt.getSource();
            TextUIWrapper.this.replaceUIIfNeeded(txt);
        }
    }
}

