/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import javax.swing.JComponent;
import javax.swing.JViewport;
import org.jdesktop.swingx.util.Contract;

public enum ScrollableSizeHint {
    NONE{

        @Override
        boolean getTracksParentSizeImpl(JComponent component, int orientation) {
            return false;
        }
    }
    ,
    FIT{

        @Override
        boolean getTracksParentSizeImpl(JComponent component, int orientation) {
            return true;
        }
    }
    ,
    MINIMUM_STRETCH{

        @Override
        boolean getTracksParentSizeImpl(JComponent component, int orientation) {
            switch (orientation) {
                case 0: {
                    return component.getParent() instanceof JViewport && component.getParent().getWidth() > component.getMinimumSize().width && component.getParent().getWidth() < component.getMaximumSize().width;
                }
                case 1: {
                    return component.getParent() instanceof JViewport && component.getParent().getHeight() > component.getMinimumSize().height && component.getParent().getHeight() < component.getMaximumSize().height;
                }
            }
            throw new IllegalArgumentException("invalid orientation");
        }
    }
    ,
    PREFERRED_STRETCH{

        @Override
        boolean getTracksParentSizeImpl(JComponent component, int orientation) {
            switch (orientation) {
                case 0: {
                    return component.getParent() instanceof JViewport && component.getParent().getWidth() > component.getPreferredSize().width && component.getParent().getWidth() < component.getMaximumSize().width;
                }
                case 1: {
                    return component.getParent() instanceof JViewport && component.getParent().getHeight() > component.getPreferredSize().height && component.getParent().getHeight() < component.getMaximumSize().height;
                }
            }
            throw new IllegalArgumentException("invalid orientation");
        }
    };


    public boolean getTracksParentSize(JComponent component, int orientation) {
        Contract.asNotNull((Object)component, (String)"component must be not-null");
        return this.getTracksParentSizeImpl(component, orientation);
    }

    abstract boolean getTracksParentSizeImpl(JComponent var1, int var2);
}

