/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.TeeOutputStream;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private OutputStream cOut;
    private boolean oldFormat = false;
    private PGPDigestCalculator digestCalc;
    private OutputStream genOut;
    private PGPDataEncryptorBuilder dataEncryptorBuilder;
    private List methods = new ArrayList();
    private int defAlgorithm;
    private SecureRandom rand;
    private static Provider defProvider;

    public PGPEncryptedDataGenerator(int n, SecureRandom secureRandom, String string) {
        this(new JcePGPDataEncryptorBuilder(n).setSecureRandom(secureRandom).setProvider(string));
    }

    public PGPEncryptedDataGenerator(int n, SecureRandom secureRandom, Provider provider) {
        this(new JcePGPDataEncryptorBuilder(n).setSecureRandom(secureRandom).setProvider(provider));
    }

    public PGPEncryptedDataGenerator(int n, boolean bl, SecureRandom secureRandom, String string) {
        this(new JcePGPDataEncryptorBuilder(n).setWithIntegrityPacket(bl).setSecureRandom(secureRandom).setProvider(string));
    }

    public PGPEncryptedDataGenerator(int n, boolean bl, SecureRandom secureRandom, Provider provider) {
        this(new JcePGPDataEncryptorBuilder(n).setWithIntegrityPacket(bl).setSecureRandom(secureRandom).setProvider(provider));
    }

    public PGPEncryptedDataGenerator(int n, SecureRandom secureRandom, boolean bl, String string) {
        this(new JcePGPDataEncryptorBuilder(n).setSecureRandom(secureRandom).setProvider(string), bl);
    }

    public PGPEncryptedDataGenerator(int n, SecureRandom secureRandom, boolean bl, Provider provider) {
        this(new JcePGPDataEncryptorBuilder(n).setSecureRandom(secureRandom).setProvider(provider), bl);
    }

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder pGPDataEncryptorBuilder) {
        this(pGPDataEncryptorBuilder, false);
    }

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder pGPDataEncryptorBuilder, boolean bl) {
        this.dataEncryptorBuilder = pGPDataEncryptorBuilder;
        this.oldFormat = bl;
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
    }

    public void addMethod(char[] cArray) throws NoSuchProviderException, PGPException {
        this.addMethod(cArray, 2);
    }

    public void addMethod(char[] cArray, int n) throws NoSuchProviderException, PGPException {
        if (defProvider == null) {
            defProvider = new BouncyCastleProvider();
        }
        this.addMethod(new JcePBEKeyEncryptionMethodGenerator(cArray, new JcaPGPDigestCalculatorProviderBuilder().setProvider(defProvider).build().get(n)).setProvider(defProvider).setSecureRandom(this.rand));
    }

    public void addMethod(PGPPublicKey pGPPublicKey) throws NoSuchProviderException, PGPException {
        if (!pGPPublicKey.isEncryptionKey()) {
            throw new IllegalArgumentException("passed in key not an encryption key!");
        }
        if (defProvider == null) {
            defProvider = new BouncyCastleProvider();
        }
        this.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey).setProvider(defProvider).setSecureRandom(this.rand));
    }

    public void addMethod(PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator) {
        this.methods.add(pGPKeyEncryptionMethodGenerator);
    }

    private void addCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 1; i != byArray.length - 2; ++i) {
            n += byArray[i] & 0xFF;
        }
        byArray[byArray.length - 2] = (byte)(n >> 8);
        byArray[byArray.length - 1] = (byte)n;
    }

    private byte[] createSessionInfo(int n, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 3];
        byArray2[0] = (byte)n;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.addCheckSum(byArray2);
        return byArray2;
    }

    private OutputStream open(OutputStream outputStream, long l, byte[] byArray) throws IOException, PGPException, IllegalStateException {
        Object object;
        Object object2;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        byte[] byArray2 = null;
        this.pOut = new BCPGOutputStream(outputStream);
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
        if (this.methods.size() == 1) {
            if (this.methods.get(0) instanceof PBEKeyEncryptionMethodGenerator) {
                object2 = (PBEKeyEncryptionMethodGenerator)this.methods.get(0);
                byArray2 = ((PBEKeyEncryptionMethodGenerator)object2).getKey(this.dataEncryptorBuilder.getAlgorithm());
                this.pOut.writePacket(((PGPKeyEncryptionMethodGenerator)this.methods.get(0)).generate(this.defAlgorithm, null));
            } else {
                byArray2 = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
                object2 = this.createSessionInfo(this.defAlgorithm, byArray2);
                object = (PGPKeyEncryptionMethodGenerator)this.methods.get(0);
                this.pOut.writePacket(((PGPKeyEncryptionMethodGenerator)object).generate(this.defAlgorithm, (byte[])object2));
            }
        } else {
            byArray2 = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            object2 = this.createSessionInfo(this.defAlgorithm, byArray2);
            for (int i = 0; i != this.methods.size(); ++i) {
                PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator = (PGPKeyEncryptionMethodGenerator)this.methods.get(i);
                this.pOut.writePacket(pGPKeyEncryptionMethodGenerator.generate(this.defAlgorithm, (byte[])object2));
            }
        }
        try {
            object2 = this.dataEncryptorBuilder.build(byArray2);
            this.digestCalc = object2.getIntegrityCalculator();
            if (byArray == null) {
                if (this.digestCalc != null) {
                    this.pOut = new ClosableBCPGOutputStream(outputStream, 18, l + (long)object2.getBlockSize() + 2L + 1L + 22L);
                    this.pOut.write(1);
                } else {
                    this.pOut = new ClosableBCPGOutputStream(outputStream, 9, l + (long)object2.getBlockSize() + 2L, this.oldFormat);
                }
            } else if (this.digestCalc != null) {
                this.pOut = new ClosableBCPGOutputStream(outputStream, 18, byArray);
                this.pOut.write(1);
            } else {
                this.pOut = new ClosableBCPGOutputStream(outputStream, 9, byArray);
            }
            this.genOut = this.cOut = object2.getOutputStream(this.pOut);
            if (this.digestCalc != null) {
                this.genOut = new TeeOutputStream(this.digestCalc.getOutputStream(), this.cOut);
            }
            object = new byte[object2.getBlockSize() + 2];
            this.rand.nextBytes((byte[])object);
            object[((Object)object).length - 1] = object[((Object)object).length - 3];
            object[((Object)object).length - 2] = object[((Object)object).length - 4];
            this.genOut.write((byte[])object);
            return new WrappedGeneratorStream(this.genOut, this);
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    public OutputStream open(OutputStream outputStream, long l) throws IOException, PGPException {
        return this.open(outputStream, l, null);
    }

    public OutputStream open(OutputStream outputStream, byte[] byArray) throws IOException, PGPException {
        return this.open(outputStream, 0L, byArray);
    }

    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestCalc != null) {
                BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(this.genOut, 19, 20L);
                bCPGOutputStream.flush();
                byte[] byArray = this.digestCalc.getDigest();
                this.cOut.write(byArray);
            }
            this.cOut.close();
            this.cOut = null;
            this.pOut = null;
        }
    }

    private class ClosableBCPGOutputStream
    extends BCPGOutputStream {
        public ClosableBCPGOutputStream(OutputStream outputStream, int n, byte[] byArray) throws IOException {
            super(outputStream, n, byArray);
        }

        public ClosableBCPGOutputStream(OutputStream outputStream, int n, long l, boolean bl) throws IOException {
            super(outputStream, n, l, bl);
        }

        public ClosableBCPGOutputStream(OutputStream outputStream, int n, long l) throws IOException {
            super(outputStream, n, l);
        }

        public void close() throws IOException {
            this.finish();
        }
    }
}

