/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.util.Date;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

public class BcPGPKeyConverter {
    public PGPPublicKey getPGPPublicKey(int n, AsymmetricKeyParameter asymmetricKeyParameter, Date date) throws PGPException {
        BCPGObject bCPGObject;
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            bCPGObject = new RSAPublicBCPGKey(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent());
        } else if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)asymmetricKeyParameter;
            DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
            bCPGObject = new DSAPublicBCPGKey(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG(), dSAPublicKeyParameters.getY());
        } else if (asymmetricKeyParameter instanceof ElGamalPublicKeyParameters) {
            ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)asymmetricKeyParameter;
            ElGamalParameters elGamalParameters = elGamalPublicKeyParameters.getParameters();
            bCPGObject = new ElGamalPublicBCPGKey(elGamalParameters.getP(), elGamalParameters.getG(), elGamalPublicKeyParameters.getY());
        } else if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricKeyParameter;
            bCPGObject = n == 18 ? new ECDHPublicBCPGKey(null, eCPublicKeyParameters.getQ(), 0, 0) : new ECDSAPublicBCPGKey(null, eCPublicKeyParameters.getQ());
        } else {
            throw new PGPException("unknown key class");
        }
        return new PGPPublicKey(new PublicKeyPacket(n, date, (BCPGKey)((Object)bCPGObject)), new BcKeyFingerprintCalculator());
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, AsymmetricKeyParameter asymmetricKeyParameter) throws PGPException {
        BCPGObject bCPGObject;
        switch (pGPPublicKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricKeyParameter;
                bCPGObject = new RSASecretBCPGKey(rSAPrivateCrtKeyParameters.getExponent(), rSAPrivateCrtKeyParameters.getP(), rSAPrivateCrtKeyParameters.getQ());
                break;
            }
            case 17: {
                DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)asymmetricKeyParameter;
                bCPGObject = new DSASecretBCPGKey(dSAPrivateKeyParameters.getX());
                break;
            }
            case 16: 
            case 20: {
                ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricKeyParameter;
                bCPGObject = new ElGamalSecretBCPGKey(elGamalPrivateKeyParameters.getX());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), (BCPGKey)((Object)bCPGObject));
    }

    public AsymmetricKeyParameter getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new RSAKeyParameters(false, rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    return new DSAPublicKeyParameters(dSAPublicBCPGKey.getY(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    return new ElGamalPublicKeyParameters(elGamalPublicBCPGKey.getY(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    public AsymmetricKeyParameter getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    return new RSAPrivateCrtKeyParameters(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    return new DSAPrivateKeyParameters(dSASecretBCPGKey.getX(), new DSAParameters(dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    return new ElGamalPrivateKeyParameters(elGamalSecretBCPGKey.getX(), new ElGamalParameters(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }
}

