/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tag2link.listeners;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.tag2link.action.OpenLinkAction;
import org.openstreetmap.josm.plugins.tag2link.action.OpenMailAction;
import org.openstreetmap.josm.plugins.tag2link.data.Link;

public abstract class AbstractPopupListener
implements PopupMenuListener {
    protected final MapFrame frame;
    protected final List<JMenuItem> itemList;

    protected AbstractPopupListener(MapFrame frame) {
        this.frame = frame;
        this.itemList = new ArrayList<JMenuItem>();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        JPopupMenu popup = (JPopupMenu)e.getSource();
        for (JMenuItem item : this.itemList) {
            popup.remove(item);
        }
        this.itemList.clear();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    protected void addLink(JPopupMenu popup, Link link) {
        JosmAction action = null;
        action = link.url.matches("mailto:.*") ? new OpenMailAction(link) : new OpenLinkAction(link);
        this.itemList.add(popup.add((Action)action));
    }
}

