/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.preset;

import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedTag
extends Tag {
    private String displayName;
    private boolean optional = false;

    public AdvancedTag() {
    }

    public AdvancedTag(String key, String value) {
        super(key, value);
    }

    public AdvancedTag(String key) {
        super(key);
    }

    public AdvancedTag(Tag tag) {
        super(tag);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public static Collection<AdvancedTag> forTaggingPreset(TaggingPreset preset) {
        ArrayList<AdvancedTag> result = new ArrayList<AdvancedTag>();
        boolean isOptional = false;
        for (TaggingPresetItem item : preset.data) {
            if (item instanceof TaggingPresetItems.KeyedItem) {
                TaggingPresetItems.KeyedItem ki = (TaggingPresetItems.KeyedItem)item;
                for (String value : ki.getValues()) {
                    AdvancedTag tag = new AdvancedTag(ki.key, value);
                    tag.setOptional(isOptional);
                    if (ki.text != null) {
                        if (ki.text_context != null) {
                            tag.setDisplayName(I18n.trc((String)ki.text_context, (String)ki.text));
                        } else {
                            tag.setDisplayName(I18n.tr((String)ki.text, (Object[])new Object[0]));
                        }
                    }
                    result.add(tag);
                }
                continue;
            }
            if (!(item instanceof TaggingPresetItems.Optional)) continue;
            isOptional = true;
        }
        return result;
    }
}

