/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;
import public_transport.GTFSAddCommand;
import public_transport.GTFSCatchCommand;
import public_transport.GTFSDeleteCommand;
import public_transport.GTFSImporterDialog;
import public_transport.GTFSJoinCommand;
import public_transport.GTFSStopTableModel;
import public_transport.TrackReference;

public class GTFSImporterAction
extends JosmAction {
    private static GTFSImporterDialog dialog = null;
    private static DefaultListModel tracksListModel = null;
    private static Vector<String> data = null;
    private static TrackReference currentTrack = null;
    private static GTFSStopTableModel gtfsStopTM = null;
    public boolean inEvent = false;

    public GTFSImporterAction() {
        super(I18n.tr((String)"Create Stops from GTFS ...", (Object[])new Object[0]), null, I18n.tr((String)"Create Stops from a GTFS file", (Object[])new Object[0]), null, false);
        this.putValue("toolbar", "publictransport/gtfsimporter");
        Main.toolbar.register((Action)((Object)this));
    }

    public GTFSStopTableModel getGTFSStopTableModel() {
        return gtfsStopTM;
    }

    public GTFSImporterDialog getDialog() {
        return dialog;
    }

    public DefaultListModel getTracksListModel() {
        if (tracksListModel == null) {
            tracksListModel = new DefaultListModel();
        }
        return tracksListModel;
    }

    public TrackReference getCurrentTrack() {
        return currentTrack;
    }

    public void actionPerformed(ActionEvent event) {
        DataSet mainDataSet = Main.main.getCurrentDataSet();
        if (dialog == null) {
            dialog = new GTFSImporterDialog(this);
        }
        dialog.setVisible(true);
        if (I18n.tr((String)"Create Stops from GTFS ...", (Object[])new Object[0]).equals(event.getActionCommand())) {
            String curDir = Main.pref.get("lastDirectory");
            if (curDir.equals("")) {
                curDir = ".";
            }
            JFileChooser fc = new JFileChooser(new File(curDir));
            fc.setDialogTitle(I18n.tr((String)"Select GTFS file (stops.txt)", (Object[])new Object[0]));
            fc.setMultiSelectionEnabled(false);
            int answer = fc.showOpenDialog(Main.parent);
            if (answer != 0) {
                return;
            }
            if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
                Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
            }
            this.importData(fc.getSelectedFile());
            this.refreshData();
        } else if ("gtfsImporter.gtfsStopsAdd".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new GTFSAddCommand(this));
        } else if ("gtfsImporter.gtfsStopsDelete".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new GTFSDeleteCommand(this));
        } else if ("gtfsImporter.gtfsStopsCatch".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new GTFSCatchCommand(this));
        } else if ("gtfsImporter.gtfsStopsJoin".equals(event.getActionCommand())) {
            Main.main.undoRedo.add((Command)new GTFSJoinCommand(this));
        } else if ("gtfsImporter.gtfsStopsFind".equals(event.getActionCommand())) {
            GTFSImporterAction.findNodesInTable(dialog.getGTFSStopTable(), GTFSImporterAction.gtfsStopTM.nodes);
        } else if ("gtfsImporter.gtfsStopsShow".equals(event.getActionCommand())) {
            GTFSImporterAction.showNodesFromTable(dialog.getGTFSStopTable(), GTFSImporterAction.gtfsStopTM.nodes);
        } else if ("gtfsImporter.gtfsStopsMark".equals(event.getActionCommand())) {
            GTFSImporterAction.markNodesFromTable(dialog.getGTFSStopTable(), GTFSImporterAction.gtfsStopTM.nodes);
        }
    }

    private void importData(File file) {
        try {
            FileReader is = new FileReader(file);
            BufferedReader r = new BufferedReader(is);
            if (data == null) {
                data = new Vector();
            } else {
                data.clear();
            }
            while (r.ready()) {
                data.add(r.readLine());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, I18n.tr((String)"File \"{0}\" does not exist", (Object[])new Object[]{file.getName()}));
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, I18n.tr((String)"IOException \"{0}\" occurred", (Object[])new Object[]{e.toString()}));
        }
    }

    private void refreshData() {
        if (data != null) {
            Vector<Node> existingStops = new Vector<Node>();
            if (Main.main.getCurrentDataSet() == null) {
                JOptionPane.showMessageDialog(null, I18n.tr((String)"There exists no dataset. Try to download data from the server or open an OSM file.", (Object[])new Object[0]), I18n.tr((String)"No data found", (Object[])new Object[0]), 0);
                return;
            }
            for (Node node : Main.main.getCurrentDataSet().getNodes()) {
                if (!"bus_stop".equals(node.get("highway"))) continue;
                existingStops.add(node);
            }
            Iterator<Object> iter = data.iterator();
            if (iter.hasNext()) {
                gtfsStopTM = new GTFSStopTableModel(this, (String)iter.next());
            } else {
                JOptionPane.showMessageDialog(null, I18n.tr((String)"The GTFS file was empty.", (Object[])new Object[0]), I18n.tr((String)"No data found", (Object[])new Object[0]), 0);
                return;
            }
            while (iter.hasNext()) {
                String s = (String)iter.next();
                gtfsStopTM.addRow(s, existingStops);
            }
            dialog.setGTFSStopTableModel(gtfsStopTM);
        } else {
            JOptionPane.showMessageDialog(null, I18n.tr((String)"The GTFS file was empty.", (Object[])new Object[0]), I18n.tr((String)"No data found", (Object[])new Object[0]), 0);
        }
    }

    public static Node createNode(LatLon latLon, String id, String name) {
        Node node = new Node(latLon);
        node.put("highway", "bus_stop");
        node.put("stop_id", id);
        node.put("name", name);
        if (Main.main.getCurrentDataSet() == null) {
            JOptionPane.showMessageDialog(null, I18n.tr((String)"There exists no dataset. Try to download data from the server or open an OSM file.", (Object[])new Object[0]), I18n.tr((String)"No data found", (Object[])new Object[0]), 0);
            return null;
        }
        Main.main.getCurrentDataSet().addPrimitive((OsmPrimitive)node);
        return node;
    }

    public static Vector<Integer> getConsideredLines(JTable table) {
        int[] selectedLines = table.getSelectedRows();
        Vector<Integer> consideredLines = new Vector<Integer>();
        if (selectedLines.length > 0) {
            for (int i = 0; i < selectedLines.length; ++i) {
                consideredLines.add(selectedLines[i]);
            }
        } else {
            for (int i = 0; i < table.getRowCount(); ++i) {
                consideredLines.add(new Integer(i));
            }
        }
        return consideredLines;
    }

    public static void findNodesInTable(JTable table, Vector<Node> nodes) {
        if (Main.main.getCurrentDataSet() == null) {
            return;
        }
        table.clearSelection();
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (nodes.elementAt(i) == null || !Main.main.getCurrentDataSet().isSelected((OsmPrimitive)nodes.elementAt(i))) continue;
            table.addRowSelectionInterval(i, i);
        }
    }

    public static void showNodesFromTable(JTable table, Vector<Node> nodes) {
        BoundingXYVisitor box = new BoundingXYVisitor();
        Vector<Integer> consideredLines = GTFSImporterAction.getConsideredLines(table);
        for (int i = 0; i < consideredLines.size(); ++i) {
            int j = consideredLines.elementAt(i);
            if (nodes.elementAt(j) == null) continue;
            nodes.elementAt(j).accept((Visitor)box);
        }
        if (box.getBounds() == null) {
            return;
        }
        box.enlargeBoundingBox();
        Main.map.mapView.recalculateCenterScale(box);
    }

    public static void markNodesFromTable(JTable table, Vector<Node> nodes) {
        OsmPrimitive[] osmp = new OsmPrimitive[]{null};
        Main.main.getCurrentDataSet().setSelected((PrimitiveId[])osmp);
        Vector<Integer> consideredLines = GTFSImporterAction.getConsideredLines(table);
        for (int i = 0; i < consideredLines.size(); ++i) {
            int j = consideredLines.elementAt(i);
            if (nodes.elementAt(j) == null) continue;
            Main.main.getCurrentDataSet().addSelected(new PrimitiveId[]{(PrimitiveId)nodes.elementAt(j)});
        }
    }

    public static String timeOf(double t) {
        t -= Math.floor(t / 24.0 / 60.0 / 60.0) * 24.0 * 60.0 * 60.0;
        int hour = (int)Math.floor(t / 60.0 / 60.0);
        t -= Math.floor(t / 60.0 / 60.0) * 60.0 * 60.0;
        int minute = (int)Math.floor(t / 60.0);
        t -= Math.floor(t / 60.0) * 60.0;
        double second = t;
        DecimalFormat format = new DecimalFormat("00");
        DecimalFormat formatS = new DecimalFormat("00.###");
        return format.format((Object)hour) + ":" + format.format((Object)minute) + ":" + formatS.format((Object)second);
    }

    public Action getFocusAddAction() {
        return new FocusAddAction();
    }

    private class FocusAddAction
    extends AbstractAction {
        private FocusAddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.main.undoRedo.add((Command)new GTFSAddCommand(GTFSImporterAction.this));
            GTFSImporterAction.showNodesFromTable(dialog.getGTFSStopTable(), gtfsStopTM.nodes);
        }
    }
}

