/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.discovery;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.co.caprica.vlcj.discovery.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.logger.Logger;

public abstract class AbstractNativeDiscoveryStrategy
implements NativeDiscoveryStrategy {
    @Override
    public final String discover() {
        Logger.debug("discover()", new Object[0]);
        String result = null;
        ArrayList<String> directoryNames = new ArrayList<String>();
        this.getDirectoryNames(directoryNames);
        Logger.debug("directoryNames={}", directoryNames);
        for (String directoryName : directoryNames) {
            Logger.debug("directoryName={}", directoryName);
            if (!this.find(directoryName)) continue;
            result = directoryName;
            break;
        }
        Logger.debug("result={}", result);
        return result;
    }

    private boolean find(String directoryName) {
        File dir = new File(directoryName);
        File[] files = dir.listFiles();
        if (files != null) {
            Pattern[] patternsToMatch = this.getFilenamePatterns();
            int matchedCount = 0;
            for (File file : files) {
                for (Pattern pattern : patternsToMatch) {
                    Matcher matcher = pattern.matcher(file.getName());
                    if (!matcher.matches()) continue;
                    Logger.debug("Matched '{}' in '{}'", file.getName(), directoryName);
                    if (++matchedCount != patternsToMatch.length) continue;
                    Logger.debug("Matched all required files", new Object[0]);
                    return true;
                }
            }
        }
        Logger.debug("Failed to matched all required files", new Object[0]);
        return false;
    }

    protected final List<String> getSystemPath() {
        String path = System.getenv("PATH");
        if (path != null) {
            String[] paths = path.split(File.pathSeparator);
            return Arrays.asList(paths);
        }
        return Collections.emptyList();
    }

    protected abstract Pattern[] getFilenamePatterns();

    protected abstract void getDirectoryNames(List<String> var1);
}

