/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.medialist;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_meta_t;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.medialist.MediaListEventListener;
import uk.co.caprica.vlcj.medialist.MediaListItem;
import uk.co.caprica.vlcj.medialist.events.MediaListEvent;
import uk.co.caprica.vlcj.medialist.events.MediaListEventFactory;
import uk.co.caprica.vlcj.player.MediaResourceLocator;
import uk.co.caprica.vlcj.player.NativeString;

public class MediaList {
    private final List<MediaListEventListener> eventListenerList = new ArrayList<MediaListEventListener>();
    private final MediaListEventFactory eventFactory = new MediaListEventFactory(this);
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private final LibVlc libvlc;
    private final libvlc_instance_t instance;
    private libvlc_media_list_t mediaListInstance;
    private libvlc_event_manager_t mediaListEventManager;
    private libvlc_callback_t callback;
    private final AtomicBoolean released = new AtomicBoolean();
    private String[] standardMediaOptions;

    public MediaList(LibVlc libvlc, libvlc_instance_t instance) {
        this(libvlc, instance, null);
    }

    public MediaList(LibVlc libvlc, libvlc_instance_t instance, libvlc_media_list_t mediaListInstance) {
        this.libvlc = libvlc;
        this.instance = instance;
        this.createInstance(mediaListInstance);
    }

    public final void addMediaListEventListener(MediaListEventListener listener) {
        Logger.debug("addMediaListEventListener(listener={})", listener);
        this.eventListenerList.add(listener);
    }

    public final void removeListEventListener(MediaListEventListener listener) {
        Logger.debug("removeMediaListEventListener(listener={})", listener);
        this.eventListenerList.remove(listener);
    }

    public final void setStandardMediaOptions(String ... standardMediaOptions) {
        Logger.debug("setStandardMediaOptions(standardMediaOptions={})", Arrays.toString(standardMediaOptions));
        this.standardMediaOptions = standardMediaOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMedia(String mrl, String ... mediaOptions) {
        Logger.debug("addMedia(mrl={},mediaOptions={})", mrl, Arrays.toString(mediaOptions));
        try {
            this.lock();
            libvlc_media_t mediaDescriptor = this.newMediaDescriptor(mrl, mediaOptions);
            this.libvlc.libvlc_media_list_add_media(this.mediaListInstance, mediaDescriptor);
            this.releaseMediaDescriptor(mediaDescriptor);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insertMedia(int index, String mrl, String ... mediaOptions) {
        Logger.debug("insertMedia(index={},mrl={},mediaOptions={})", index, mrl, Arrays.toString(mediaOptions));
        try {
            this.lock();
            libvlc_media_t mediaDescriptor = this.newMediaDescriptor(mrl, mediaOptions);
            this.libvlc.libvlc_media_list_insert_media(this.mediaListInstance, mediaDescriptor, index);
            this.releaseMediaDescriptor(mediaDescriptor);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMedia(int index) {
        Logger.debug("removeMedia(index={})", index);
        try {
            this.lock();
            libvlc_media_t oldMediaInstance = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, index);
            if (oldMediaInstance != null) {
                this.libvlc.libvlc_media_list_remove_index(this.mediaListInstance, index);
                this.libvlc.libvlc_media_release(oldMediaInstance);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Logger.debug("clear()", new Object[0]);
        try {
            this.lock();
            for (int i = this.libvlc.libvlc_media_list_count(this.mediaListInstance) - 1; i >= 0; --i) {
                this.libvlc.libvlc_media_list_remove_index(this.mediaListInstance, i);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        Logger.debug("size()", new Object[0]);
        try {
            this.lock();
            int size = this.libvlc.libvlc_media_list_count(this.mediaListInstance);
            Logger.debug("size={}", size);
            int n = size;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public final boolean isReadOnly() {
        Logger.debug("isReadOnly()", new Object[0]);
        return this.libvlc.libvlc_media_list_is_readonly(this.mediaListInstance) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<MediaListItem> items() {
        Logger.debug("items()", new Object[0]);
        ArrayList<MediaListItem> result = new ArrayList<MediaListItem>();
        try {
            this.lock();
            for (int i = 0; i < this.libvlc.libvlc_media_list_count(this.mediaListInstance); ++i) {
                libvlc_media_t mediaInstance = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, i);
                result.add(this.newMediaListItem(mediaInstance));
                this.libvlc.libvlc_media_release(mediaInstance);
            }
        }
        finally {
            this.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaListItem newMediaListItem(libvlc_media_t mediaInstance) {
        List<MediaListItem> subItems;
        String name = NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_meta(mediaInstance, libvlc_meta_t.libvlc_meta_Title.intValue()));
        String mrl = NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_mrl(mediaInstance));
        libvlc_media_list_t subItemList = this.libvlc.libvlc_media_subitems(mediaInstance);
        if (subItemList != null) {
            try {
                this.libvlc.libvlc_media_list_lock(subItemList);
                subItems = new ArrayList<MediaListItem>();
                for (int i = 0; i < this.libvlc.libvlc_media_list_count(subItemList); ++i) {
                    libvlc_media_t subItemInstance = this.libvlc.libvlc_media_list_item_at_index(subItemList, i);
                    subItems.add(this.newMediaListItem(subItemInstance));
                    this.libvlc.libvlc_media_release(subItemInstance);
                }
            }
            finally {
                this.libvlc.libvlc_media_list_unlock(subItemList);
            }
            this.libvlc.libvlc_media_list_release(subItemList);
        } else {
            subItems = Collections.emptyList();
        }
        return new MediaListItem(name, mrl, subItems);
    }

    public final void release() {
        Logger.debug("release()", new Object[0]);
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance(libvlc_media_list_t mediaListInstance) {
        Logger.debug("createInstance()", new Object[0]);
        if (mediaListInstance == null) {
            mediaListInstance = this.libvlc.libvlc_media_list_new(this.instance);
        } else {
            this.libvlc.libvlc_media_list_retain(mediaListInstance);
        }
        this.mediaListInstance = mediaListInstance;
        Logger.debug("mediaListInstance={}", mediaListInstance);
        this.mediaListEventManager = this.libvlc.libvlc_media_list_event_manager(mediaListInstance);
        Logger.debug("mediaListEventManager={}", this.mediaListEventManager);
        this.registerEventListener();
    }

    private void destroyInstance() {
        Logger.debug("destroyInstance()", new Object[0]);
        this.deregisterEventListener();
        if (this.mediaListInstance != null) {
            this.libvlc.libvlc_media_list_release(this.mediaListInstance);
        }
        Logger.debug("Shut down listeners...", new Object[0]);
        this.listenersService.shutdown();
        Logger.debug("Listeners shut down.", new Object[0]);
    }

    private void registerEventListener() {
        Logger.debug("registerEventListener()", new Object[0]);
        this.callback = new MediaListCallback();
        for (libvlc_event_e event : libvlc_event_e.values()) {
            if (event.intValue() < libvlc_event_e.libvlc_MediaListItemAdded.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaListWillDeleteItem.intValue()) continue;
            Logger.debug("event={}", new Object[]{event});
            int result = this.libvlc.libvlc_event_attach(this.mediaListEventManager, event.intValue(), this.callback, null);
            Logger.debug("result={}", result);
        }
    }

    private void deregisterEventListener() {
        Logger.debug("deregisterEventListener()", new Object[0]);
        if (this.callback != null) {
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaListItemAdded.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaListWillDeleteItem.intValue()) continue;
                Logger.debug("event={}", new Object[]{event});
                this.libvlc.libvlc_event_detach(this.mediaListEventManager, event.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private void raiseEvent(MediaListEvent mediaListEvent) {
        Logger.trace("raiseEvent(mediaListEvent={}", mediaListEvent);
        if (mediaListEvent != null) {
            this.listenersService.submit(new NotifyEventListenersRunnable(mediaListEvent));
        }
    }

    private void lock() {
        Logger.debug("lock()", new Object[0]);
        this.libvlc.libvlc_media_list_lock(this.mediaListInstance);
    }

    private void unlock() {
        Logger.debug("unlock()", new Object[0]);
        this.libvlc.libvlc_media_list_unlock(this.mediaListInstance);
    }

    private libvlc_media_t newMediaDescriptor(String media, String ... mediaOptions) {
        libvlc_media_t mediaDescriptor;
        Logger.debug("newMediaDescriptor(media={},mediaOptions={})", media, Arrays.toString(mediaOptions));
        media = MediaResourceLocator.encodeMrl(media);
        if (MediaResourceLocator.isLocation(media)) {
            Logger.debug("Treating mrl as a location", new Object[0]);
            mediaDescriptor = this.libvlc.libvlc_media_new_location(this.instance, media);
        } else {
            Logger.debug("Treating mrl as a path", new Object[0]);
            mediaDescriptor = this.libvlc.libvlc_media_new_path(this.instance, media);
        }
        Logger.debug("mediaDescriptor={}", mediaDescriptor);
        if (this.standardMediaOptions != null) {
            for (String standardMediaOption : this.standardMediaOptions) {
                Logger.debug("standardMediaOption={}", standardMediaOption);
                this.libvlc.libvlc_media_add_option(mediaDescriptor, standardMediaOption);
            }
        }
        if (mediaOptions != null) {
            for (String mediaOption : mediaOptions) {
                Logger.debug("mediaOption={}", mediaOption);
                this.libvlc.libvlc_media_add_option(mediaDescriptor, mediaOption);
            }
        }
        return mediaDescriptor;
    }

    private void releaseMediaDescriptor(libvlc_media_t mediaDescriptor) {
        Logger.debug("releaseMediaDescriptor(mediaDescriptor={})", mediaDescriptor);
        this.libvlc.libvlc_media_release(mediaDescriptor);
    }

    public final libvlc_media_list_t mediaListInstance() {
        return this.mediaListInstance;
    }

    private final class NotifyEventListenersRunnable
    implements Runnable {
        private final MediaListEvent mediaListEvent;

        private NotifyEventListenersRunnable(MediaListEvent mediaListEvent) {
            this.mediaListEvent = mediaListEvent;
        }

        @Override
        public void run() {
            Logger.trace("run()", new Object[0]);
            for (int i = MediaList.this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaListEventListener listener = (MediaListEventListener)MediaList.this.eventListenerList.get(i);
                try {
                    this.mediaListEvent.notify(listener);
                    continue;
                }
                catch (Exception e) {
                    Logger.warn("Event listener {} threw an exception", e, listener);
                }
            }
            Logger.trace("runnable exits", new Object[0]);
        }
    }

    private final class MediaListCallback
    implements libvlc_callback_t {
        private MediaListCallback() {
        }

        @Override
        public void callback(libvlc_event_t event, Pointer userData) {
            Logger.trace("callback(event={},userData={})", event, userData);
            if (!MediaList.this.eventListenerList.isEmpty()) {
                MediaList.this.raiseEvent(MediaList.this.eventFactory.createEvent(event));
            }
        }
    }
}

