/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.discovery;

import com.sun.jna.NativeLibrary;
import uk.co.caprica.vlcj.Info;
import uk.co.caprica.vlcj.discovery.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.linux.DefaultLinuxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.mac.DefaultMacNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.discovery.windows.DefaultWindowsNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public class NativeDiscovery {
    private static final String JNA_SYSTEM_PROPERTY_NAME = "jna.library.path";
    private final NativeDiscoveryStrategy[] discoveryStrategies;

    public NativeDiscovery(NativeDiscoveryStrategy ... discoveryStrategies) {
        this.discoveryStrategies = discoveryStrategies;
    }

    public NativeDiscovery() {
        this(new DefaultLinuxNativeDiscoveryStrategy(), new DefaultWindowsNativeDiscoveryStrategy(), new DefaultMacNativeDiscoveryStrategy());
    }

    public final boolean discover() {
        Logger.debug("discover()", new Object[0]);
        String jnaLibraryPath = System.getProperty(JNA_SYSTEM_PROPERTY_NAME);
        Logger.debug("jnaLibraryPath={}", jnaLibraryPath);
        if (jnaLibraryPath == null) {
            for (NativeDiscoveryStrategy discoveryStrategy : this.discoveryStrategies) {
                Logger.debug("discoveryStrategy={}", discoveryStrategy);
                boolean supported = discoveryStrategy.supported();
                Logger.debug("supported={}", supported);
                if (!supported) continue;
                String path = discoveryStrategy.discover();
                Logger.debug("path={}", path);
                if (path == null) continue;
                Logger.info("Discovery found libvlc at '{}'", path);
                NativeLibrary.addSearchPath(RuntimeUtil.getLibVlcLibraryName(), path);
                return true;
            }
            Logger.warn("Discovery did not find libvlc", new Object[0]);
        } else {
            Logger.info("Skipped discovery as system property '{}' already set to '{}'", JNA_SYSTEM_PROPERTY_NAME, jnaLibraryPath);
        }
        return false;
    }

    static {
        Info.getInstance();
    }
}

