/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.util.Arrays;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;

public class DefaultFullScreenStrategy
implements FullScreenStrategy {
    private final Window window;

    public DefaultFullScreenStrategy(Window window) {
        Logger.debug("DefaultFullScreenStrategy(window={})", window);
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.window = window;
    }

    @Override
    public void enterFullScreenMode() {
        Logger.debug("enterFullScreenMode()", new Object[0]);
        GraphicsDevice graphicsDevice = this.getScreenDevice();
        Logger.debug("graphicsDevice={}", graphicsDevice);
        boolean fullScreenSupported = graphicsDevice.isFullScreenSupported();
        Logger.debug("fullScreenSupported={}", fullScreenSupported);
        this.onBeforeEnterFullScreenMode();
        graphicsDevice.setFullScreenWindow(this.window);
        DisplayMode displayMode = this.getDisplayMode(graphicsDevice.getDisplayModes());
        Logger.debug("displayMode={}", displayMode);
        if (displayMode != null) {
            Logger.debug("Setting new display mode", new Object[0]);
            graphicsDevice.setDisplayMode(displayMode);
        } else {
            Logger.debug("Using default display mode", new Object[0]);
        }
    }

    @Override
    public void exitFullScreenMode() {
        Logger.debug("exitFullScreenMode()", new Object[0]);
        this.getScreenDevice().setFullScreenWindow(null);
        this.onAfterExitFullScreenMode();
    }

    @Override
    public boolean isFullScreenMode() {
        Logger.debug("isFullScreenMode()", new Object[0]);
        return this.getScreenDevice().getFullScreenWindow() != null;
    }

    protected GraphicsDevice getScreenDevice() {
        Logger.debug("getScreenDevice()", new Object[0]);
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    protected DisplayMode getDisplayMode(DisplayMode[] displayModes) {
        Logger.debug("getDisplayMode()", Arrays.toString(displayModes));
        return null;
    }

    protected void onBeforeEnterFullScreenMode() {
    }

    protected void onAfterExitFullScreenMode() {
    }
}

