/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.manager;

import java.util.Arrays;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.player.manager.MediaManager;

public class DefaultMediaManager
implements MediaManager {
    protected final LibVlc libvlc;
    protected final libvlc_instance_t instance;

    public DefaultMediaManager(LibVlc libvlc, libvlc_instance_t instance) {
        this.libvlc = libvlc;
        this.instance = instance;
        this.createInstance();
    }

    @Override
    public boolean addBroadcast(String name, String inputMrl, String outputMrl, boolean enable, boolean loop, String ... options) {
        Logger.debug("addBrodcast(name={},inputMrl={},outputMrl={},enable={},loop={},options={})", name, inputMrl, outputMrl, enable, loop, Arrays.toString(options));
        return this.libvlc.libvlc_vlm_add_broadcast(this.instance, name, inputMrl, outputMrl, options != null ? options.length : 0, options, enable ? 1 : 0, loop ? 1 : 0) == 0;
    }

    @Override
    public boolean addVideoOnDemand(String name, String inputMrl, boolean enable, String mux, String ... options) {
        Logger.debug("addVideoOnDemand(name={},inputMrl={},enable={},mux={},options={})", name, inputMrl, enable, mux, Arrays.toString(options));
        return this.libvlc.libvlc_vlm_add_vod(this.instance, name, inputMrl, options != null ? options.length : 0, options, enable ? 1 : 0, mux) == 0;
    }

    @Override
    public boolean removeMedia(String name) {
        Logger.debug("removeMedia(name={})", name);
        return this.libvlc.libvlc_vlm_del_media(this.instance, name) == 0;
    }

    @Override
    public boolean enableMedia(String name, boolean enable) {
        Logger.debug("enableMedia(name={},enable={})", name, enable);
        return this.libvlc.libvlc_vlm_set_enabled(this.instance, name, enable ? 1 : 0) == 0;
    }

    @Override
    public boolean setOutput(String name, String outputMrl) {
        Logger.debug("setOutput(name={},outputMrl={})", name, outputMrl);
        return this.libvlc.libvlc_vlm_set_output(this.instance, name, outputMrl) == 0;
    }

    @Override
    public boolean setInput(String name, String inputMrl) {
        Logger.debug("setInput(name={},inputMrl={})", name, inputMrl);
        return this.libvlc.libvlc_vlm_set_input(this.instance, name, inputMrl) == 0;
    }

    @Override
    public boolean addInput(String name, String inputMrl) {
        Logger.debug("addInput(name={},inputMrl={})", name, inputMrl);
        return this.libvlc.libvlc_vlm_add_input(this.instance, name, inputMrl) == 0;
    }

    @Override
    public boolean setLoop(String name, boolean loop) {
        Logger.debug("setLoop(name={},loop={})", name, loop);
        return this.libvlc.libvlc_vlm_set_loop(this.instance, name, loop ? 1 : 0) == 0;
    }

    @Override
    public boolean setMux(String name, String mux) {
        Logger.debug("setMux(name={},mux={})", name, mux);
        return this.libvlc.libvlc_vlm_set_mux(this.instance, name, mux) == 0;
    }

    @Override
    public boolean changeMedia(String name, String inputMrl, String outputMrl, boolean enable, boolean loop, String ... options) {
        Logger.debug("changeMedia(name={},inputMrl={},outputMrl={},enable={},loop={},options={})", name, inputMrl, outputMrl, enable, loop, Arrays.toString(options));
        return this.libvlc.libvlc_vlm_change_media(this.instance, name, inputMrl, outputMrl, options != null ? options.length : 0, options, enable ? 1 : 0, loop ? 1 : 0) == 0;
    }

    @Override
    public boolean play(String name) {
        Logger.debug("play(name={})", name);
        return this.libvlc.libvlc_vlm_play_media(this.instance, name) == 0;
    }

    @Override
    public boolean stop(String name) {
        Logger.debug("stop(name={})", name);
        return this.libvlc.libvlc_vlm_stop_media(this.instance, name) == 0;
    }

    @Override
    public boolean pause(String name) {
        Logger.debug("pause(name={})", name);
        return this.libvlc.libvlc_vlm_pause_media(this.instance, name) == 0;
    }

    @Override
    public boolean seek(String name, float percentage) {
        Logger.debug("seek(name={},percentage={})", name, Float.valueOf(percentage));
        return this.libvlc.libvlc_vlm_seek_media(this.instance, name, percentage) == 0;
    }

    @Override
    public String show(String name) {
        Logger.debug("show(name={})", name);
        return this.libvlc.libvlc_vlm_show_media(this.instance, name);
    }

    @Override
    public float getPosition(String name, int instanceId) {
        Logger.debug("getPosition(name={},instanceId={})", name, instanceId);
        return this.libvlc.libvlc_vlm_get_media_instance_position(this.instance, name, instanceId);
    }

    @Override
    public int getTime(String name, int instanceId) {
        Logger.debug("getTime(name={},instanceId={})", name, instanceId);
        return this.libvlc.libvlc_vlm_get_media_instance_time(this.instance, name, instanceId);
    }

    @Override
    public int getLength(String name, int instanceId) {
        Logger.debug("getLength(name={},instanceId={})", name, instanceId);
        return this.libvlc.libvlc_vlm_get_media_instance_length(this.instance, name, instanceId);
    }

    @Override
    public int getRate(String name, int instanceId) {
        Logger.debug("getRate(name={},instanceId={})", name, instanceId);
        return this.libvlc.libvlc_vlm_get_media_instance_rate(this.instance, name, instanceId);
    }

    @Override
    public void release() {
        Logger.debug("release()", new Object[0]);
        this.destroyInstance();
    }

    private void createInstance() {
        Logger.debug("createInstance()", new Object[0]);
    }

    private void destroyInstance() {
        Logger.debug("destroyInstance()", new Object[0]);
        this.libvlc.libvlc_vlm_release(this.instance);
    }
}

