/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.waydownloader;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class WayDownloaderPlugin
extends Plugin {
    private Way priorConnectedWay = null;
    private Node selectedNode = null;

    public WayDownloaderPlugin(PluginInformation info) {
        super(info);
        MainMenu.add((JMenu)Main.main.menu.moreToolsMenu, (JosmAction)new WayDownloadAction());
    }

    private Node findDuplicateNode(Node referenceNode) {
        DataSet ds = Main.main.getCurrentDataSet();
        List candidates = ds.searchNodes(new Bounds(referenceNode.getCoor(), 3.0E-4, 5.0E-4).toBBox());
        for (Node candidate : candidates) {
            if (candidate.equals((Object)referenceNode) || candidate.isIncomplete() || !candidate.getCoor().equals((Object)referenceNode.getCoor())) continue;
            return candidate;
        }
        return null;
    }

    private Node findOtherEnd(Way way, Node firstEnd) {
        Node otherEnd = way.firstNode();
        if (otherEnd.equals((Object)firstEnd)) {
            otherEnd = way.lastNode();
        }
        return otherEnd;
    }

    private List<Way> findConnectedWays(Node referenceNode) {
        List referers = OsmPrimitive.getFilteredList((Collection)referenceNode.getReferrers(), Way.class);
        ArrayList<Way> connectedWays = new ArrayList<Way>(referers.size());
        for (Way way : referers) {
            if (way.getNodesCount() < 2 || !way.isFirstLastNode(referenceNode)) continue;
            connectedWays.add(way);
        }
        return connectedWays;
    }

    private boolean workFromWaySelection(Collection<? extends OsmPrimitive> selection) {
        if (selection.size() != 1) {
            return false;
        }
        Way selectedWay = (Way)selection.iterator().next();
        this.selectedNode = selectedWay.firstNode();
        if (this.isDownloaded(this.selectedNode)) {
            this.selectedNode = selectedWay.lastNode();
            if (this.isDownloaded(this.selectedNode)) {
                return false;
            }
        }
        Main.main.getCurrentDataSet().setSelected(new PrimitiveId[]{this.selectedNode});
        return true;
    }

    private boolean isDownloaded(Node node) {
        for (DataSource datasource : Main.main.getCurrentDataSet().dataSources) {
            Bounds bounds = datasource.bounds;
            if (bounds == null || !bounds.contains(node.getCoor())) continue;
            return true;
        }
        return false;
    }

    private static void showWarningMessage(final String msg) {
        if (msg != null) {
            GuiHelper.runInEDTAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                }
            });
        }
    }

    private static void showErrorMessage(final String msg) {
        if (msg != null) {
            GuiHelper.runInEDTAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                }
            });
        }
    }

    private static void showInfoMessage(final String msg) {
        if (msg != null) {
            GuiHelper.runInEDTAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr((String)"Information", (Object[])new Object[0]), 1);
                }
            });
        }
    }

    private class WayDownloadAction
    extends JosmAction
    implements Runnable {
        public WayDownloadAction() {
            super(I18n.tr((String)"Way Download", (Object[])new Object[0]), "way-download", I18n.tr((String)"Download map data on the end of selected way", (Object[])new Object[0]), Shortcut.registerShortcut((String)"waydownloader:waydownload", (String)I18n.tr((String)"Way Download", (Object[])new Object[0]), (int)87, (int)5009), true);
        }

        public void actionPerformed(ActionEvent e) {
            WayDownloaderPlugin.this.selectedNode = null;
            Collection selection = Main.main.getCurrentDataSet().getSelectedNodes();
            if (selection.isEmpty()) {
                Collection selWays = Main.main.getCurrentDataSet().getSelectedWays();
                if (!WayDownloaderPlugin.this.workFromWaySelection(selWays)) {
                    WayDownloaderPlugin.showWarningMessage(I18n.tr((String)"<html>Neither a node nor a way with an endpoint outside of the<br>current download areas is selected.<br>Select a node on the start or end of a way or an entire way first.</html>", (Object[])new Object[0]));
                    return;
                }
                selection = Main.main.getCurrentDataSet().getSelectedNodes();
            }
            if (selection.isEmpty() || selection.size() > 1 || !(selection.iterator().next() instanceof Node)) {
                WayDownloaderPlugin.showWarningMessage(I18n.tr((String)"<html>Could not find a unique node to start downloading from.</html>", (Object[])new Object[0]));
                return;
            }
            WayDownloaderPlugin.this.selectedNode = (Node)selection.iterator().next();
            Main.map.mapView.zoomTo(WayDownloaderPlugin.this.selectedNode.getEastNorth());
            List connectedWays = WayDownloaderPlugin.this.findConnectedWays(WayDownloaderPlugin.this.selectedNode);
            if (connectedWays.isEmpty()) {
                WayDownloaderPlugin.showWarningMessage(I18n.tr((String)"<html>There are no ways connected to node ''{0}''. Aborting.</html>", (Object[])new Object[]{WayDownloaderPlugin.this.selectedNode.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}));
                return;
            }
            WayDownloaderPlugin.this.priorConnectedWay = (Way)connectedWays.get(0);
            double latbuffer = Main.pref.getDouble("waydownloader.latbuffer", 1.0E-5);
            double lonbuffer = Main.pref.getDouble("waydownloader.latbuffer", 2.0E-5);
            DownloadOsmTask downloadTask = new DownloadOsmTask();
            final PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor();
            final Future future = downloadTask.download(false, new Bounds(WayDownloaderPlugin.this.selectedNode.getCoor().lat() - latbuffer, WayDownloaderPlugin.this.selectedNode.getCoor().lon() - lonbuffer, WayDownloaderPlugin.this.selectedNode.getCoor().lat() + latbuffer, WayDownloaderPlugin.this.selectedNode.getCoor().lon() + lonbuffer), (ProgressMonitor)monitor);
            Main.worker.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    monitor.close();
                }
            });
            Main.worker.execute(this);
        }

        @Override
        public void run() {
            List connectedWays = WayDownloaderPlugin.this.findConnectedWays(WayDownloaderPlugin.this.selectedNode);
            if (connectedWays.isEmpty()) {
                String msg = I18n.tr((String)"Way downloader data inconsistency. Prior connected way ''{0}'' wasn''t discovered after download", (Object[])new Object[]{WayDownloaderPlugin.this.priorConnectedWay.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
                System.err.println(msg);
                WayDownloaderPlugin.showErrorMessage(msg);
                return;
            }
            if (connectedWays.size() == 1) {
                Node dupeNode = WayDownloaderPlugin.this.findDuplicateNode(WayDownloaderPlugin.this.selectedNode);
                if (dupeNode != null) {
                    String msg = I18n.tr((String)"<html>There aren''t further connected ways to download.<br>A potential duplicate node of the currently selected node was found, though.<br><br>The currently selected node is ''{0}''<br>The potential duplicate node is ''{1}''<br>Merge the duplicate node onto the currently selected node and continue way downloading?</html>", (Object[])new Object[]{WayDownloaderPlugin.this.selectedNode.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), dupeNode.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
                    int ret = JOptionPane.showConfirmDialog(Main.parent, msg, I18n.tr((String)"Merge duplicate node?", (Object[])new Object[0]), 0, 3);
                    if (ret != 0) {
                        return;
                    }
                    Command cmd = MergeNodesAction.mergeNodes((OsmDataLayer)Main.main.getEditLayer(), Collections.singletonList(dupeNode), (Node)WayDownloaderPlugin.this.selectedNode);
                    if (cmd != null) {
                        Main.main.undoRedo.add(cmd);
                        Main.main.getEditLayer().data.setSelected(new PrimitiveId[]{WayDownloaderPlugin.this.selectedNode});
                    }
                } else {
                    WayDownloaderPlugin.showInfoMessage(I18n.tr((String)"<html>No more connected ways to download.</html>", (Object[])new Object[0]));
                    return;
                }
                connectedWays = WayDownloaderPlugin.this.findConnectedWays(WayDownloaderPlugin.this.selectedNode);
                return;
            }
            if (connectedWays.size() > 2) {
                String msg = I18n.tr((String)"Node ''{0}'' is a junction with more than 2 connected ways.", (Object[])new Object[]{WayDownloaderPlugin.this.selectedNode.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
                WayDownloaderPlugin.showWarningMessage(msg);
                return;
            }
            if (connectedWays.size() == 2) {
                Way wayA = (Way)connectedWays.get(0);
                Way wayB = (Way)connectedWays.get(1);
                Way nextWay = wayA;
                if (WayDownloaderPlugin.this.priorConnectedWay.equals((Object)wayA)) {
                    nextWay = wayB;
                }
                Node nextNode = WayDownloaderPlugin.this.findOtherEnd(nextWay, WayDownloaderPlugin.this.selectedNode);
                Main.main.getCurrentDataSet().setSelected(new PrimitiveId[]{nextNode});
                Main.map.mapView.zoomTo(nextNode.getEastNorth());
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(WayDownloadAction.getEditLayer() != null);
        }

        protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        }
    }
}

