/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.tabular;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.opendata.core.io.AbstractImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvReader;
import org.openstreetmap.josm.tools.I18n;

public class CsvImporter
extends AbstractImporter {
    public static final ExtensionFileFilter CSV_FILE_FILTER = new ExtensionFileFilter("csv", "csv", I18n.tr((String)"CSV files", (Object[])new Object[0]) + " (*." + "csv" + ")");
    public static final String COLOMBUS_HEADER = "INDEX,TAG,DATE,TIME,LATITUDE N/S,LONGITUDE E/W,HEIGHT,SPEED,HEADING,FIX MODE,VALID,PDOP,HDOP,VDOP,VOX";

    public CsvImporter() {
        super(CSV_FILE_FILTER);
    }

    protected DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IllegalDataException {
        try {
            return CsvReader.parseDataSet(in, this.handler, instance);
        }
        catch (IOException e) {
            throw new IllegalDataException((Throwable)e);
        }
    }

    public boolean acceptFile(File pathname) {
        return super.acceptFile(pathname) && !CsvImporter.isColombusCsv(pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isColombusCsv(File file) {
        boolean result = false;
        if (file != null && file.isFile()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = reader.readLine();
                result = line != null && line.equalsIgnoreCase(COLOMBUS_HEADER);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }
}

