/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifEllipsoid;

public enum MifDatum {
    Adindan(1, "Ethiopia, Mali, Senegal, Sudan", MifEllipsoid.Clarke_1880),
    Afgooye(2, "Somalia", MifEllipsoid.Krassovsky),
    Ain_el_Abd_1970(3, "Bahrain Island", MifEllipsoid.International),
    Anna_1_Astro_1965(4, "Cocos Islands", MifEllipsoid.Australian_National),
    Arc_1950(5, "Botswana, Lesotho, Malawi, Swaziland, Zaire, Zambia, Zimbabwe", MifEllipsoid.Clarke_1880),
    Arc_1960(6, "Kenya, Tanzania", MifEllipsoid.Clarke_1880),
    Ascension_Island_1958(7, "Ascension Island", MifEllipsoid.International),
    Astro_Beacon_E(8, "Iwo Jima Island", MifEllipsoid.International),
    Astro_B4_Sorol_Atoll(9, "Tern Island", MifEllipsoid.International),
    Astro_DOS_71_4(10, "St. Helena Island", MifEllipsoid.International),
    Astronomic_Station_1952(11, "Marcus Island", MifEllipsoid.International),
    Australian_Geodetic_1966_AGD_66(12, "Australia and Tasmania Island", MifEllipsoid.Australian_National),
    Australian_Geodetic_1984_AGD_84(13, "Australia and Tasmania Island", MifEllipsoid.Australian_National),
    Belgium(110, "Belgium", MifEllipsoid.International),
    Bellevue_IGN(14, "Efate and Erromango Islands", MifEllipsoid.International),
    Bermuda_1957(15, "Bermuda Islands", MifEllipsoid.Clarke_1866),
    Bogota_Observatory(16, "Colombia", MifEllipsoid.International),
    Campo_Inchauspe(17, "Argentina", MifEllipsoid.International),
    Canton_Astro_1966(18, "Phoenix Islands", MifEllipsoid.International),
    Cape(19, "South Africa", MifEllipsoid.Clarke_1880),
    Cape_Canaveral(20, "Florida and Bahama Islands", MifEllipsoid.Clarke_1866),
    Carthage(21, "Tunisia", MifEllipsoid.Clarke_1880),
    Chatham_1971(22, "Chatham Island (New Zealand)", MifEllipsoid.International),
    Chua_Astro(23, "Paraguay", MifEllipsoid.International),
    Corrego_Alegre(24, "Brazil", MifEllipsoid.International),
    Deutsches_Hauptdreicksnetz_DHDN(1000, "Germany", MifEllipsoid.Bessel),
    Djakarta_Batavia(25, "Sumatra Island (Indonesia)", MifEllipsoid.Bessel_1841),
    DOS_1968(26, "Gizo Island (New Georgia Islands)", MifEllipsoid.International),
    Easter_Island_1967(27, "Easter Island", MifEllipsoid.International),
    European_1950_ED_50(28, "Austria, Belgium, Denmark, Finland, France, Germany, Gibraltar, Greece, Italy, Luxembourg, Netherlands, Norway, Portugal, Spain, Sweden, Switzerland", MifEllipsoid.International),
    European_1979_ED_79(29, "Austria, Finland, Netherlands, Norway, Spain, Sweden, Switzerland", MifEllipsoid.International),
    European_1987_ED_87(108, "Europe", MifEllipsoid.International),
    Gandajika_Base(30, "Republic of Maldives", MifEllipsoid.International),
    Geodetic_Datum_1949(31, "New Zealand", MifEllipsoid.International),
    Geodetic_Reference_System_1967_GRS_67(32, "Worldwide", MifEllipsoid.GRS_67),
    Geodetic_Reference_System_1980_GRS_80(33, "Worldwide", MifEllipsoid.GRS_80),
    Guam_1963(34, "Guam Island", MifEllipsoid.Clarke_1866),
    GUX_1_Astro(35, "Guadalcanal Island", MifEllipsoid.International),
    Hito_XVIII_1963(36, "South Chile (near 53\u00b0S)", MifEllipsoid.International),
    Hjorsey_1955(37, "Iceland", MifEllipsoid.International),
    Hong_Kong_1963(38, "Hong Kong", MifEllipsoid.International),
    Hu_Tzu_Shan(39, "Taiwan", MifEllipsoid.International),
    Indian_40(40, "Thailand and Vietnam", MifEllipsoid.Everest),
    Indian_41(41, "Bangladesh, India, Nepal", MifEllipsoid.Everest),
    Ireland_1965(42, "Ireland", MifEllipsoid.Modified_Airy),
    ISTS_073_Astro_1969(43, "Diego Garcia", MifEllipsoid.International),
    Johnston_Island_1961(44, "Johnston Island", MifEllipsoid.International),
    Kandawala(45, "Sri Lanka", MifEllipsoid.Everest),
    Kerguelen_Island(46, "Kerguelen Island", MifEllipsoid.International),
    Kertau_1948(47, "West Malaysia and Singapore", MifEllipsoid.Modified_Everest),
    LC_5_Astro(48, "Cayman Brac Island", MifEllipsoid.Clarke_1866),
    Liberia_1964(49, "Liberia", MifEllipsoid.Clarke_1880),
    Lisboa_DLx(113, "Portugal", MifEllipsoid.International),
    Luzon_50(50, "Philippines (excluding Mindanao Island)", MifEllipsoid.Clarke_1866),
    Luzon_51(51, "Mindanao Island", MifEllipsoid.Clarke_1866),
    Mahe_1971(52, "Mahe Island", MifEllipsoid.Clarke_1880),
    Marco_Astro(53, "Salvage Islands", MifEllipsoid.International),
    Massawa(54, "Eritrea (Ethiopia)", MifEllipsoid.Bessel_1841),
    Melrica_1973_D73(114, "Portugal", MifEllipsoid.International),
    Merchich(55, "Morocco", MifEllipsoid.Clarke_1880),
    Midway_Astro_1961(56, "Midway Island", MifEllipsoid.International),
    Minna(57, "Nigeria", MifEllipsoid.Clarke_1880),
    Nahrwan_58(58, "Masirah Island (Oman)", MifEllipsoid.Clarke_1880),
    Nahrwan_59(59, "United Arab Emirates", MifEllipsoid.Clarke_1880),
    Nahrwan_60(60, "Saudi Arabia", MifEllipsoid.Clarke_1880),
    Naparima_BWI(61, "Trinidad and Tobago", MifEllipsoid.International),
    Netherlands(109, "Netherlands", MifEllipsoid.Bessel),
    North_American_1927_NAD_27_CONTINENTAL(62, "Continental US", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_ALASKA(63, "Alaska", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_BAHAMAS(64, "Bahamas (excluding San Salvador Island)", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_SAN_SALVADOR(65, "San Salvador Island", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_CANADA(66, "Canada (including Newfoundland Island)", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_CANAL_ZONE(67, "Canal Zone", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_CARIBBEAN(68, "Caribbean (Turks and Caicos Islands)", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_CENTRAL_AMERICA(69, "Central America (Belize, Costa Rica, El Salvador, Guatemala, Honduras, Nicaragua)", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_CUBA(70, "Cuba", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_GREENLAND(71, "Greenland (Hayes Peninsula)", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_MEXICO(72, "Mexico", MifEllipsoid.Clarke_1866),
    North_American_1927_NAD_27_MICHIGAN(73, "Michigan (used only for State Plane Coordinate System 1927)", MifEllipsoid.Modified_Clarke_1866),
    North_American_1983_NAD_83(74, "Alaska, Canada, Central America, Continental US, Mexico", MifEllipsoid.GRS_80),
    Nouvelle_Triangulation_Francaise_NTF(107, "France", MifEllipsoid.Clarke_1880),
    Nouvelle_Triangulation_Francaise_NTF_Greenwich_Prime_Meridian(1002, "France", MifEllipsoid.Clarke_1880),
    NWGL_10(111, "Worldwide", MifEllipsoid.WGS_72),
    Observatorio_1966(75, "Corvo and Flores Islands (Azores)", MifEllipsoid.International),
    Old_Egyptian(76, "Egypt", MifEllipsoid.Helmert_1906),
    Old_Hawaiian(77, "Hawaii", MifEllipsoid.Clarke_1866),
    Oman(78, "Oman", MifEllipsoid.Clarke_1880),
    Ordnance_Survey_of_Great_Britain_1936(79, "England, Isle of Man, Scotland, Shetland Islands, Wales", MifEllipsoid.Airy),
    Pico_de_las_Nieves(80, "Canary Islands", MifEllipsoid.International),
    Pitcairn_Astro_1967(81, "Pitcairn Island", MifEllipsoid.International),
    Potsdam(1000, "Germany", MifEllipsoid.Bessel),
    Provisional_South_Chilean_1963(36, "South Chile (near 53\u00b0S)", MifEllipsoid.International),
    Provisional_South_American_1956(82, "Bolivia, Chile, Colombia, Ecuador, Guyana, Peru, Venezuela", MifEllipsoid.International),
    Puerto_Rico(83, "Puerto Rico and Virgin Islands", MifEllipsoid.Clarke_1866),
    Pulkovo_1942(1001, "Germany", MifEllipsoid.Krassovsky),
    Qatar_National(84, "Qatar", MifEllipsoid.International),
    Qornoq(85, "South Greenland", MifEllipsoid.International),
    Rauenberg(1000, "Germany", MifEllipsoid.Bessel),
    Reunion(86, "Mascarene Island", MifEllipsoid.International),
    Rikets_Triangulering_1990_RT_90(112, "Sweden", MifEllipsoid.Bessel),
    Rome_1940(87, "Sardinia Island", MifEllipsoid.International),
    Santo_DOS(88, "Espirito Santo Island", MifEllipsoid.International),
    Sao_Braz(89, "S\u00e3o Miguel, Santa Maria Islands (Azores)", MifEllipsoid.International),
    Sapper_Hill_1943(90, "East Falkland Island", MifEllipsoid.International),
    Schwarzeck(91, "Namibia Modified", MifEllipsoid.Bessel_1841),
    South_American_1969(92, "Argentina, Bolivia, Brazil, Chile, Colombia, Ecuador, Guyana, Paraguay, Peru, Venezuela, Trinidad, and Tobago", MifEllipsoid.South_American_1969),
    South_Asia(93, "Singapore", MifEllipsoid.Modified_Fischer_1960),
    Southeast_Base(94, "Porto Santo and Madeira Islands", MifEllipsoid.International),
    Southwest_Base(95, "Faial, Graciosa, Pico, Sao Jorge, Terceira Islands (Azores)", MifEllipsoid.International),
    Switzerland_CH_1903(1003, "Switzerland", MifEllipsoid.Bessel),
    Timbalai_1948(96, "Brunei and East Malaysia (Sarawak and Sabah)", MifEllipsoid.Everest),
    Tokyo(97, "Japan, Korea, Okinawa", MifEllipsoid.Bessel_1841),
    Tristan_Astro_1968(98, "Tristan da Cunha", MifEllipsoid.International),
    Viti_Levu_1916(99, "Viti Levu Island (Fiji Islands)", MifEllipsoid.Clarke_1880),
    Wake_Eniwetok_1960(100, "", MifEllipsoid.Hough),
    World_Geodetic_System_1960_WGS_60(101, "", MifEllipsoid.WGS_60),
    World_Geodetic_System_1966_WGS_66(102, "", MifEllipsoid.WGS_66),
    World_Geodetic_System_1972_WGS_72(103, "", MifEllipsoid.WGS_72),
    World_Geodetic_System_1984_WGS_84(104, "", MifEllipsoid.WGS_84),
    Yacare(105, "", MifEllipsoid.International),
    Zanderij(106, "", MifEllipsoid.International),
    Custom(999, null, null);

    private final Integer code;
    private final String area;
    private final MifEllipsoid ellipsoid;

    private MifDatum(Integer code, String area, MifEllipsoid ellipsoid) {
        this.code = code;
        this.area = area;
        this.ellipsoid = ellipsoid;
    }

    public final Integer getCode() {
        return this.code;
    }

    public final String getArea() {
        return this.area;
    }

    public final MifEllipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public static MifDatum forCode(Integer code) {
        for (MifDatum p : MifDatum.values()) {
            if (!p.getCode().equals(code)) continue;
            return p;
        }
        return null;
    }
}

