/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import java.util.ArrayList;
import java.util.HashSet;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import relcontext.relationfix.RelationFixer;

public class MultipolygonFixer
extends RelationFixer {
    public MultipolygonFixer() {
        super("multipolygon");
    }

    protected MultipolygonFixer(String ... types) {
        super(types);
    }

    @Override
    public boolean isRelationGood(Relation rel) {
        for (RelationMember m : rel.getMembers()) {
            if (!m.getType().equals((Object)OsmPrimitiveType.WAY) || "outer".equals(m.getRole()) || "inner".equals(m.getRole())) continue;
            this.setWarningMessage(I18n.tr((String)"Way without ''inner'' or ''outer'' role found", (Object[])new Object[0]));
            return false;
        }
        this.clearWarningMessage();
        return true;
    }

    @Override
    public Command fixRelation(Relation rel) {
        Relation rr = this.fixMultipolygonRoles(rel);
        return rr != null ? new ChangeCommand((OsmPrimitive)rel, (OsmPrimitive)rr) : null;
    }

    protected Relation fixMultipolygonRoles(Relation source) {
        ArrayList<Way> ways = new ArrayList<Way>();
        for (OsmPrimitive p : source.getMemberPrimitives()) {
            if (!(p instanceof Way)) continue;
            ways.add((Way)p);
        }
        MultipolygonBuilder mpc = new MultipolygonBuilder();
        String error = mpc.makeFromWays(ways);
        if (error != null) {
            return null;
        }
        Relation r = new Relation(source);
        boolean fixed = false;
        HashSet<Way> outerWays = new HashSet<Way>();
        for (MultipolygonBuilder.JoinedPolygon poly : mpc.outerWays) {
            for (Way w : poly.ways) {
                outerWays.add(w);
            }
        }
        HashSet<Way> innerWays = new HashSet<Way>();
        for (MultipolygonBuilder.JoinedPolygon poly : mpc.innerWays) {
            for (Way w : poly.ways) {
                innerWays.add(w);
            }
        }
        int i = 0;
        while (i < r.getMembersCount()) {
            RelationMember m = r.getMember(i);
            if (m.isWay()) {
                String role = null;
                if (outerWays.contains((Way)m.getMember())) {
                    role = "outer";
                } else if (innerWays.contains((Way)m.getMember())) {
                    role = "inner";
                }
                if (role != null && !role.equals(m.getRole())) {
                    r.setMember(i, new RelationMember(role, m.getMember()));
                    fixed = true;
                }
            }
            ++i;
        }
        return fixed ? r : null;
    }
}

