/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets;

import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.licenses.License;
import org.openstreetmap.josm.plugins.opendata.modules.fr.paris.ParisConstants;
import org.openstreetmap.josm.plugins.opendata.modules.fr.paris.ParisLicense;

public abstract class ParisDataSetHandler
extends FrenchDataSetHandler
implements ParisConstants {
    private int documentId;
    private static final int portletId = 106;

    public ParisDataSetHandler(int documentId) {
        this.init(documentId);
    }

    public ParisDataSetHandler(int documentId, String relevantTag) {
        super(relevantTag);
        this.init(documentId);
    }

    public ParisDataSetHandler(int documentId, boolean relevantUnion, String ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(documentId);
    }

    public ParisDataSetHandler(int documentId, String ... relevantTags) {
        this(documentId, false, relevantTags);
    }

    public ParisDataSetHandler(int documentId, boolean relevantUnion, Tag ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(documentId);
    }

    private final void init(int documentId) {
        this.documentId = documentId;
        this.setLicense((License)new ParisLicense());
        try {
            if (documentId > 0) {
                this.setLocalPortalURL("http://opendata.paris.fr/opendata/jsp/site/Portal.jsp?document_id=" + documentId + "&portlet_id=" + 106);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public String getSource() {
        return "opendataparis";
    }

    public String getLocalPortalIconName() {
        return "data.fr.paris_24.png";
    }

    protected abstract String getDirectLink();

    public URL getDataURL() {
        try {
            if (this.documentId > 0) {
                return new URL("http://opendata.paris.fr/opendata/rating/download/?id_resource=" + this.documentId + "&type_resource=document&url=" + this.getDirectLink());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

