/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.enfance;

import org.apache.commons.lang3.text.WordUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class CrechesHandler
extends ToulouseDataSetHandler {
    public CrechesHandler() {
        super(12462, "amenity=kindergarten");
        this.setWikiPage("Cr\u00e8ches");
        this.setCategory(CAT_ENFANCE);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsCsvKmzTabFilename(filename, new String[]{"Creches"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.put("amenity", "kindergarten");
            this.replace((IPrimitive)n, "NOM", "name");
            n.put("name", WordUtils.capitalizeFully((String)n.get("name")));
            n.remove("QUARTIER");
            n.remove("RUE");
            this.replace((IPrimitive)n, "NUM", "addr:housenumber");
            n.remove("CP");
            n.remove("STIADR");
            if (n.hasKey("NATURE")) {
                String nature = n.get("NATURE");
                if (nature.equals("CC")) {
                    nature = "Cr\u00e8che collective";
                } else if (nature.equals("CF")) {
                    nature = "Cr\u00e8che familiale";
                } else if (nature.equals("HG")) {
                    nature = "Halte-Garderie";
                } else if (nature.equals("JE")) {
                    nature = "Jardin d'Enfants";
                } else if (nature.equals("MA")) {
                    nature = "Multi-Accueil";
                }
                n.remove("NATURE");
                n.put("description", nature);
            }
            if (!n.hasKey("NATGEST")) continue;
            String gest = n.get("NATGEST").split(" ")[1];
            if (gest.equals("ASS")) {
                gest = "Association";
            } else if (gest.equals("CCAS")) {
                gest = "Centre Communal d'Action Sociale";
            } else if (gest.equals("CHU")) {
                gest = "CHU de Toulouse";
            } else if (gest.equals("PRIV")) {
                gest = "private";
            } else if (gest.equals("VT")) {
                gest = "Mairie de Toulouse";
            } else if (gest.equals("CAF")) {
                gest = "Caisse d'Allocations familiales";
            } else if (gest.equals("MUT")) {
                gest = "Mutuelle";
            } else if (gest.equals("UPS")) {
                gest = "Universit\u00e9 Paul Sabatier";
            }
            n.remove("NATGEST");
            n.put("operator", gest);
        }
    }
}

