/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.lemans.datasets;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.licenses.License;
import org.openstreetmap.josm.plugins.opendata.modules.fr.lemans.LeMansConstants;
import org.openstreetmap.josm.tools.Pair;

public abstract class LeMansDataSetHandler
extends FrenchDataSetHandler
implements LeMansConstants {
    private String kmzUuid;
    private String shpUuid;

    public LeMansDataSetHandler(String uuid) {
        this.init(uuid);
    }

    public LeMansDataSetHandler(String uuid, String relevantTag) {
        super(relevantTag);
        this.init(uuid);
    }

    public LeMansDataSetHandler(String uuid, boolean relevantUnion, String ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(uuid);
    }

    public LeMansDataSetHandler(String uuid, String ... relevantTags) {
        this(uuid, false, relevantTags);
    }

    public LeMansDataSetHandler(String uuid, boolean relevantUnion, Tag ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(uuid);
    }

    private final void init(String uuid) {
        try {
            this.setLicense((License)License.ODbL);
            if (uuid != null && !uuid.isEmpty()) {
                this.setLocalPortalURL("http://www.lemans.fr/page.do?t=2&uuid=" + uuid);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    protected final void setKmzShpUuid(String kmzUuid, String shpUuid) {
        this.kmzUuid = kmzUuid;
        this.shpUuid = shpUuid;
    }

    public String getSource() {
        return "Le Mans M\u00e9tropole";
    }

    public List<Pair<String, URL>> getDataURLs() {
        ArrayList<Pair<String, URL>> result = new ArrayList<Pair<String, URL>>();
        try {
            if (this.kmzUuid != null && !this.kmzUuid.isEmpty()) {
                result.add((Pair<String, URL>)new Pair((Object)(this.getName() + " (KMZ)"), (Object)new URL("http://www.lemans.fr/download.do?uuid=" + this.kmzUuid)));
            }
            if (this.shpUuid != null && !this.shpUuid.isEmpty()) {
                result.add((Pair<String, URL>)new Pair((Object)(this.getName() + " (SHP)"), (Object)new URL("http://www.lemans.fr/download.do?uuid=" + this.shpUuid)));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

