/*
 * Decompiled with CFR 0.152.
 */
package org.j7zip.SevenZip;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.j7zip.SevenZip.Archive.IArchiveExtractCallback;
import org.j7zip.SevenZip.Archive.IInArchive;
import org.j7zip.SevenZip.Archive.SevenZipEntry;

public class ArchiveExtractCallback
implements IArchiveExtractCallback {
    java.io.OutputStream _outFileStream;
    public String outputDir = null;
    IInArchive _archiveHandler;
    protected String _filePath;
    String _diskFilePath;
    protected File file;
    public long NumErrors;
    boolean isDirectory;

    @Override
    public int SetTotal(long size) {
        return 0;
    }

    @Override
    public int SetCompleted(long completeValue) {
        return 0;
    }

    public void PrintString(String str) {
        System.out.print(str);
    }

    public void PrintNewLine() {
        System.out.println("");
    }

    @Override
    public int PrepareOperation(int askExtractMode) {
        switch (askExtractMode) {
            case 0: {
                this.PrintString("Extracting  ");
                break;
            }
            case 1: {
                this.PrintString("Testing     ");
                break;
            }
            case 2: {
                this.PrintString("Skipping    ");
            }
        }
        this.PrintString(this._filePath);
        return 0;
    }

    @Override
    public int SetOperationResult(int operationResult) throws IOException {
        switch (operationResult) {
            case 0: {
                break;
            }
            default: {
                ++this.NumErrors;
                this.PrintString("     ");
                switch (operationResult) {
                    case 1: {
                        this.PrintString("Unsupported Method");
                        break;
                    }
                    case 3: {
                        this.PrintString("CRC Failed");
                        break;
                    }
                    case 2: {
                        this.PrintString("Data Error");
                        break;
                    }
                    default: {
                        this.PrintString("Unknown Error");
                    }
                }
                this.PrintNewLine();
            }
        }
        if (this._outFileStream != null) {
            this._outFileStream.close();
        }
        return 0;
    }

    @Override
    public int GetStream(int index, java.io.OutputStream[] outStream, int askExtractMode) throws IOException {
        outStream[0] = null;
        SevenZipEntry item = this._archiveHandler.getEntry(index);
        this._filePath = item.getName();
        this._diskFilePath = this.outputDir == null ? this._filePath : this.outputDir + File.separator + this._filePath;
        this.file = new File(this._diskFilePath);
        switch (askExtractMode) {
            case 1: {
                return 0;
            }
            case 0: {
                try {
                    this.isDirectory = item.isDirectory();
                    if (this.isDirectory) {
                        if (this.file.isDirectory()) {
                            return 0;
                        }
                        if (this.file.mkdirs()) {
                            return 0;
                        }
                        return 1;
                    }
                    File dirs = this.file.getParentFile();
                    if (dirs != null && !dirs.isDirectory() && !dirs.mkdirs()) {
                        return 1;
                    }
                    long pos = item.getPosition();
                    if (pos == -1L) {
                        this.file.delete();
                    }
                    RandomAccessFile outStr = new RandomAccessFile(this._diskFilePath, "rw");
                    if (pos != -1L) {
                        outStr.seek(pos);
                    }
                    outStream[0] = new OutputStream(outStr);
                }
                catch (IOException e) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    public void Init(IInArchive archiveHandler) {
        this.NumErrors = 0L;
        this._archiveHandler = archiveHandler;
    }

    class OutputStream
    extends java.io.OutputStream {
        RandomAccessFile file;

        public OutputStream(RandomAccessFile f) {
            this.file = f;
        }

        @Override
        public void close() throws IOException {
            this.file.close();
            this.file = null;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.file.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.file.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.file.write(b);
        }
    }
}

