/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class MultiValueMap
extends AbstractMapDecorator
implements MultiMap {
    private final Factory collectionFactory;
    private transient Collection values;

    public static MultiValueMap decorate(Map map) {
        return new MultiValueMap(map, new ReflectionFactory(ArrayList.class));
    }

    public static MultiValueMap decorate(Map map, Class clazz) {
        return new MultiValueMap(map, new ReflectionFactory(clazz));
    }

    public static MultiValueMap decorate(Map map, Factory factory) {
        return new MultiValueMap(map, factory);
    }

    public MultiValueMap() {
        this(new HashMap(), new ReflectionFactory(ArrayList.class));
    }

    protected MultiValueMap(Map map, Factory factory) {
        super(map);
        if (factory == null) {
            throw new IllegalArgumentException("The factory must not be null");
        }
        this.collectionFactory = factory;
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public Object remove(Object object, Object object2) {
        Collection collection = this.getCollection(object);
        if (collection == null) {
            return null;
        }
        boolean bl = collection.remove(object2);
        if (!bl) {
            return null;
        }
        if (collection.isEmpty()) {
            this.remove(object);
        }
        return object2;
    }

    @Override
    public boolean containsValue(Object object) {
        Set set = this.getMap().entrySet();
        if (set == null) {
            return false;
        }
        for (Map.Entry entry : set) {
            Collection collection = (Collection)entry.getValue();
            if (!collection.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object put(Object object, Object object2) {
        boolean bl = false;
        Collection collection = this.getCollection(object);
        if (collection == null) {
            collection = this.createCollection();
            bl = collection.add(object2);
            if (collection.size() > 0) {
                this.getMap().put(object, collection);
                bl = false;
            }
        } else {
            bl = collection.add(object2);
        }
        return bl ? object2 : null;
    }

    @Override
    public void putAll(Map map) {
        if (map instanceof MultiMap) {
            for (Map.Entry entry : map.entrySet()) {
                Collection collection = (Collection)entry.getValue();
                this.putAll(entry.getKey(), collection);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    public boolean containsValue(Object object, Object object2) {
        Collection collection = this.getCollection(object);
        if (collection == null) {
            return false;
        }
        return collection.contains(object2);
    }

    public Collection getCollection(Object object) {
        return (Collection)this.getMap().get(object);
    }

    public int size(Object object) {
        Collection collection = this.getCollection(object);
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public boolean putAll(Object object, Collection collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        Collection collection2 = this.getCollection(object);
        if (collection2 == null) {
            collection2 = this.createCollection();
            boolean bl = collection2.addAll(collection);
            if (collection2.size() > 0) {
                this.getMap().put(object, collection2);
                bl = false;
            }
            return bl;
        }
        return collection2.addAll(collection);
    }

    public Iterator iterator(Object object) {
        if (!this.containsKey(object)) {
            return EmptyIterator.INSTANCE;
        }
        return new ValuesIterator(object);
    }

    public int totalSize() {
        int n = 0;
        Collection collection = this.getMap().values();
        for (Collection collection2 : collection) {
            n += collection2.size();
        }
        return n;
    }

    protected Collection createCollection() {
        return (Collection)this.collectionFactory.create();
    }

    private static class ReflectionFactory
    implements Factory {
        private final Class clazz;

        public ReflectionFactory(Class clazz) {
            this.clazz = clazz;
        }

        @Override
        public Object create() {
            try {
                return this.clazz.newInstance();
            }
            catch (Exception exception) {
                throw new FunctorException("Cannot instantiate class: " + this.clazz, exception);
            }
        }
    }

    private class ValuesIterator
    implements Iterator {
        private final Object key;
        private final Collection values;
        private final Iterator iterator;

        public ValuesIterator(Object object) {
            this.key = object;
            this.values = MultiValueMap.this.getCollection(object);
            this.iterator = this.values.iterator();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            if (this.values.isEmpty()) {
                MultiValueMap.this.remove(this.key);
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            IteratorChain iteratorChain = new IteratorChain();
            Iterator iterator = MultiValueMap.this.keySet().iterator();
            while (iterator.hasNext()) {
                iteratorChain.addIterator(new ValuesIterator(iterator.next()));
            }
            return iteratorChain;
        }

        @Override
        public int size() {
            return MultiValueMap.this.totalSize();
        }

        @Override
        public void clear() {
            MultiValueMap.this.clear();
        }
    }
}

