/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

class FeatureBlockReader {
    RandomAccessFile raf;
    SimpleFeatureType schema;
    SimpleFeatureBuilder builder;
    SimpleFeature curr;
    long offset;
    int count;

    public FeatureBlockReader(RandomAccessFile raf, long start, int count, SimpleFeatureType schema) {
        this.raf = raf;
        this.offset = start;
        this.count = count;
        this.schema = schema;
        this.builder = new SimpleFeatureBuilder(schema);
    }

    public SimpleFeature feature() throws IOException {
        if (this.curr == null && this.count > 0) {
            this.curr = this.readNextFeature();
        }
        return this.curr;
    }

    public SimpleFeature next() throws IOException {
        this.curr = this.readNextFeature();
        return this.curr;
    }

    private SimpleFeature readNextFeature() throws IOException {
        if (this.count <= 0) {
            return null;
        }
        this.raf.seek(this.offset);
        String fid = this.raf.readUTF();
        for (AttributeDescriptor ad : this.schema.getAttributeDescriptors()) {
            Object att = this.readAttribute(ad);
            this.builder.add(att);
        }
        this.offset = this.raf.getFilePointer();
        --this.count;
        return this.builder.buildFeature(fid);
    }

    Object readAttribute(AttributeDescriptor ad) throws IOException {
        boolean isNull = this.raf.readBoolean();
        if (isNull) {
            return null;
        }
        Class binding = ad.getType().getBinding();
        if (binding == Boolean.class) {
            return this.raf.readBoolean();
        }
        if (binding == Byte.class || binding == Byte.TYPE) {
            return this.raf.readByte();
        }
        if (binding == Short.class || binding == Short.TYPE) {
            return this.raf.readShort();
        }
        if (binding == Integer.class || binding == Integer.TYPE) {
            return this.raf.readInt();
        }
        if (binding == Long.class || binding == Long.TYPE) {
            return this.raf.readLong();
        }
        if (binding == Float.class || binding == Float.TYPE) {
            return Float.valueOf(this.raf.readFloat());
        }
        if (binding == Double.class || binding == Double.TYPE) {
            return this.raf.readDouble();
        }
        if (binding == String.class) {
            return this.raf.readUTF();
        }
        if (binding == Date.class) {
            return new Date(this.raf.readLong());
        }
        if (binding == Time.class) {
            return new Time(this.raf.readLong());
        }
        if (binding == Timestamp.class) {
            return new Timestamp(this.raf.readLong());
        }
        if (binding == java.util.Date.class) {
            return new java.util.Date(this.raf.readLong());
        }
        if (Geometry.class.isAssignableFrom(binding)) {
            WKBReader reader = new WKBReader();
            int length = this.raf.readInt();
            byte[] buffer = new byte[length];
            this.raf.read(buffer);
            try {
                return reader.read(buffer);
            }
            catch (ParseException e) {
                throw new IOException("Failed to parse the geometry WKB", e);
            }
        }
        int length = this.raf.readInt();
        byte[] buffer = new byte[length];
        this.raf.read(buffer);
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not read back object", e);
        }
    }
}

