/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import javax.measure.unit.NonSI;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.TransformedDirectPosition;
import org.geotools.io.TableWriter;
import org.geotools.measure.Angle;
import org.geotools.measure.CoordinateFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.TransformException;

public class GeodeticCalculator {
    private static final double TOLERANCE_0 = 5.0E-15;
    private static final double TOLERANCE_1 = 5.0E-14;
    private static final double TOLERANCE_2 = 5.0E-13;
    private static final double TOLERANCE_3 = 0.007;
    private static final double TOLERANCE_CHECK = 1.0E-8;
    private final TransformedDirectPosition userToGeodetic;
    private CoordinateReferenceSystem coordinateReferenceSystem;
    private GeographicCRS geographicCRS;
    private final Ellipsoid ellipsoid;
    private final double semiMajorAxis;
    private final double semiMinorAxis;
    private final double eccentricitySquared;
    private final double maxOrthodromicDistance;
    private final double A;
    private final double B;
    private final double C;
    private final double D;
    private final double E;
    private final double F;
    private final double fo;
    private final double f;
    private final double f2;
    private final double f3;
    private final double f4;
    private final double T1;
    private final double T2;
    private final double T4;
    private final double T6;
    private final double a01;
    private final double a02;
    private final double a03;
    private final double a21;
    private final double a22;
    private final double a23;
    private final double a42;
    private final double a43;
    private final double a63;
    private double lat1;
    private double long1;
    private double lat2;
    private double long2;
    private double distance;
    private double azimuth;
    private boolean destinationValid;
    private boolean directionValid;
    private boolean antipodal;

    public GeodeticCalculator() {
        this(DefaultEllipsoid.WGS84);
    }

    public GeodeticCalculator(Ellipsoid ellipsoid) {
        this(ellipsoid, null);
    }

    public GeodeticCalculator(CoordinateReferenceSystem crs) {
        this(CRS.getEllipsoid(crs), crs);
    }

    private GeodeticCalculator(Ellipsoid ellipsoid, CoordinateReferenceSystem crs) {
        if (ellipsoid == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)"ellipsoid"));
        }
        this.ellipsoid = ellipsoid;
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.semiMinorAxis = ellipsoid.getSemiMinorAxis();
        if (crs != null) {
            this.coordinateReferenceSystem = crs;
            this.geographicCRS = GeodeticCalculator.getGeographicCRS(crs);
            this.userToGeodetic = new TransformedDirectPosition(crs, (CoordinateReferenceSystem)this.geographicCRS, null);
        } else {
            this.userToGeodetic = null;
        }
        this.f = (this.semiMajorAxis - this.semiMinorAxis) / this.semiMajorAxis;
        this.fo = 1.0 - this.f;
        this.f2 = this.f * this.f;
        this.f3 = this.f * this.f2;
        this.f4 = this.f * this.f3;
        double E2 = this.eccentricitySquared = this.f * (2.0 - this.f);
        double E4 = E2 * E2;
        double E6 = E4 * E2;
        double E8 = E6 * E2;
        double EX = E8 * E2;
        this.A = 1.0 + 0.75 * E2 + 0.703125 * E4 + 0.68359375 * E6 + 0.67291259765625 * E8 + 0.6661834716796875 * EX;
        this.B = 0.75 * E2 + 0.9375 * E4 + 1.025390625 * E6 + 1.07666015625 * E8 + 1.1103057861328125 * EX;
        this.C = 0.234375 * E4 + 0.41015625 * E6 + 0.538330078125 * E8 + 0.63446044921875 * EX;
        this.D = 0.068359375 * E6 + 0.15380859375 * E8 + 0.23792266845703125 * EX;
        this.E = 0.01922607421875 * E8 + 0.0528717041015625 * EX;
        this.F = 0.00528717041015625 * EX;
        this.maxOrthodromicDistance = this.semiMajorAxis * (1.0 - E2) * Math.PI * this.A - 1.0;
        this.T1 = 1.0;
        this.T2 = -0.25 * this.f * (1.0 + this.f + this.f2);
        this.T4 = 0.1875 * this.f2 * (1.0 + 2.25 * this.f);
        this.T6 = 0.1953125 * this.f3;
        double a = this.f3 * (1.0 + 2.25 * this.f);
        this.a01 = -this.f2 * (1.0 + this.f + this.f2) / 4.0;
        this.a02 = 0.1875 * a;
        this.a03 = -0.1953125 * this.f4;
        this.a21 = -this.a01;
        this.a22 = -0.25 * a;
        this.a23 = 0.29296875 * this.f4;
        this.a42 = 0.03125 * a;
        this.a43 = 0.05859375 * this.f4;
        this.a63 = 5.0 * this.f4 / 768.0;
    }

    private static GeographicCRS getGeographicCRS(CoordinateReferenceSystem crs) {
        CoordinateSystem cs;
        if (crs instanceof GeographicCRS && (cs = crs.getCoordinateSystem()).getDimension() == 2 && GeodeticCalculator.isStandard(cs.getAxis(0), AxisDirection.EAST) && GeodeticCalculator.isStandard(cs.getAxis(1), AxisDirection.NORTH)) {
            return (GeographicCRS)crs;
        }
        Datum datum = CRSUtilities.getDatum(crs);
        if (datum instanceof GeodeticDatum) {
            return new DefaultGeographicCRS("Geodetic", (GeodeticDatum)datum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        }
        if (crs instanceof CompoundCRS) {
            for (CoordinateReferenceSystem component : ((CompoundCRS)crs).getCoordinateReferenceSystems()) {
                GeographicCRS candidate = GeodeticCalculator.getGeographicCRS(component);
                if (candidate == null) continue;
                return candidate;
            }
        }
        throw new IllegalArgumentException(Errors.format((int)62));
    }

    private static boolean isStandard(CoordinateSystemAxis axis, AxisDirection direction) {
        return direction.equals((Object)axis.getDirection()) && NonSI.DEGREE_ANGLE.equals((Object)axis.getUnit());
    }

    private static double castToAngleRange(double alpha) {
        return alpha - Math.PI * 2 * Math.floor(alpha / (Math.PI * 2) + 0.5);
    }

    private static double checkLatitude(double latitude) throws IllegalArgumentException {
        if (latitude >= -90.0 && latitude <= 90.0) {
            return Math.toRadians(latitude);
        }
        throw new IllegalArgumentException(Errors.format((int)85, (Object)new Latitude(latitude)));
    }

    private static double checkLongitude(double longitude) throws IllegalArgumentException {
        if (longitude >= -180.0 && longitude <= 180.0) {
            return Math.toRadians(longitude);
        }
        throw new IllegalArgumentException(Errors.format((int)88, (Object)new Longitude(longitude)));
    }

    private static double checkAzimuth(double azimuth) throws IllegalArgumentException {
        if (azimuth >= -180.0 && azimuth <= 180.0) {
            return Math.toRadians(azimuth);
        }
        throw new IllegalArgumentException(Errors.format((int)6, (Object)new Longitude(azimuth)));
    }

    private void checkOrthodromicDistance(double distance) throws IllegalArgumentException {
        if (!(distance >= 0.0) || !(distance <= this.maxOrthodromicDistance)) {
            throw new IllegalArgumentException(Errors.format((int)43, (Object)distance, (Object)0.0, (Object)this.maxOrthodromicDistance, (Object)this.ellipsoid.getAxisUnit()));
        }
    }

    private static void checkNumberOfPoints(int numberOfPoints) throws IllegalArgumentException {
        if (numberOfPoints < 0) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"numberOfPoints", (Object)numberOfPoints));
        }
    }

    private String getNoConvergenceErrorMessage() {
        CoordinateFormat cf = new CoordinateFormat();
        return Errors.format((int)130, (Object)GeodeticCalculator.format(cf, this.long1, this.lat1), (Object)GeodeticCalculator.format(cf, this.long2, this.lat2));
    }

    private static String format(Format cf, double longitude, double latitude) {
        return cf.format(new GeneralDirectPosition(Math.toDegrees(longitude), Math.toDegrees(latitude)));
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.coordinateReferenceSystem == null) {
            this.coordinateReferenceSystem = this.getGeographicCRS();
        }
        return this.coordinateReferenceSystem;
    }

    public GeographicCRS getGeographicCRS() {
        if (this.geographicCRS == null) {
            String name = Vocabulary.format((int)83);
            this.geographicCRS = new DefaultGeographicCRS(name, (GeodeticDatum)new DefaultGeodeticDatum(name, this.getEllipsoid(), (PrimeMeridian)DefaultPrimeMeridian.GREENWICH), (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        }
        return this.geographicCRS;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public void setStartingGeographicPoint(double longitude, double latitude) throws IllegalArgumentException {
        longitude = GeodeticCalculator.checkLongitude(longitude);
        latitude = GeodeticCalculator.checkLatitude(latitude);
        this.long1 = longitude;
        this.lat1 = latitude;
        this.destinationValid = false;
        this.directionValid = false;
    }

    public void setStartingGeographicPoint(Point2D point) throws IllegalArgumentException {
        this.setStartingGeographicPoint(point.getX(), point.getY());
    }

    public void setStartingPosition(Position position) throws TransformException {
        DirectPosition p = position.getDirectPosition();
        if (this.userToGeodetic != null) {
            this.userToGeodetic.transform(p);
            p = this.userToGeodetic;
        }
        this.setStartingGeographicPoint(p.getOrdinate(0), p.getOrdinate(1));
    }

    public Point2D getStartingGeographicPoint() {
        return new Point2D.Double(Math.toDegrees(this.long1), Math.toDegrees(this.lat1));
    }

    public DirectPosition getStartingPosition() throws TransformException {
        DirectPosition position = this.userToGeodetic;
        if (position == null) {
            position = new DirectPosition2D();
        }
        position.setOrdinate(0, Math.toDegrees(this.long1));
        position.setOrdinate(1, Math.toDegrees(this.lat1));
        if (this.userToGeodetic != null) {
            position = this.userToGeodetic.inverseTransform();
        }
        return position;
    }

    public void setDestinationGeographicPoint(double longitude, double latitude) throws IllegalArgumentException {
        longitude = GeodeticCalculator.checkLongitude(longitude);
        latitude = GeodeticCalculator.checkLatitude(latitude);
        this.long2 = longitude;
        this.lat2 = latitude;
        this.destinationValid = true;
        this.directionValid = false;
    }

    public void setDestinationGeographicPoint(Point2D point) throws IllegalArgumentException {
        this.setDestinationGeographicPoint(point.getX(), point.getY());
    }

    public void setDestinationPosition(Position position) throws TransformException {
        DirectPosition p = position.getDirectPosition();
        if (this.userToGeodetic != null) {
            this.userToGeodetic.transform(p);
            p = this.userToGeodetic;
        }
        this.setDestinationGeographicPoint(p.getOrdinate(0), p.getOrdinate(1));
    }

    public Point2D getDestinationGeographicPoint() throws IllegalStateException {
        if (!this.destinationValid) {
            this.computeDestinationPoint();
        }
        return new Point2D.Double(Math.toDegrees(this.long2), Math.toDegrees(this.lat2));
    }

    public DirectPosition getDestinationPosition() throws TransformException {
        DirectPosition position;
        if (!this.destinationValid) {
            this.computeDestinationPoint();
        }
        if ((position = this.userToGeodetic) == null) {
            position = new DirectPosition2D();
        }
        position.setOrdinate(0, Math.toDegrees(this.long2));
        position.setOrdinate(1, Math.toDegrees(this.lat2));
        if (this.userToGeodetic != null) {
            position = this.userToGeodetic.inverseTransform();
        }
        return position;
    }

    public void setDirection(double azimuth, double distance) throws IllegalArgumentException {
        azimuth = GeodeticCalculator.checkAzimuth(azimuth);
        this.checkOrthodromicDistance(distance);
        this.azimuth = azimuth;
        this.distance = distance;
        this.destinationValid = false;
        this.directionValid = true;
    }

    public double getAzimuth() throws IllegalStateException {
        if (!this.directionValid) {
            this.computeDirection();
            if (this.antipodal) {
                Logging.getLogger(GeodeticCalculator.class).warning("Azimuth is innacurate for antipodal points.");
            }
        }
        return Math.toDegrees(this.azimuth);
    }

    public double getOrthodromicDistance() throws IllegalStateException {
        if (!this.directionValid) {
            this.computeDirection();
            if (this.antipodal) {
                if (this.ellipsoid instanceof DefaultEllipsoid) {
                    return ((DefaultEllipsoid)this.ellipsoid).orthodromicDistance(Math.toDegrees(this.long1), Math.toDegrees(this.lat1), Math.toDegrees(this.long2), Math.toDegrees(this.lat2));
                }
            } else assert (this.checkOrthodromicDistance()) : this;
        }
        return this.distance;
    }

    private boolean checkOrthodromicDistance() {
        if (this.ellipsoid instanceof DefaultEllipsoid) {
            DefaultEllipsoid ellipsoid = (DefaultEllipsoid)this.ellipsoid;
            double check = ellipsoid.orthodromicDistance(Math.toDegrees(this.long1), Math.toDegrees(this.lat1), Math.toDegrees(this.long2), Math.toDegrees(this.lat2));
            return (check = Math.abs(this.distance - check)) <= (this.distance + 1.0) * 1.0E-8;
        }
        return true;
    }

    private void computeDestinationPoint() throws IllegalStateException {
        double E;
        double CY;
        double CZ;
        double SY;
        if (!this.directionValid) {
            throw new IllegalStateException(Errors.format((int)41));
        }
        double lat1 = this.lat1;
        double long1 = this.long1;
        double azimuth = this.azimuth;
        double distance = this.distance;
        double TU = this.fo * Math.sin(lat1) / Math.cos(lat1);
        double SF = Math.sin(azimuth);
        double CF = Math.cos(azimuth);
        double BAZ = CF != 0.0 ? Math.atan2(TU, CF) * 2.0 : 0.0;
        double CU = 1.0 / Math.sqrt(TU * TU + 1.0);
        double SU = TU * CU;
        double SA = CU * SF;
        double C2A = 1.0 - SA * SA;
        double X = Math.sqrt((1.0 / this.fo / this.fo - 1.0) * C2A + 1.0) + 1.0;
        X = (X - 2.0) / X;
        double C = 1.0 - X;
        C = (X * X / 4.0 + 1.0) / C;
        double D = (0.375 * X * X - 1.0) * X;
        double Y = TU = distance / this.fo / this.semiMajorAxis / C;
        do {
            SY = Math.sin(Y);
            CY = Math.cos(Y);
            CZ = Math.cos(BAZ + Y);
            E = CZ * CZ * 2.0 - 1.0;
            C = Y;
            X = E * CY;
            Y = E + E - 1.0;
        } while (Math.abs((Y = (((SY * SY * 4.0 - 3.0) * Y * CZ * D / 6.0 + X) * D / 4.0 - CZ) * SY * D + TU) - C) > 5.0E-14);
        BAZ = CU * CY * CF - SU * SY;
        C = this.fo * Math.hypot(SA, BAZ);
        D = SU * CY + CU * SY * CF;
        this.lat2 = Math.atan2(D, C);
        C = CU * CY - SU * SY * CF;
        X = Math.atan2(SY * SF, C);
        C = ((-3.0 * C2A + 4.0) * this.f + 4.0) * C2A * this.f / 16.0;
        D = ((E * CY * C + CZ) * SY * C + Y) * SA;
        this.long2 = long1 + X - (1.0 - C) * D * this.f;
        this.long2 = GeodeticCalculator.castToAngleRange(this.long2);
        this.destinationValid = true;
    }

    public double getMeridianArcLength(double latitude1, double latitude2) {
        return this.getMeridianArcLengthRadians(GeodeticCalculator.checkLatitude(latitude1), GeodeticCalculator.checkLatitude(latitude2));
    }

    private double getMeridianArcLengthRadians(double P1, double P2) {
        double S1 = Math.abs(P1);
        double S2 = Math.abs(P2);
        double DA = P2 - P1;
        if (S1 > 5.0E-15 || S2 <= 1.5707963267948915 || S2 >= 1.5707963267949017) {
            double DB = Math.sin(P2 * 2.0) - Math.sin(P1 * 2.0);
            double DC = Math.sin(P2 * 4.0) - Math.sin(P1 * 4.0);
            double DD = Math.sin(P2 * 6.0) - Math.sin(P1 * 6.0);
            double DE = Math.sin(P2 * 8.0) - Math.sin(P1 * 8.0);
            double DF = Math.sin(P2 * 10.0) - Math.sin(P1 * 10.0);
            S2 = -DB * this.B / 2.0 + DC * this.C / 4.0 - DD * this.D / 6.0 + DE * this.E / 8.0 - DF * this.F / 10.0;
        } else {
            S2 = 0.0;
        }
        S1 = DA * this.A;
        return Math.abs(this.semiMajorAxis * (1.0 - this.eccentricitySquared) * (S1 + S2));
    }

    private void computeDirection() throws IllegalStateException {
        double az1;
        double r3;
        double r2;
        double q6;
        double q4;
        double q2;
        double w;
        double sinalf;
        double sig;
        double ssig;
        double slon;
        double clon;
        double xy;
        if (!this.destinationValid) {
            throw new IllegalStateException(Errors.format((int)40));
        }
        double long1 = this.long1;
        double lat1 = this.lat1;
        double long2 = this.long2;
        double lat2 = this.lat2;
        double dlon = GeodeticCalculator.castToAngleRange(long2 - long1);
        double ss = Math.abs(dlon);
        if (ss < 5.0E-14) {
            this.distance = this.getMeridianArcLengthRadians(lat1, lat2);
            this.azimuth = lat2 > lat1 ? 0.0 : Math.PI;
            this.directionValid = true;
            this.antipodal = false;
            return;
        }
        this.antipodal = Math.PI - ss < 0.014 && Math.abs(lat1 + lat2) < 0.014;
        double ESQP = this.eccentricitySquared / (1.0 - this.eccentricitySquared);
        double alimit = Math.PI * this.fo;
        if (ss >= alimit && lat1 < 0.007 && lat1 > -0.007 && lat2 < 0.007 && lat2 > -0.007) {
            double AO;
            double AZ_TEMP;
            double S;
            double CONS = (Math.PI - ss) / (Math.PI * this.f);
            double AZ = Math.asin(CONS);
            int iter = 0;
            do {
                if (++iter > 8) {
                    throw new ArithmeticException(this.getNoConvergenceErrorMessage());
                }
                S = Math.cos(AZ);
                double C2 = S * S;
                AO = this.T1 + this.T2 * C2 + this.T4 * C2 * C2 + this.T6 * C2 * C2 * C2;
                double CS2 = CONS / AO;
                S = Math.asin(CS2);
                AZ_TEMP = AZ;
                AZ = S;
            } while (Math.abs(S - AZ_TEMP) >= 5.0E-13);
            double AZ1 = dlon < 0.0 ? Math.PI * 2 - S : S;
            this.azimuth = GeodeticCalculator.castToAngleRange(AZ1);
            S = Math.cos(AZ1);
            double U2 = ESQP * S * S;
            double U4 = U2 * U2;
            double U6 = U4 * U2;
            double U8 = U6 * U2;
            double BO = 1.0 + 0.25 * U2 + 0.046875 * U4 + 0.01953125 * U6 + -0.01068115234375 * U8;
            S = Math.sin(AZ1);
            double SMS = this.semiMajorAxis * Math.PI * (1.0 - this.f * Math.abs(S) * AO - BO * this.fo);
            this.distance = this.semiMajorAxis * ss - SMS;
            this.directionValid = true;
            return;
        }
        double u1 = Math.atan(this.fo * Math.sin(lat1) / Math.cos(lat1));
        double u2 = Math.atan(this.fo * Math.sin(lat2) / Math.cos(lat2));
        double su1 = Math.sin(u1);
        double cu1 = Math.cos(u1);
        double su2 = Math.sin(u2);
        double cu2 = Math.cos(u2);
        double ab = dlon;
        int kcount = 0;
        do {
            if (++kcount > 12) {
                throw new ArithmeticException(this.getNoConvergenceErrorMessage());
            }
            clon = Math.cos(ab);
            slon = Math.sin(ab);
            double csig = su1 * su2 + cu1 * cu2 * clon;
            ssig = Math.hypot(slon * cu2, su2 * cu1 - su1 * cu2 * clon);
            sig = Math.atan2(ssig, csig);
            sinalf = cu1 * cu2 * slon / ssig;
            w = 1.0 - sinalf * sinalf;
            double t4 = w * w;
            double t6 = w * t4;
            double ao = this.f + this.a01 * w + this.a02 * t4 + this.a03 * t6;
            double a2 = this.a21 * w + this.a22 * t4 + this.a23 * t6;
            double a4 = this.a42 * t4 + this.a43 * t6;
            double a6 = this.a63 * t6;
            double qo = 0.0;
            if (w > 5.0E-15) {
                qo = -2.0 * su1 * su2 / w;
            }
            q2 = csig + qo;
            q4 = 2.0 * q2 * q2 - 1.0;
            q6 = q2 * (4.0 * q2 * q2 - 3.0);
            r2 = 2.0 * ssig * csig;
            r3 = ssig * (3.0 - 4.0 * ssig * ssig);
            double s = sinalf * (ao * sig + a2 * ssig * q2 + a4 * r2 * q4 + a6 * r3 * q6);
            double xz = dlon + s;
            xy = Math.abs(xz - ab);
            ab = dlon + s;
        } while (xy >= 5.0E-14);
        double z = ESQP * w;
        double bo = 1.0 + z * (0.25 + z * (-0.046875 + z * (0.01953125 - z * 0.01068115234375)));
        double b2 = z * (-0.25 + z * (0.0625 + z * (-0.029296875 + z * 0.01708984375)));
        double b4 = z * z * (-0.0078125 + z * (0.005859375 - z * 0.0042724609375));
        double b6 = z * z * z * (-6.510416666666666E-4 + z * 8.138020833333334E-4);
        this.distance = this.semiMinorAxis * (bo * sig + b2 * ssig * q2 + b4 * r2 * q4 + b6 * r3 * q6);
        double d = az1 = dlon < 0.0 ? 4.71238898038469 : 1.5707963267948966;
        if (Math.abs(su1) >= 5.0E-15 || Math.abs(su2) >= 5.0E-15) {
            double tana1 = slon * cu2 / (su2 * cu1 - clon * su1 * cu2);
            double sina1 = sinalf / cu1;
            az1 = Math.atan2(sina1, sina1 / tana1);
        }
        this.azimuth = GeodeticCalculator.castToAngleRange(az1);
        this.directionValid = true;
    }

    public Shape getGeodeticCurve(int numberOfPoints) {
        List<Point2D> points = this.getGeodeticPath(numberOfPoints);
        GeneralPath path = new GeneralPath(0, numberOfPoints + 1);
        Point2D start = points.get(0);
        path.moveTo(start.getX(), start.getY());
        for (int i = 1; i < points.size(); ++i) {
            Point2D p = points.get(i);
            path.lineTo(p.getX(), p.getY());
        }
        return path;
    }

    public Shape getGeodeticCurve() {
        return this.getGeodeticCurve(10);
    }

    public List<Point2D> getGeodeticPath(int numPoints) {
        if (numPoints < 0) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"numPoints", (Object)numPoints));
        }
        ArrayList<Point2D> points = new ArrayList<Point2D>(numPoints + 2);
        if (!this.directionValid) {
            this.computeDirection();
        }
        if (!this.destinationValid) {
            this.computeDestinationPoint();
        }
        double long2 = this.long2;
        double lat2 = this.lat2;
        double distance = this.distance;
        double delta = distance / (double)(numPoints + 1);
        points.add(new Point2D.Double(Math.toDegrees(this.long1), Math.toDegrees(this.lat1)));
        for (int i = 1; i <= numPoints; ++i) {
            this.distance = (double)i * delta;
            this.computeDestinationPoint();
            points.add(new Point2D.Double(Math.toDegrees(this.long2), Math.toDegrees(this.lat2)));
        }
        points.add(new Point2D.Double(Math.toDegrees(long2), Math.toDegrees(lat2)));
        this.long2 = long2;
        this.lat2 = lat2;
        this.distance = distance;
        return points;
    }

    private Shape getLoxodromicCurve() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        Vocabulary resources = Vocabulary.getResources(null);
        TableWriter buffer = new TableWriter(null, " ");
        if (this.coordinateReferenceSystem != null) {
            buffer.write(resources.getLabel(32));
            buffer.nextColumn();
            buffer.write(this.coordinateReferenceSystem.getName().getCode());
            buffer.nextLine();
        }
        if (this.ellipsoid != null) {
            buffer.write(resources.getLabel(56));
            buffer.nextColumn();
            buffer.write(this.ellipsoid.getName().getCode());
            buffer.nextLine();
        }
        CoordinateFormat cf = new CoordinateFormat();
        Format nf = cf.getFormat(0);
        buffer.write(resources.getLabel(201));
        buffer.nextColumn();
        buffer.write(GeodeticCalculator.format(cf, this.long1, this.lat1));
        buffer.nextLine();
        if (this.destinationValid) {
            buffer.write(resources.getLabel(212));
            buffer.nextColumn();
            buffer.write(GeodeticCalculator.format(cf, this.long2, this.lat2));
            buffer.nextLine();
        }
        if (this.directionValid) {
            buffer.write(resources.getLabel(8));
            buffer.nextColumn();
            buffer.write(nf.format(new Angle(Math.toDegrees(this.azimuth))));
            buffer.nextLine();
        }
        if (this.directionValid) {
            buffer.write(resources.getLabel(159));
            buffer.nextColumn();
            buffer.write(nf.format(this.distance));
            if (this.ellipsoid != null) {
                buffer.write(32);
                buffer.write(this.ellipsoid.getAxisUnit().toString());
            }
            buffer.nextLine();
        }
        return buffer.toString();
    }
}

