/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.files;

import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.geotools.data.shapefile.files.FileReader;
import org.geotools.data.shapefile.files.FileWriter;
import org.geotools.data.shapefile.files.ShpFiles;

public class FileChannelDecorator
extends FileChannel
implements ReadableByteChannel {
    private final FileChannel wrapped;
    private final ShpFiles shapefileFiles;
    private final URL url;
    private final FileReader reader;
    private final FileWriter writer;
    private boolean closed;

    public FileChannelDecorator(FileChannel channel, ShpFiles shapefileFiles, URL url, FileReader requestor) {
        this.wrapped = channel;
        this.shapefileFiles = shapefileFiles;
        this.url = url;
        this.reader = requestor;
        this.writer = null;
        this.closed = false;
    }

    public FileChannelDecorator(FileChannel channel, ShpFiles shapefileFiles, URL url, FileWriter requestor) {
        this.wrapped = channel;
        this.shapefileFiles = shapefileFiles;
        this.url = url;
        this.writer = requestor;
        this.reader = null;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.wrapped.force(metaData);
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.wrapped.lock(position, size, shared);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        return this.shapefileFiles.map(this.wrapped, this.url, mode, position, size);
    }

    @Override
    public long position() throws IOException {
        return this.wrapped.position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        return this.wrapped.position(newPosition);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.wrapped.read(dst, position);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.wrapped.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.wrapped.read(dsts, offset, length);
    }

    @Override
    public long size() throws IOException {
        return this.wrapped.size();
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        return this.wrapped.transferFrom(src, position, count);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return this.wrapped.transferTo(position, count, target);
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        return this.wrapped.truncate(size);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.wrapped.tryLock(position, size, shared);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        return this.wrapped.write(src, position);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.wrapped.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.wrapped.write(srcs, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() throws IOException {
        try {
            this.wrapped.close();
        }
        finally {
            if (!this.closed) {
                this.closed = true;
                if (this.reader != null) {
                    this.shapefileFiles.unlockRead(this.url, this.reader);
                } else {
                    this.shapefileFiles.unlockWrite(this.url, this.writer);
                }
            }
        }
    }
}

