/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import javax.measure.unit.Unit;
import javax.media.jai.KernelJAI;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.coverage.Category;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.util.NumberRange;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform2D;

public class GradientMagnitude
extends OperationJAI {
    private static final long serialVersionUID = -1514713427236924048L;
    private static final boolean DEBUG = false;
    private static final boolean NORMALIZE = true;
    private static final double DEFAULT_RANGE_SCALE = 1.0;
    private static final Color[] DEFAULT_COLOR_PALETTE = new Color[]{new Color(16, 32, 64), new Color(192, 224, 255)};
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;

    public GradientMagnitude() {
        super("GradientMagnitude");
    }

    private static double getScaleFactor(KernelJAI kernel, double scaleX, double scaleY) {
        scaleX *= scaleX;
        scaleY *= scaleY;
        double factorX = GradientMagnitude.getNormalizationFactorSquared(kernel, 1);
        double factorY = GradientMagnitude.getNormalizationFactorSquared(kernel, 2);
        double factor2 = (factorX * scaleX + factorY * scaleY) / (factorX + factorY);
        return Math.sqrt(factor2);
    }

    private static double getNormalizationFactorSquared(KernelJAI kernel, int type) {
        int value;
        double sumH = 0.0;
        double sumV = 0.0;
        int width = kernel.getWidth();
        int height = kernel.getHeight();
        if ((type & 1) != 0) {
            value = kernel.getYOrigin();
            int y = height;
            while (--y >= 0) {
                int x = width;
                while (--x >= 0) {
                    sumH += (double)((float)value * kernel.getElement(x, y));
                }
                --value;
            }
        }
        if ((type & 2) != 0) {
            value = kernel.getXOrigin();
            int x = width;
            while (--x >= 0) {
                int y = height;
                while (--y >= 0) {
                    sumV += (double)((float)value * kernel.getElement(x, y));
                }
                --value;
            }
        }
        return sumH * sumH + sumV * sumV;
    }

    private static double getNormalizationFactor(KernelJAI mask1, KernelJAI mask2) {
        double factor = GradientMagnitude.getNormalizationFactorSquared(mask1, 3);
        factor += GradientMagnitude.getNormalizationFactorSquared(mask2, 3);
        factor = Math.sqrt(factor / 2.0);
        return factor;
    }

    private static KernelJAI divide(KernelJAI kernel, double denominator) {
        if (denominator != 1.0) {
            float[] data = kernel.getKernelData();
            int length = data.length;
            int i = 0;
            while (i < length) {
                int n = i++;
                data[n] = (float)((double)data[n] / denominator);
            }
            kernel = new KernelJAI(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), data);
        }
        return kernel;
    }

    @Override
    protected GridCoverage2D deriveGridCoverage(GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        MathTransform2D mtr;
        KernelJAI mask2;
        ParameterBlockJAI block = parameters.parameters;
        KernelJAI mask1 = (KernelJAI)block.getObjectParameter("Mask1");
        double factor = GradientMagnitude.getNormalizationFactor(mask1, mask2 = (KernelJAI)block.getObjectParameter("Mask2"));
        if (!(factor > 0.0)) {
            factor = 1.0;
        }
        double scaleMask1 = 1.0;
        double scaleMask2 = 1.0;
        if (sources.length != 0 && (mtr = sources[0].getGridGeometry().getGridToCRS2D()) instanceof AffineTransform) {
            AffineTransform tr = (AffineTransform)mtr;
            double scaleX = XAffineTransform.getScaleX0(tr);
            double scaleY = XAffineTransform.getScaleY0(tr);
            scaleMask1 = GradientMagnitude.getScaleFactor(mask1, scaleX, scaleY);
            scaleMask2 = GradientMagnitude.getScaleFactor(mask2, scaleX, scaleY);
            if (!(scaleMask1 > 0.0) || !(scaleMask2 > 0.0)) {
                scaleMask1 = 1.0;
                scaleMask2 = 1.0;
            }
        }
        block.setParameter("Mask1", (Object)GradientMagnitude.divide(mask1, factor * scaleMask1));
        block.setParameter("Mask2", (Object)GradientMagnitude.divide(mask2, factor * scaleMask2));
        return super.deriveGridCoverage(sources, parameters);
    }

    @Override
    protected Category deriveCategory(Category[] categories, OperationJAI.Parameters parameters) {
        NumberRange range = null;
        Category category = categories[0];
        NumberRange<? extends Number> samples = category.geophysics(false).getRange();
        boolean isGeophysics = category == category.geophysics(true);
        ParameterBlockJAI block = parameters.parameters;
        KernelJAI mask1 = (KernelJAI)block.getObjectParameter("Mask1");
        KernelJAI mask2 = (KernelJAI)block.getObjectParameter("Mask2");
        double size = (double)(mask1.getWidth() + mask1.getHeight() + mask2.getWidth() + mask2.getHeight()) / 4.0;
        double factor = GradientMagnitude.getNormalizationFactor(mask1, mask2) / (size - 1.0);
        if (factor > 0.0 && !Double.isInfinite(factor)) {
            range = category.geophysics(true).getRange();
            double minimum = range.getMinimum();
            double maximum = range.getMaximum();
            range = NumberRange.create((double)0.0, (double)(factor *= (maximum - minimum) * 1.0));
        }
        if (range != null) {
            category = new Category((CharSequence)category.getName(), DEFAULT_COLOR_PALETTE, samples, range);
            return category.geophysics(isGeophysics);
        }
        return super.deriveCategory(categories, parameters);
    }

    protected Unit deriveUnit(Unit[] units, OperationJAI.Parameters parameters) {
        CoordinateSystem cs = parameters.crs.getCoordinateSystem();
        if (units.length == 1 && units[0] != null) {
            Unit spatialUnit = cs.getAxis(0).getUnit();
            int i = Math.min(cs.getDimension(), 2);
            while (--i >= 0) {
                if (spatialUnit.equals((Object)cs.getAxis(i).getUnit())) continue;
                return super.deriveUnit(units, parameters);
            }
            try {
                return units[0].divide(spatialUnit);
            }
            catch (RuntimeException exception) {
                // empty catch block
            }
        }
        return super.deriveUnit(units, parameters);
    }
}

