/*
 * Decompiled with CFR 0.152.
 */
package CommandLine;

import CommandLine.CommandLine;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

final class OsmToCmd {
    private final CommandLine parentPlugin;
    private final DataSet targetDataSet;
    private final LinkedList<Command> cmds = new LinkedList();
    private final HashMap<PrimitiveId, OsmPrimitive> externalIdMap;

    public OsmToCmd(CommandLine parentPlugin, DataSet targetDataSet) {
        this.parentPlugin = parentPlugin;
        this.targetDataSet = targetDataSet;
        this.externalIdMap = new HashMap();
    }

    public void parseStream(InputStream stream) throws IllegalDataException {
        try {
            InputSource inputSource = new InputSource((Reader)UTFInputStreamReader.create((InputStream)stream, (String)"UTF-8"));
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            Parser handler = new Parser();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalDataException(e.getMessage(), (Throwable)e);
        }
        catch (SAXParseException e) {
            throw new IllegalDataException(I18n.tr((String)"Line {0} column {1}: ", (Object[])new Object[]{e.getLineNumber(), e.getColumnNumber()}) + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new IllegalDataException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new IllegalDataException((Throwable)e);
        }
    }

    public LinkedList<Command> getCommandList() {
        return this.cmds;
    }

    private class Parser
    extends DefaultHandler
    implements LexicalHandler {
        private Locator locator;
        private OsmPrimitive currentPrimitive;
        private final List<Node> currentWayNodes = new ArrayList<Node>();
        private final List<RelationMember> currentRelationMembers = new ArrayList<RelationMember>();

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String msg) throws XmlParsingException {
            throw new XmlParsingException(msg).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            block29: {
                try {
                    if (qName.equals("osm")) {
                        String v;
                        if (atts == null) {
                            this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}'' of XML element {1}.", (Object[])new Object[]{"version", "osm"}));
                        }
                        if ((v = atts.getValue("version")) == null) {
                            this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}''.", (Object[])new Object[]{"version"}));
                        }
                        if (!v.equals("0.6")) {
                            this.throwException(I18n.tr((String)"Unsupported version: {0}", (Object[])new Object[]{v}));
                        }
                        break block29;
                    }
                    if (qName.equals("node")) {
                        Node n = new Node();
                        NodeData source = new NodeData();
                        source.setCoor(new LatLon(this.getDouble(atts, "lat"), this.getDouble(atts, "lon")));
                        this.readCommon(atts, (PrimitiveData)source);
                        Node target = (Node)OsmToCmd.this.targetDataSet.getPrimitiveById(source.getUniqueId(), source.getType());
                        if (target == null || !source.isModified() && !source.isDeleted()) {
                            n.load((PrimitiveData)source);
                        } else {
                            n.cloneFrom((OsmPrimitive)target);
                            n.load((PrimitiveData)source);
                        }
                        this.currentPrimitive = n;
                        OsmToCmd.this.externalIdMap.put(source.getPrimitiveId(), n);
                        break block29;
                    }
                    if (qName.equals("way")) {
                        Way w = new Way();
                        WayData source = new WayData();
                        this.readCommon(atts, (PrimitiveData)source);
                        Way target = (Way)OsmToCmd.this.targetDataSet.getPrimitiveById(source.getUniqueId(), source.getType());
                        if (target == null || !source.isModified() && !source.isDeleted()) {
                            w.load((PrimitiveData)source);
                        } else {
                            w.cloneFrom((OsmPrimitive)target);
                            w.load((PrimitiveData)source);
                        }
                        this.currentPrimitive = w;
                        this.currentWayNodes.clear();
                        OsmToCmd.this.externalIdMap.put(source.getPrimitiveId(), w);
                        break block29;
                    }
                    if (qName.equals("nd")) {
                        Node node;
                        long id;
                        if (atts.getValue("ref") == null) {
                            this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}'' on <nd> of way {1}.", (Object[])new Object[]{"ref", this.currentPrimitive.getUniqueId()}));
                        }
                        if ((id = this.getLong(atts, "ref")) == 0L) {
                            this.throwException(I18n.tr((String)"Illegal value of attribute ''ref'' of element <nd>. Got {0}.", (Object[])new Object[]{id}));
                        }
                        if (((node = (Node)OsmToCmd.this.externalIdMap.get(new SimplePrimitiveId(id, OsmPrimitiveType.NODE))) == null || node.isModified()) && (node = (Node)OsmToCmd.this.targetDataSet.getPrimitiveById((PrimitiveId)new SimplePrimitiveId(id, OsmPrimitiveType.NODE))) == null) {
                            this.throwException(I18n.tr((String)"Missing definition of new object with id {0}.", (Object[])new Object[]{id}));
                        }
                        this.currentWayNodes.add(node);
                        break block29;
                    }
                    if (qName.equals("relation")) {
                        Relation r = new Relation();
                        RelationData source = new RelationData();
                        this.readCommon(atts, (PrimitiveData)source);
                        Relation target = (Relation)OsmToCmd.this.targetDataSet.getPrimitiveById(source.getUniqueId(), source.getType());
                        if (target == null || !source.isModified() && !source.isDeleted()) {
                            r.load((PrimitiveData)source);
                        } else {
                            r.cloneFrom((OsmPrimitive)target);
                            r.load((PrimitiveData)source);
                        }
                        this.currentPrimitive = r;
                        this.currentRelationMembers.clear();
                        OsmToCmd.this.externalIdMap.put(source.getPrimitiveId(), r);
                        break block29;
                    }
                    if (qName.equals("member")) {
                        long id;
                        if (atts.getValue("ref") == null) {
                            this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}'' on <member> of relation {1}.", (Object[])new Object[]{"ref", this.currentPrimitive.getUniqueId()}));
                        }
                        if ((id = this.getLong(atts, "ref")) == 0L) {
                            this.throwException(I18n.tr((String)"Illegal value of attribute ''ref'' of element <nd>. Got {0}.", (Object[])new Object[]{id}));
                        }
                        OsmPrimitiveType type = OsmPrimitiveType.NODE;
                        String value = atts.getValue("type");
                        if (value == null) {
                            this.throwException(I18n.tr((String)"Missing attribute ''type'' on member {0} in relation {1}.", (Object[])new Object[]{Long.toString(id), Long.toString(this.currentPrimitive.getUniqueId())}));
                        }
                        try {
                            type = OsmPrimitiveType.fromApiTypeName((String)value);
                        }
                        catch (IllegalArgumentException e) {
                            this.throwException(I18n.tr((String)"Illegal value for attribute ''type'' on member {0} in relation {1}. Got {2}.", (Object[])new Object[]{Long.toString(id), Long.toString(this.currentPrimitive.getUniqueId()), value}));
                        }
                        String role = atts.getValue("role");
                        OsmPrimitive member = (OsmPrimitive)OsmToCmd.this.externalIdMap.get(new SimplePrimitiveId(id, type));
                        if (member == null && (member = OsmToCmd.this.targetDataSet.getPrimitiveById((PrimitiveId)new SimplePrimitiveId(id, type))) == null) {
                            this.throwException(I18n.tr((String)"Missing definition of new object with id {0}.", (Object[])new Object[]{id}));
                        }
                        RelationMember relationMember = new RelationMember(role, member);
                        this.currentRelationMembers.add(relationMember);
                        break block29;
                    }
                    if (qName.equals("tag")) {
                        String key = atts.getValue("k");
                        String value = atts.getValue("v");
                        if (key == null || value == null) {
                            this.throwException(I18n.tr((String)"Missing key or value attribute in tag.", (Object[])new Object[0]));
                        }
                        this.currentPrimitive.put(key.intern(), value.intern());
                    } else {
                        System.out.println(I18n.tr((String)"Undefined element ''{0}'' found in input stream. Skipping.", (Object[])new Object[]{qName}));
                    }
                }
                catch (Exception e) {
                    throw new SAXParseException(e.getMessage(), this.locator, e);
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("node")) {
                if (this.currentPrimitive.isDeleted()) {
                    OsmToCmd.this.cmds.add(new DeleteCommand(OsmToCmd.this.targetDataSet.getPrimitiveById(this.currentPrimitive.getPrimitiveId())));
                } else if (this.currentPrimitive.isModified()) {
                    OsmToCmd.this.cmds.add(new ChangeCommand(Main.main.getEditLayer(), OsmToCmd.this.targetDataSet.getPrimitiveById(this.currentPrimitive.getPrimitiveId()), this.currentPrimitive));
                } else if (this.currentPrimitive.isNew()) {
                    OsmToCmd.this.cmds.add(new AddCommand(this.currentPrimitive));
                }
            } else if (qName.equals("way")) {
                ((Way)this.currentPrimitive).setNodes(this.currentWayNodes);
                if (this.currentPrimitive.isDeleted()) {
                    OsmToCmd.this.cmds.add(new DeleteCommand(OsmToCmd.this.targetDataSet.getPrimitiveById(this.currentPrimitive.getPrimitiveId())));
                } else if (this.currentPrimitive.isModified()) {
                    OsmToCmd.this.cmds.add(new ChangeCommand(Main.main.getEditLayer(), OsmToCmd.this.targetDataSet.getPrimitiveById(this.currentPrimitive.getPrimitiveId()), this.currentPrimitive));
                } else if (this.currentPrimitive.isNew()) {
                    OsmToCmd.this.cmds.add(new AddCommand(this.currentPrimitive));
                }
            } else if (qName.equals("relation")) {
                ((Relation)this.currentPrimitive).setMembers(this.currentRelationMembers);
                if (this.currentPrimitive.isDeleted()) {
                    OsmToCmd.this.cmds.add(new DeleteCommand(OsmToCmd.this.targetDataSet.getPrimitiveById(this.currentPrimitive.getPrimitiveId())));
                } else if (this.currentPrimitive.isModified()) {
                    OsmToCmd.this.cmds.add(new ChangeCommand(Main.main.getEditLayer(), OsmToCmd.this.targetDataSet.getPrimitiveById(this.currentPrimitive.getPrimitiveId()), this.currentPrimitive));
                } else if (this.currentPrimitive.isNew()) {
                    OsmToCmd.this.cmds.add(new AddCommand(this.currentPrimitive));
                }
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) {
            OsmToCmd.this.parentPlugin.printHistory(String.valueOf(ch));
        }

        @Override
        public void startCDATA() {
        }

        @Override
        public void endCDATA() {
        }

        @Override
        public void startEntity(String name) {
        }

        @Override
        public void endEntity(String name) {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) {
        }

        @Override
        public void endDTD() {
        }

        private double getDouble(Attributes atts, String value) {
            return Double.parseDouble(atts.getValue(value));
        }

        private long getLong(Attributes atts, String name) throws SAXException {
            String value = atts.getValue(name);
            if (value == null) {
                this.throwException(I18n.tr((String)"Missing required attribute ''{0}''.", (Object[])new Object[]{name}));
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr((String)"Illegal long value for attribute ''{0}''. Got ''{1}''.", (Object[])new Object[]{name, value}));
                return 0L;
            }
        }

        private User createUser(String uid, String name) throws SAXException {
            if (uid == null) {
                if (name == null) {
                    return null;
                }
                return User.createLocalUser((String)name);
            }
            try {
                long id = Long.parseLong(uid);
                return User.createOsmUser((long)id, (String)name);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr((String)"Illegal value for attribute ''uid''. Got ''{0}''.", (Object[])new Object[]{uid}));
                return null;
            }
        }

        void readCommon(Attributes atts, PrimitiveData current) throws SAXException {
            String v;
            String time;
            current.setId(this.getLong(atts, "id"));
            if (current.getUniqueId() == 0L) {
                this.throwException(I18n.tr((String)"Illegal object with ID=0.", (Object[])new Object[0]));
            }
            if ((time = atts.getValue("timestamp")) != null && time.length() != 0) {
                current.setTimestamp(DateUtils.fromString((String)time));
            }
            String user = atts.getValue("user");
            String uid = atts.getValue("uid");
            current.setUser(this.createUser(uid, user));
            String visible = atts.getValue("visible");
            if (visible != null) {
                current.setVisible(Boolean.parseBoolean(visible));
            }
            String versionString = atts.getValue("version");
            int version = 0;
            if (versionString != null) {
                try {
                    version = Integer.parseInt(versionString);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr((String)"Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", (Object[])new Object[]{Long.toString(current.getUniqueId()), versionString}));
                }
            }
            current.setVersion(version);
            String action = atts.getValue("action");
            if (action != null) {
                if (action.equals("delete")) {
                    current.setDeleted(true);
                    current.setModified(current.isVisible());
                } else if (action.equals("modify")) {
                    current.setModified(true);
                }
            }
            if ((v = atts.getValue("changeset")) == null) {
                current.setChangesetId(0);
            } else {
                try {
                    current.setChangesetId(Integer.parseInt(v));
                }
                catch (NumberFormatException e) {
                    if (current.getUniqueId() <= 0L) {
                        System.out.println(I18n.tr((String)"Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", (Object[])new Object[]{v, current.getUniqueId()}));
                        current.setChangesetId(0);
                    }
                    this.throwException(I18n.tr((String)"Illegal value for attribute ''changeset''. Got {0}.", (Object[])new Object[]{v}));
                }
                if (current.getChangesetId() <= 0) {
                    if (current.getUniqueId() <= 0L) {
                        System.out.println(I18n.tr((String)"Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", (Object[])new Object[]{v, current.getUniqueId()}));
                        current.setChangesetId(0);
                    } else {
                        this.throwException(I18n.tr((String)"Illegal value for attribute ''changeset''. Got {0}.", (Object[])new Object[]{v}));
                    }
                }
            }
        }
    }
}

