/*
 * Decompiled with CFR 0.152.
 */
package org.j7zip.SevenZip.Archive.Common;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.j7zip.Common.LongVector;
import org.j7zip.Common.ObjectVector;
import org.j7zip.Common.RecordVector;
import org.j7zip.SevenZip.Archive.Common.BindInfo;
import org.j7zip.SevenZip.Archive.Common.BindPair;
import org.j7zip.SevenZip.Archive.Common.CoderInfo;
import org.j7zip.SevenZip.Archive.Common.CoderMixer2;
import org.j7zip.SevenZip.Archive.Common.CoderStreamsInfo;
import org.j7zip.SevenZip.Archive.Common.STCoderInfo;
import org.j7zip.SevenZip.ICompressCoder;
import org.j7zip.SevenZip.ICompressCoder2;
import org.j7zip.SevenZip.ICompressProgressInfo;
import org.j7zip.SevenZip.ICompressSetInStream;
import org.j7zip.SevenZip.ICompressSetOutStream;
import org.j7zip.SevenZip.ICompressSetOutStreamSize;

public class CoderMixer2ST
implements ICompressCoder2,
CoderMixer2 {
    BindInfo _bindInfo = new BindInfo();
    ObjectVector<STCoderInfo> _coders = new ObjectVector();

    @Override
    public void SetBindInfo(BindInfo bindInfo) {
        this._bindInfo = bindInfo;
    }

    public void AddCoderCommon(boolean isMain) {
        CoderStreamsInfo csi = (CoderStreamsInfo)this._bindInfo.Coders.get(this._coders.size());
        this._coders.add(new STCoderInfo(csi.NumInStreams, csi.NumOutStreams, isMain));
    }

    public void AddCoder2(ICompressCoder2 coder, boolean isMain) {
        this.AddCoderCommon(isMain);
        this._coders.Back().Coder2 = coder;
    }

    public void AddCoder(ICompressCoder coder, boolean isMain) {
        this.AddCoderCommon(isMain);
        this._coders.Back().Coder = coder;
    }

    @Override
    public void ReInit() {
    }

    @Override
    public void SetCoderInfo(int coderIndex, LongVector inSizes, LongVector outSizes) {
        ((STCoderInfo)this._coders.get(coderIndex)).SetCoderInfo(inSizes, outSizes);
    }

    public int GetInStream(RecordVector<InputStream> inStreams, Object useless_inSizes, int streamIndex, InputStream[] inStreamRes) {
        int i;
        for (i = 0; i < this._bindInfo.InStreams.size(); ++i) {
            InputStream seqInStream;
            if (this._bindInfo.InStreams.get(i) != streamIndex) continue;
            inStreamRes[0] = seqInStream = (InputStream)inStreams.get(i);
            return 0;
        }
        int binderIndex = this._bindInfo.FindBinderForInStream(streamIndex);
        if (binderIndex < 0) {
            return -2147024809;
        }
        int[] tmp1 = new int[1];
        int[] tmp2 = new int[1];
        this._bindInfo.FindOutStream(((BindPair)this._bindInfo.BindPairs.get((int)binderIndex)).OutIndex, tmp1, tmp2);
        int coderIndex = tmp1[0];
        CoderInfo coder = (CoderInfo)this._coders.get(coderIndex);
        if (coder.Coder == null) {
            return -2147467263;
        }
        InputStream seqInStream = (InputStream)((Object)coder.Coder);
        if (seqInStream == null) {
            return -2147467263;
        }
        int startIndex = this._bindInfo.GetCoderInStreamIndex(coderIndex);
        if (coder.Coder == null) {
            return -2147467263;
        }
        ICompressSetInStream setInStream = (ICompressSetInStream)((Object)coder.Coder);
        if (setInStream == null) {
            return -2147467263;
        }
        if (coder.NumInStreams > 1) {
            return -2147467263;
        }
        for (i = 0; i < coder.NumInStreams; ++i) {
            InputStream[] tmp = new InputStream[1];
            int res = this.GetInStream(inStreams, useless_inSizes, startIndex + i, tmp);
            if (res != 0) {
                return res;
            }
            InputStream seqInStream2 = tmp[0];
            res = setInStream.SetInStream(seqInStream2);
            if (res == 0) continue;
            return res;
        }
        inStreamRes[0] = seqInStream;
        return 0;
    }

    public int GetOutStream(RecordVector<OutputStream> outStreams, Object useless_outSizes, int streamIndex, OutputStream[] outStreamRes) {
        OutputStream seqOutStream;
        int i;
        for (i = 0; i < this._bindInfo.OutStreams.size(); ++i) {
            OutputStream seqOutStream2;
            if (this._bindInfo.OutStreams.get(i) != streamIndex) continue;
            outStreamRes[0] = seqOutStream2 = (OutputStream)outStreams.get(i);
            return 0;
        }
        int binderIndex = this._bindInfo.FindBinderForOutStream(streamIndex);
        if (binderIndex < 0) {
            return -2147024809;
        }
        int[] tmp1 = new int[1];
        int[] tmp2 = new int[1];
        this._bindInfo.FindInStream(((BindPair)this._bindInfo.BindPairs.get((int)binderIndex)).InIndex, tmp1, tmp2);
        int coderIndex = tmp1[0];
        CoderInfo coder = (CoderInfo)this._coders.get(coderIndex);
        if (coder.Coder == null) {
            return -2147467263;
        }
        try {
            seqOutStream = (OutputStream)((Object)coder.Coder);
        }
        catch (ClassCastException e) {
            return -2147467263;
        }
        int startIndex = this._bindInfo.GetCoderOutStreamIndex(coderIndex);
        if (coder.Coder == null) {
            return -2147467263;
        }
        ICompressSetOutStream setOutStream = null;
        try {
            setOutStream = (ICompressSetOutStream)((Object)coder.Coder);
        }
        catch (ClassCastException e) {
            return -2147467263;
        }
        if (coder.NumOutStreams > 1) {
            return -2147467263;
        }
        for (i = 0; i < coder.NumOutStreams; ++i) {
            OutputStream[] tmp = new OutputStream[1];
            int res = this.GetOutStream(outStreams, useless_outSizes, startIndex + i, tmp);
            if (res != 0) {
                return res;
            }
            OutputStream seqOutStream2 = tmp[0];
            res = setOutStream.SetOutStream(seqOutStream2);
            if (res == 0) continue;
            return res;
        }
        outStreamRes[0] = seqOutStream;
        return 0;
    }

    @Override
    public int Code(RecordVector<InputStream> inStreams, Object useless_inSizes, int numInStreams, RecordVector<OutputStream> outStreams, Object useless_outSizes, int numOutStreams, ICompressProgressInfo progress) throws IOException {
        int res;
        int res2;
        Closeable[] tmp;
        int i;
        if (numInStreams != this._bindInfo.InStreams.size() || numOutStreams != this._bindInfo.OutStreams.size()) {
            return -2147024809;
        }
        int _mainCoderIndex = -1;
        for (i = 0; i < this._coders.size(); ++i) {
            if (!((STCoderInfo)this._coders.get((int)i)).IsMain) continue;
            _mainCoderIndex = i;
            break;
        }
        if (_mainCoderIndex < 0) {
            for (i = 0; i < this._coders.size(); ++i) {
                if (((STCoderInfo)this._coders.get((int)i)).NumInStreams <= 1) continue;
                if (_mainCoderIndex >= 0) {
                    return -2147467263;
                }
                _mainCoderIndex = i;
            }
        }
        if (_mainCoderIndex < 0) {
            _mainCoderIndex = 0;
        }
        CoderInfo mainCoder = (CoderInfo)this._coders.get(_mainCoderIndex);
        ObjectVector<Closeable> seqInStreams = new ObjectVector<Closeable>();
        ObjectVector<Closeable> seqOutStreams = new ObjectVector<Closeable>();
        int startInIndex = this._bindInfo.GetCoderInStreamIndex(_mainCoderIndex);
        int startOutIndex = this._bindInfo.GetCoderOutStreamIndex(_mainCoderIndex);
        for (i = 0; i < mainCoder.NumInStreams; ++i) {
            tmp = new InputStream[1];
            res2 = this.GetInStream(inStreams, useless_inSizes, startInIndex + i, (InputStream[])tmp);
            if (res2 != 0) {
                return res2;
            }
            Closeable seqInStream = tmp[0];
            seqInStreams.add(seqInStream);
        }
        for (i = 0; i < mainCoder.NumOutStreams; ++i) {
            tmp = new OutputStream[1];
            res2 = this.GetOutStream(outStreams, useless_outSizes, startOutIndex + i, (OutputStream[])tmp);
            if (res2 != 0) {
                return res2;
            }
            Closeable seqOutStream = tmp[0];
            seqOutStreams.add(seqOutStream);
        }
        RecordVector<InputStream> seqInStreamsSpec = new RecordVector<InputStream>();
        RecordVector<OutputStream> seqOutStreamsSpec = new RecordVector<OutputStream>();
        for (i = 0; i < mainCoder.NumInStreams; ++i) {
            seqInStreamsSpec.add((InputStream)seqInStreams.get(i));
        }
        for (i = 0; i < mainCoder.NumOutStreams; ++i) {
            seqOutStreamsSpec.add((OutputStream)seqOutStreams.get(i));
        }
        for (i = 0; i < this._coders.size(); ++i) {
            if (i == _mainCoderIndex) continue;
            CoderInfo coder = (CoderInfo)this._coders.get(i);
            ICompressSetOutStreamSize setOutStreamSize = null;
            try {
                setOutStreamSize = (ICompressSetOutStreamSize)((Object)coder.Coder);
                int res3 = setOutStreamSize.SetOutStreamSize(coder.OutSizePointers.get(0));
                if (res3 == 0) continue;
                return res3;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if (mainCoder.Coder != null ? (res = mainCoder.Coder.Code((InputStream)seqInStreamsSpec.get(0), (OutputStream)seqOutStreamsSpec.get(0), mainCoder.OutSizePointers.get(0), progress)) != 0 : (res = mainCoder.Coder2.Code(seqInStreamsSpec, mainCoder.InSizePointers.Front(), mainCoder.NumInStreams, seqOutStreamsSpec, mainCoder.OutSizePointers.Front(), mainCoder.NumOutStreams, progress)) != 0) {
            return res;
        }
        OutputStream stream = (OutputStream)seqOutStreams.Front();
        stream.flush();
        return 0;
    }

    @Override
    public void close() {
    }
}

