/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public final class HSSFRow
implements Row {
    public static final int INITIAL_CAPACITY = 5;
    private int rowNum;
    private HSSFCell[] cells = new HSSFCell[5];
    private RowRecord row;
    private HSSFWorkbook book;
    private HSSFSheet sheet;

    HSSFRow(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n) {
        this(hSSFWorkbook, hSSFSheet, new RowRecord(n));
    }

    HSSFRow(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, RowRecord rowRecord) {
        this.book = hSSFWorkbook;
        this.sheet = hSSFSheet;
        this.row = rowRecord;
        this.setRowNum(rowRecord.getRowNumber());
        rowRecord.setEmpty();
    }

    @Override
    public HSSFCell createCell(int n) {
        return this.createCell(n, 3);
    }

    @Override
    public HSSFCell createCell(int n, int n2) {
        short s = (short)n;
        if (n > Short.MAX_VALUE) {
            s = (short)(65535 - n);
        }
        HSSFCell hSSFCell = new HSSFCell(this.book, this.sheet, this.getRowNum(), s, n2);
        this.addCell(hSSFCell);
        this.sheet.getSheet().addValueRecord(this.getRowNum(), hSSFCell.getCellValueRecord());
        return hSSFCell;
    }

    HSSFCell createCellFromRecord(CellValueRecordInterface cellValueRecordInterface) {
        HSSFCell hSSFCell = new HSSFCell(this.book, this.sheet, cellValueRecordInterface);
        this.addCell(hSSFCell);
        short s = cellValueRecordInterface.getColumn();
        if (this.row.isEmpty()) {
            this.row.setFirstCol(s);
            this.row.setLastCol(s + 1);
        } else if (s < this.row.getFirstCol()) {
            this.row.setFirstCol(s);
        } else if (s > this.row.getLastCol()) {
            this.row.setLastCol(s + 1);
        }
        return hSSFCell;
    }

    @Override
    public void setRowNum(int n) {
        int n2 = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid row number (" + n + ") outside allowable range (0.." + n2 + ")");
        }
        this.rowNum = n;
        if (this.row != null) {
            this.row.setRowNumber(n);
        }
    }

    @Override
    public int getRowNum() {
        return this.rowNum;
    }

    @Override
    public HSSFSheet getSheet() {
        return this.sheet;
    }

    private void addCell(HSSFCell hSSFCell) {
        int n = hSSFCell.getColumnIndex();
        if (n >= this.cells.length) {
            HSSFCell[] hSSFCellArray = this.cells;
            int n2 = hSSFCellArray.length * 2;
            if (n2 < n + 1) {
                n2 = n + 1;
            }
            this.cells = new HSSFCell[n2];
            System.arraycopy(hSSFCellArray, 0, this.cells, 0, hSSFCellArray.length);
        }
        this.cells[n] = hSSFCell;
        if (this.row.isEmpty() || n < this.row.getFirstCol()) {
            this.row.setFirstCol((short)n);
        }
        if (this.row.isEmpty() || n >= this.row.getLastCol()) {
            this.row.setLastCol((short)(n + 1));
        }
    }

    private HSSFCell retrieveCell(int n) {
        if (n < 0 || n >= this.cells.length) {
            return null;
        }
        return this.cells[n];
    }

    @Override
    public HSSFCell getCell(int n) {
        return this.getCell(n, this.book.getMissingCellPolicy());
    }

    @Override
    public HSSFCell getCell(int n, Row.MissingCellPolicy missingCellPolicy) {
        HSSFCell hSSFCell = this.retrieveCell(n);
        if (missingCellPolicy == RETURN_NULL_AND_BLANK) {
            return hSSFCell;
        }
        if (missingCellPolicy == RETURN_BLANK_AS_NULL) {
            if (hSSFCell == null) {
                return hSSFCell;
            }
            if (hSSFCell.getCellType() == 3) {
                return null;
            }
            return hSSFCell;
        }
        if (missingCellPolicy == CREATE_NULL_AS_BLANK) {
            if (hSSFCell == null) {
                return this.createCell(n, 3);
            }
            return hSSFCell;
        }
        throw new IllegalArgumentException("Illegal policy " + missingCellPolicy + " (" + missingCellPolicy.id + ")");
    }

    protected RowRecord getRowRecord() {
        return this.row;
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return new CellIterator();
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.cellIterator();
    }

    public boolean equals(Object object) {
        if (!(object instanceof HSSFRow)) {
            return false;
        }
        HSSFRow hSSFRow = (HSSFRow)object;
        return this.getRowNum() == hSSFRow.getRowNum();
    }

    private class CellIterator
    implements Iterator<Cell> {
        int thisId = -1;
        int nextId = -1;

        public CellIterator() {
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextId < HSSFRow.this.cells.length;
        }

        @Override
        public Cell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            HSSFCell hSSFCell = HSSFRow.this.cells[this.nextId];
            this.thisId = this.nextId;
            this.findNext();
            return hSSFCell;
        }

        @Override
        public void remove() {
            if (this.thisId == -1) {
                throw new IllegalStateException("remove() called before next()");
            }
            ((HSSFRow)HSSFRow.this).cells[this.thisId] = null;
        }

        private void findNext() {
            int n;
            for (n = this.nextId + 1; n < HSSFRow.this.cells.length && HSSFRow.this.cells[n] == null; ++n) {
            }
            this.nextId = n;
        }
    }
}

