/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets.be;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.plugins.opendata.core.datasets.SimpleDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.be.BelgianConstants;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.DefaultCsvHandler;

public abstract class BelgianDataSetHandler
extends SimpleDataSetHandler
implements BelgianConstants {
    private Projection singleProjection;
    private String nationalPortalPathDe;
    private String nationalPortalPathEn;
    private String nationalPortalPathFr;
    private String nationalPortalPathNl;
    protected static final Projection lambert1972 = PRJ_LAMBERT_1972.getProjection();
    protected static final Projection lambert2008 = PRJ_LAMBERT_2008.getProjection();
    protected static final Projection[] projections = new Projection[]{lambert1972, lambert2008};

    public BelgianDataSetHandler() {
        this.init();
    }

    public BelgianDataSetHandler(String relevantTag) {
        super(relevantTag);
        this.init();
    }

    public BelgianDataSetHandler(boolean relevantUnion, String[] relevantTags) {
        super(relevantUnion, relevantTags);
        this.init();
    }

    public BelgianDataSetHandler(boolean relevantUnion, Tag[] relevantTags) {
        super(relevantUnion, relevantTags);
        this.init();
    }

    private void init() {
        this.setCsvHandler(new InternalCsvHandler());
    }

    protected final void setNationalPortalPath(String nationalPortalPathDe, String nationalPortalPathEn, String nationalPortalPathFr, String nationalPortalPathNl) {
        this.nationalPortalPathDe = nationalPortalPathDe;
        this.nationalPortalPathEn = nationalPortalPathEn;
        this.nationalPortalPathFr = nationalPortalPathFr;
        this.nationalPortalPathNl = nationalPortalPathNl;
    }

    protected final void setSingleProjection(Projection singleProjection) {
        this.singleProjection = singleProjection;
        this.getCsvHandler().setHandlesProjection(singleProjection != null);
    }

    @Override
    public URL getNationalPortalURL() {
        try {
            String nationalPortalPath = "";
            String lang = Main.pref.get("language");
            if (lang == null || lang.isEmpty()) {
                lang = Locale.getDefault().toString();
            }
            nationalPortalPath = lang.startsWith("de") && this.nationalPortalPathDe != null ? this.nationalPortalPathDe : (lang.startsWith("fr") && this.nationalPortalPathFr != null ? this.nationalPortalPathFr : (lang.startsWith("nl") && this.nationalPortalPathNl != null ? this.nationalPortalPathNl : this.nationalPortalPathEn));
            return new URL("http://data.gov.be/{lang}/dataset/".replace("{lang}", lang.substring(0, 2)) + nationalPortalPath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getLocalPortalIconName() {
        return "be24.png";
    }

    @Override
    public String getNationalPortalIconName() {
        return "be24.png";
    }

    protected class InternalCsvHandler
    extends DefaultCsvHandler {
        protected InternalCsvHandler() {
        }

        @Override
        public LatLon getCoor(EastNorth en, String[] fields) {
            if (BelgianDataSetHandler.this.singleProjection != null) {
                return BelgianDataSetHandler.this.singleProjection.eastNorth2latlon(en);
            }
            return super.getCoor(en, fields);
        }
    }
}

