/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.LittleEndianInputStream;

public final class ObjRecord
extends Record {
    public static final short sid = 93;
    private static final int NORMAL_PAD_ALIGNMENT = 2;
    private static int MAX_PAD_ALIGNMENT = 4;
    private List<SubRecord> subrecords;
    private final byte[] _uninterpretedData;
    private boolean _isPaddedToQuadByteMultiple;

    public ObjRecord() {
        this.subrecords = new ArrayList<SubRecord>(2);
        this._uninterpretedData = null;
    }

    public ObjRecord(RecordInputStream recordInputStream) {
        SubRecord subRecord;
        byte[] byArray = recordInputStream.readRemainder();
        if (LittleEndian.getUShort(byArray, 0) != 21) {
            this._uninterpretedData = byArray;
            this.subrecords = null;
            return;
        }
        this.subrecords = new ArrayList<SubRecord>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(byteArrayInputStream);
        CommonObjectDataSubRecord commonObjectDataSubRecord = (CommonObjectDataSubRecord)SubRecord.createSubRecord(littleEndianInputStream, 0);
        this.subrecords.add(commonObjectDataSubRecord);
        do {
            subRecord = SubRecord.createSubRecord(littleEndianInputStream, commonObjectDataSubRecord.getObjectType());
            this.subrecords.add(subRecord);
        } while (!subRecord.isTerminating());
        int n = byteArrayInputStream.available();
        if (n > 0) {
            this._isPaddedToQuadByteMultiple = byArray.length % MAX_PAD_ALIGNMENT == 0;
            if (n >= (this._isPaddedToQuadByteMultiple ? MAX_PAD_ALIGNMENT : 2)) {
                if (!ObjRecord.canPaddingBeDiscarded(byArray, n)) {
                    String string = "Leftover " + n + " bytes in subrecord data " + HexDump.toHex(byArray);
                    throw new RecordFormatException(string);
                }
                this._isPaddedToQuadByteMultiple = false;
            }
        } else {
            this._isPaddedToQuadByteMultiple = false;
        }
        this._uninterpretedData = null;
    }

    private static boolean canPaddingBeDiscarded(byte[] byArray, int n) {
        for (int i = byArray.length - n; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[OBJ]\n");
        for (int i = 0; i < this.subrecords.size(); ++i) {
            SubRecord subRecord = this.subrecords.get(i);
            stringBuffer.append("SUBRECORD: ").append(subRecord.toString());
        }
        stringBuffer.append("[/OBJ]\n");
        return stringBuffer.toString();
    }

    @Override
    public int getRecordSize() {
        if (this._uninterpretedData != null) {
            return this._uninterpretedData.length + 4;
        }
        int n = 0;
        for (int i = this.subrecords.size() - 1; i >= 0; --i) {
            SubRecord subRecord = this.subrecords.get(i);
            n += subRecord.getDataSize() + 4;
        }
        if (this._isPaddedToQuadByteMultiple) {
            while (n % MAX_PAD_ALIGNMENT != 0) {
                ++n;
            }
        } else {
            while (n % 2 != 0) {
                ++n;
            }
        }
        return n + 4;
    }

    @Override
    public int serialize(int n, byte[] byArray) {
        int n2 = this.getRecordSize();
        int n3 = n2 - 4;
        LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream = new LittleEndianByteArrayOutputStream(byArray, n, n2);
        littleEndianByteArrayOutputStream.writeShort(93);
        littleEndianByteArrayOutputStream.writeShort(n3);
        if (this._uninterpretedData == null) {
            int n4;
            for (n4 = 0; n4 < this.subrecords.size(); ++n4) {
                SubRecord subRecord = this.subrecords.get(n4);
                subRecord.serialize(littleEndianByteArrayOutputStream);
            }
            n4 = n + n3;
            while (littleEndianByteArrayOutputStream.getWriteIndex() < n4) {
                littleEndianByteArrayOutputStream.writeByte(0);
            }
        } else {
            littleEndianByteArrayOutputStream.write(this._uninterpretedData);
        }
        return n2;
    }

    @Override
    public short getSid() {
        return 93;
    }

    public boolean addSubRecord(SubRecord subRecord) {
        return this.subrecords.add(subRecord);
    }

    @Override
    public Object clone() {
        ObjRecord objRecord = new ObjRecord();
        for (int i = 0; i < this.subrecords.size(); ++i) {
            SubRecord subRecord = this.subrecords.get(i);
            objRecord.addSubRecord((SubRecord)subRecord.clone());
        }
        return objRecord;
    }
}

