/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URI;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.util.Configuration;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class MapdustHelpPanel
extends JPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 8366853437915060878L;

    public MapdustHelpPanel() {
        this.setLayout(new BorderLayout());
        String name = "Help";
        this.setName(name);
        String txt = this.buildText();
        JEditorPane txtHelp = new JEditorPane("text/html", "");
        txtHelp.setEditorKit(new HTMLEditorKit());
        txtHelp.setEditable(false);
        txtHelp.setText(txt);
        txtHelp.addHyperlinkListener(this);
        JScrollPane cmpDescription = ComponentUtil.createJScrollPane(txtHelp, null, Color.white, true, true);
        cmpDescription.setPreferredSize(new Dimension(100, 100));
        this.add((Component)cmpDescription, "Center");
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String url = Configuration.getInstance().getMapdustWiki();
            try {
                OpenBrowser.displayUrl((URI)new URI(url));
            }
            catch (Exception e) {
                String errorMessage = "Error opening the MapDust wiki page";
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage, (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
        }
    }

    private String buildText() {
        String version = Main.pref.get("mapdust.version");
        String localVersion = Main.pref.get("mapdust.localVersion");
        StringBuilder sb = new StringBuilder("<html>");
        sb.append("<font style='font-size:10px' face='Times New Roman'>");
        sb.append("<b>You are using MapDust version ");
        sb.append("<i style='color:red;font-size:10px'>");
        if (version.equals(localVersion)) {
            sb.append(version).append("</i>.</b><br>");
        } else {
            sb.append(localVersion);
            sb.append("</i>. There is an update available. ");
            sb.append("Please update to version ");
            sb.append("<i style='color:red;font-size:10px'>");
            sb.append(version);
            sb.append("</i> to benefit from the latest improvements.</b><br>");
        }
        sb.append("<b>To add bugs on the map you need to activate ");
        sb.append("the MapDust layer in the Layer List Dialog.");
        sb.append("Click <a href='' target='_blank'>here</a> for more help.");
        sb.append("</b></font></html>");
        return sb.toString();
    }
}

