/*
 * Decompiled with CFR 0.152.
 */
package mirrored_download;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import mirrored_download.MirroredDownloadPlugin;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;

public class UrlSelectionDialog {
    private JDialog jDialog = null;
    private JTabbedPane tabbedPane = null;
    private JComboBox cbSelectUrl = null;
    private JCheckBox cbAddMeta = null;
    private static UrlSelectionDialog singleton = null;

    public UrlSelectionDialog() {
        Frame frame = JOptionPane.getFrameForComponent(Main.parent);
        this.jDialog = new JDialog(frame, I18n.tr((String)"Select OSM mirror URL", (Object[])new Object[0]), false);
        this.tabbedPane = new JTabbedPane();
        JPanel tabSettings = new JPanel();
        this.tabbedPane.addTab(I18n.tr((String)"Settings", (Object[])new Object[0]), tabSettings);
        this.tabbedPane.setEnabledAt(0, true);
        this.jDialog.add(this.tabbedPane);
        JPanel contentPane = tabSettings;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints layoutCons = new GridBagConstraints();
        contentPane.setLayout(gridbag);
        JLabel label = new JLabel(I18n.tr((String)"Base URL", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 0;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        this.cbSelectUrl = new JComboBox();
        this.cbSelectUrl.setEditable(true);
        this.cbSelectUrl.addItem(MirroredDownloadPlugin.getDownloadUrl());
        for (String url : this.getURLs()) {
            this.cbSelectUrl.addItem(url);
        }
        this.cbSelectUrl.setActionCommand("selectURL");
        this.cbSelectUrl.addActionListener(new UrlChangedAction());
        layoutCons.gridx = 0;
        layoutCons.gridy = 1;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.cbSelectUrl, layoutCons);
        contentPane.add(this.cbSelectUrl);
        this.cbAddMeta = new JCheckBox(I18n.tr((String)"Enforce meta data", (Object[])new Object[0]));
        this.cbAddMeta.setEnabled(true);
        this.cbAddMeta.setSelected(MirroredDownloadPlugin.getAddMeta());
        this.cbAddMeta.setActionCommand("selectMetaFlag");
        this.cbAddMeta.addActionListener(new MetaFlagChangedAction());
        layoutCons.gridx = 0;
        layoutCons.gridy = 2;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.cbAddMeta, layoutCons);
        contentPane.add(this.cbAddMeta);
        this.jDialog.pack();
        this.jDialog.setLocationRelativeTo(frame);
    }

    private Collection<String> getURLs() {
        String src = Main.pref.get("plugin.mirrored_download.url-src", "https://josm.openstreetmap.de/mirrored_download_info");
        ArrayList<String> urls = new ArrayList<String>();
        try (InputStream in = new CachedFile(src).setMaxAge(86400L).getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                urls.add(line);
            }
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
        for (String url : Main.pref.getCollection("plugin.mirrored_download.custom-urls")) {
            urls.add(url);
        }
        return urls;
    }

    public void setVisible(boolean visible) {
        this.jDialog.setVisible(visible);
    }

    public static UrlSelectionDialog getInstance() {
        if (singleton == null) {
            singleton = new UrlSelectionDialog();
        }
        return singleton;
    }

    public class MetaFlagChangedAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            MirroredDownloadPlugin.setAddMeta(UrlSelectionDialog.this.cbAddMeta.isSelected());
            Main.pref.put("plugin.mirrored_download.preferred-meta-flag", UrlSelectionDialog.this.cbAddMeta.isSelected() ? "meta" : "void");
        }
    }

    public class UrlChangedAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            MirroredDownloadPlugin.setDownloadUrl(UrlSelectionDialog.this.cbSelectUrl.getSelectedItem().toString());
            Main.pref.put("plugin.mirrored_download.preferred-url", UrlSelectionDialog.this.cbSelectUrl.getSelectedItem().toString());
        }
    }
}

