/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import messages.Messages;
import seamarks.SeaMark;
import smed.SmedAction;

public class PanelRadar
extends JPanel {
    private SmedAction dlg;
    private JToggleButton aisButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/images/AISButton.png")));
    private ActionListener alAis = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PanelRadar.this.aisButton.isSelected()) {
                PanelRadar.this.radioCatBox.setVisible(true);
                PanelRadar.this.aisButton.setBorderPainted(true);
            } else {
                PanelRadar.this.radioCatBox.setSelectedIndex(0);
                PanelRadar.this.radioCatBox.setVisible(false);
                PanelRadar.this.aisButton.setBorderPainted(false);
            }
        }
    };
    private JComboBox radioCatBox;
    private EnumMap<SeaMark.Cat, Integer> radioCats = new EnumMap(SeaMark.Cat.class);
    private ActionListener alRadioCatBox = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Cat cat : PanelRadar.this.radioCats.keySet()) {
                int idx = (Integer)PanelRadar.this.radioCats.get((Object)cat);
                if (((PanelRadar)PanelRadar.this).dlg.node == null || idx != PanelRadar.this.radioCatBox.getSelectedIndex()) continue;
                PanelRadar.this.dlg;
                SmedAction.panelMain.mark.setRadio(cat);
            }
        }
    };
    private ButtonGroup radarButtons = new ButtonGroup();
    public JRadioButton noRadButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/OffButton.png")));
    public JRadioButton reflButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/RadarReflectorButton.png")));
    public JRadioButton ramarkButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/RamarkButton.png")));
    public JRadioButton raconButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/RaconButton.png")));
    public JRadioButton leadingButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/LeadingRaconButton.png")));
    private EnumMap<SeaMark.Rtb, JRadioButton> rads = new EnumMap(SeaMark.Rtb.class);
    private ActionListener alRad = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Rtb rtb : PanelRadar.this.rads.keySet()) {
                JRadioButton button = (JRadioButton)PanelRadar.this.rads.get((Object)rtb);
                if (!button.isSelected()) continue;
                PanelRadar.this.dlg;
                SmedAction.panelMain.mark.setRadar(rtb);
            }
            PanelRadar.this.syncPanel();
        }
    };
    public JLabel groupLabel;
    public JTextField groupBox;
    private FocusListener flGroup = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PanelRadar.this.dlg;
            SmedAction.panelMain.mark.setRaconGroup(PanelRadar.this.groupBox.getText());
        }
    };
    public JLabel periodLabel;
    public JTextField periodBox;
    private FocusListener flPeriod = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PanelRadar.this.dlg;
            SmedAction.panelMain.mark.setRaconPeriod(PanelRadar.this.periodBox.getText());
        }
    };
    public JLabel seqLabel;
    public JTextField seqBox;
    private FocusListener flSeq = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PanelRadar.this.dlg;
            SmedAction.panelMain.mark.setRaconSequence(PanelRadar.this.seqBox.getText());
        }
    };
    public JLabel rangeLabel;
    public JTextField rangeBox;
    private FocusListener flRange = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PanelRadar.this.dlg;
            SmedAction.panelMain.mark.setRaconRange(PanelRadar.this.rangeBox.getText());
        }
    };
    public JLabel sector1Label;
    public JTextField sector1Box;
    private FocusListener flSector1 = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PanelRadar.this.dlg;
            SmedAction.panelMain.mark.setRaconSector1(PanelRadar.this.sector1Box.getText());
        }
    };
    public JLabel sector2Label;
    public JTextField sector2Box;
    private FocusListener flSector2 = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PanelRadar.this.dlg;
            SmedAction.panelMain.mark.setRaconSector2(PanelRadar.this.sector2Box.getText());
        }
    };
    public JLabel sectorsLabel;

    public PanelRadar(SmedAction dia) {
        this.dlg = dia;
        this.setLayout(null);
        this.add(this.getRadButton(this.noRadButton, 0, 3, 27, 27, "NoRadar", SeaMark.Rtb.NORTB));
        this.add(this.getRadButton(this.reflButton, 0, 33, 27, 27, "RadarReflector", SeaMark.Rtb.REFLECTOR));
        this.add(this.getRadButton(this.ramarkButton, 0, 63, 27, 27, "Ramark", SeaMark.Rtb.RAMARK));
        this.add(this.getRadButton(this.raconButton, 0, 93, 27, 27, "Racon", SeaMark.Rtb.RACON));
        this.add(this.getRadButton(this.leadingButton, 0, 123, 27, 27, "LeadingRacon", SeaMark.Rtb.LEADING));
        this.groupLabel = new JLabel(Messages.getString("Group"), 0);
        this.groupLabel.setBounds(new Rectangle(30, 0, 100, 20));
        this.add(this.groupLabel);
        this.groupBox = new JTextField();
        this.groupBox.setBounds(new Rectangle(55, 20, 50, 20));
        this.groupBox.setHorizontalAlignment(0);
        this.add(this.groupBox);
        this.groupBox.addFocusListener(this.flGroup);
        this.periodLabel = new JLabel(Messages.getString("Period"), 0);
        this.periodLabel.setBounds(new Rectangle(130, 0, 100, 20));
        this.add(this.periodLabel);
        this.periodBox = new JTextField();
        this.periodBox.setBounds(new Rectangle(155, 20, 50, 20));
        this.periodBox.setHorizontalAlignment(0);
        this.add(this.periodBox);
        this.periodBox.addFocusListener(this.flPeriod);
        this.seqLabel = new JLabel(Messages.getString("Sequence"), 0);
        this.seqLabel.setBounds(new Rectangle(30, 40, 100, 20));
        this.add(this.seqLabel);
        this.seqBox = new JTextField();
        this.seqBox.setBounds(new Rectangle(55, 60, 50, 20));
        this.seqBox.setHorizontalAlignment(0);
        this.add(this.seqBox);
        this.seqBox.addFocusListener(this.flSeq);
        this.rangeLabel = new JLabel(Messages.getString("Range"), 0);
        this.rangeLabel.setBounds(new Rectangle(130, 40, 100, 20));
        this.add(this.rangeLabel);
        this.rangeBox = new JTextField();
        this.rangeBox.setBounds(new Rectangle(155, 60, 50, 20));
        this.rangeBox.setHorizontalAlignment(0);
        this.add(this.rangeBox);
        this.rangeBox.addFocusListener(this.flRange);
        this.sectorsLabel = new JLabel(Messages.getString("VisibleSector"), 0);
        this.sectorsLabel.setBounds(new Rectangle(75, 85, 100, 20));
        this.add(this.sectorsLabel);
        this.sector1Label = new JLabel(Messages.getString("Start"), 0);
        this.sector1Label.setBounds(new Rectangle(30, 100, 100, 20));
        this.add(this.sector1Label);
        this.sector1Box = new JTextField();
        this.sector1Box.setBounds(new Rectangle(55, 120, 50, 20));
        this.sector1Box.setHorizontalAlignment(0);
        this.add(this.sector1Box);
        this.sector1Box.addFocusListener(this.flSector1);
        this.sector2Label = new JLabel(Messages.getString("End"), 0);
        this.sector2Label.setBounds(new Rectangle(130, 100, 100, 20));
        this.add(this.sector2Label);
        this.sector2Box = new JTextField();
        this.sector2Box.setBounds(new Rectangle(155, 120, 50, 20));
        this.sector2Box.setHorizontalAlignment(0);
        this.add(this.sector2Box);
        this.sector2Box.addFocusListener(this.flSector2);
        this.aisButton.setBounds(new Rectangle(270, 3, 27, 27));
        this.aisButton.setBorder(BorderFactory.createLoweredBevelBorder());
        this.aisButton.setToolTipText("AIS");
        this.aisButton.addActionListener(this.alAis);
        this.add(this.aisButton);
        this.radioCatBox = new JComboBox();
        this.radioCatBox.setBounds(new Rectangle(210, 40, 150, 20));
        this.add(this.radioCatBox);
        this.radioCatBox.addActionListener(this.alRadioCatBox);
        this.addROItem("", SeaMark.Cat.NOROS);
        this.addROItem(Messages.getString("CircularBeacon"), SeaMark.Cat.ROS_OMNI);
        this.addROItem(Messages.getString("DirectionalBeacon"), SeaMark.Cat.ROS_DIRL);
        this.addROItem(Messages.getString("RotatingBeacon"), SeaMark.Cat.ROS_ROTP);
        this.addROItem(Messages.getString("ConsolBeacon"), SeaMark.Cat.ROS_CNSL);
        this.addROItem(Messages.getString("DirectionFinding"), SeaMark.Cat.ROS_RDF);
        this.addROItem(Messages.getString("QTGService"), SeaMark.Cat.ROS_QTG);
        this.addROItem(Messages.getString("AeronaticalBeacon"), SeaMark.Cat.ROS_AERO);
        this.addROItem(Messages.getString("Decca"), SeaMark.Cat.ROS_DECA);
        this.addROItem(Messages.getString("LoranC"), SeaMark.Cat.ROS_LORN);
        this.addROItem(Messages.getString("DGPS"), SeaMark.Cat.ROS_DGPS);
        this.addROItem(Messages.getString("Toran"), SeaMark.Cat.ROS_TORN);
        this.addROItem(Messages.getString("Omega"), SeaMark.Cat.ROS_OMGA);
        this.addROItem(Messages.getString("Syledis"), SeaMark.Cat.ROS_SYLD);
        this.addROItem(Messages.getString("Chiaka"), SeaMark.Cat.ROS_CHKA);
        this.addROItem(Messages.getString("PublicCommunication"), SeaMark.Cat.ROS_PCOM);
        this.addROItem(Messages.getString("CommercialBroadcast"), SeaMark.Cat.ROS_COMB);
        this.addROItem(Messages.getString("Facsimile"), SeaMark.Cat.ROS_FACS);
        this.addROItem(Messages.getString("TimeSignal"), SeaMark.Cat.ROS_TIME);
        this.addROItem(Messages.getString("AIS"), SeaMark.Cat.ROS_PAIS);
        this.addROItem(Messages.getString("S-AIS"), SeaMark.Cat.ROS_SAIS);
        this.radioCatBox.setVisible(false);
    }

    /*
     * Unable to fully structure code
     */
    public void syncPanel() {
        if (SmedAction.panelMain.mark.getRadar() == SeaMark.Rtb.NORTB) ** GOTO lbl-1000
        if (SmedAction.panelMain.mark.getRadar() != SeaMark.Rtb.REFLECTOR) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        rad = v0;
        this.groupLabel.setVisible(rad);
        this.groupBox.setVisible(rad);
        this.periodLabel.setVisible(rad);
        this.periodBox.setVisible(rad);
        this.seqLabel.setVisible(rad);
        this.seqBox.setVisible(rad);
        this.rangeLabel.setVisible(rad);
        this.rangeBox.setVisible(rad);
        this.sector1Label.setVisible(rad);
        this.sector1Box.setVisible(rad);
        this.sector2Label.setVisible(rad);
        this.sector2Box.setVisible(rad);
        this.sectorsLabel.setVisible(rad);
        for (SeaMark.Rtb rtb : this.rads.keySet()) {
            this.rads.get((Object)rtb).setBorderPainted(SmedAction.panelMain.mark.getRadar() == rtb);
        }
        this.groupBox.setText(SmedAction.panelMain.mark.getRaconGroup());
        this.seqBox.setText(SmedAction.panelMain.mark.getRaconSequence());
        this.periodBox.setText(SmedAction.panelMain.mark.getRaconPeriod());
        this.rangeBox.setText(SmedAction.panelMain.mark.getRaconRange());
        this.sector1Box.setText(SmedAction.panelMain.mark.getRaconSector1());
        this.sector2Box.setText(SmedAction.panelMain.mark.getRaconSector2());
        this.aisButton.setSelected(SmedAction.panelMain.mark.getRadio() != SeaMark.Cat.NOROS);
        this.aisButton.setBorderPainted(this.aisButton.isSelected());
        this.radioCatBox.setVisible(SmedAction.panelMain.mark.getRadio() != SeaMark.Cat.NOROS);
    }

    private JRadioButton getRadButton(JRadioButton button, int x, int y, int w, int h, String tip, SeaMark.Rtb rtb) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setToolTipText(Messages.getString(tip));
        button.addActionListener(this.alRad);
        this.radarButtons.add(button);
        this.rads.put(rtb, button);
        return button;
    }

    private void addROItem(String str, SeaMark.Cat cat) {
        this.radioCats.put(cat, this.radioCatBox.getItemCount());
        this.radioCatBox.addItem(str);
    }
}

