/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import messages.Messages;
import seamarks.SeaMark;
import smed.SmedAction;

public class PanelPort
extends JPanel {
    private SmedAction dlg;
    public ButtonGroup shapeButtons = new ButtonGroup();
    public JRadioButton pillarButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/PillarButton.png")));
    public JRadioButton sparButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SparButton.png")));
    public JRadioButton canButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/CanButton.png")));
    public JRadioButton sphereButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/SphereButton.png")));
    public JRadioButton floatButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/FloatButton.png")));
    public JRadioButton beaconButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/BeaconButton.png")));
    public JRadioButton towerButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/TowerButton.png")));
    public JRadioButton perchButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/PerchPButton.png")));
    public JRadioButton stakeButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/StakeButton.png")));
    public EnumMap<SeaMark.Shp, JRadioButton> shapes = new EnumMap(SeaMark.Shp.class);
    public EnumMap<SeaMark.Shp, SeaMark.Obj> objects = new EnumMap(SeaMark.Shp.class);
    public ActionListener alShape = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Shp shp : PanelPort.this.shapes.keySet()) {
                JRadioButton button = PanelPort.this.shapes.get((Object)shp);
                if (button.isSelected()) {
                    PanelPort.this.dlg;
                    SmedAction.panelMain.mark.setShape(shp);
                    PanelPort.this.dlg;
                    SmedAction.panelMain.mark.setObject(PanelPort.this.objects.get((Object)shp));
                    button.setBorderPainted(true);
                    continue;
                }
                button.setBorderPainted(false);
            }
            PanelPort.this.dlg;
            if (SmedAction.panelMain.mark.testValid()) {
                PanelPort.this.dlg;
                SmedAction.panelMain.panelChan.topmarkButton.setVisible(true);
                PanelPort.this.dlg;
                SmedAction.panelMain.panelChan.lightButton.setVisible(true);
                PanelPort.this.dlg;
                if (SmedAction.panelMain.mark.getCategory() == SeaMark.Cat.LAM_PORT) {
                    PanelPort.this.dlg;
                    switch (SmedAction.panelMain.mark.getRegion()) {
                        case A: {
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.NOPAT);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                            break;
                        }
                        case B: {
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.NOPAT);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.GREEN);
                            break;
                        }
                        case C: {
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.HSTRP);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.WHITE);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.WHITE);
                        }
                    }
                } else {
                    PanelPort.this.dlg;
                    SmedAction.panelMain.mark.setObjPattern(SeaMark.Pat.HSTRP);
                    PanelPort.this.dlg;
                    switch (SmedAction.panelMain.mark.getRegion()) {
                        case A: {
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                            break;
                        }
                        case B: {
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.GREEN);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                            break;
                        }
                        case C: {
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.setObjColour(SeaMark.Col.RED);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.RED);
                            PanelPort.this.dlg;
                            SmedAction.panelMain.mark.addObjColour(SeaMark.Col.GREEN);
                        }
                    }
                }
                PanelPort.this.dlg;
                SmedAction.panelMain.panelMore.syncPanel();
            } else {
                PanelPort.this.dlg;
                SmedAction.panelMain.panelChan.topmarkButton.setVisible(false);
                PanelPort.this.dlg;
                SmedAction.panelMain.panelChan.lightButton.setVisible(false);
            }
        }
    };

    public PanelPort(SmedAction dia) {
        this.dlg = dia;
        this.setLayout(null);
        this.add(this.getShapeButton(this.pillarButton, 0, 0, 34, 32, "Pillar", SeaMark.Shp.PILLAR, SeaMark.Obj.BOYLAT));
        this.add(this.getShapeButton(this.sparButton, 0, 32, 34, 32, "Spar", SeaMark.Shp.SPAR, SeaMark.Obj.BOYLAT));
        this.add(this.getShapeButton(this.canButton, 0, 64, 34, 32, "Can", SeaMark.Shp.CAN, SeaMark.Obj.BOYLAT));
        this.add(this.getShapeButton(this.sphereButton, 0, 96, 34, 32, "Sphere", SeaMark.Shp.SPHERI, SeaMark.Obj.BOYLAT));
        this.add(this.getShapeButton(this.floatButton, 0, 128, 34, 32, "Float", SeaMark.Shp.FLOAT, SeaMark.Obj.FLTLAT));
        this.add(this.getShapeButton(this.beaconButton, 35, 0, 34, 32, "Beacon", SeaMark.Shp.BEACON, SeaMark.Obj.BCNLAT));
        this.add(this.getShapeButton(this.towerButton, 35, 32, 34, 32, "TowerB", SeaMark.Shp.TOWER, SeaMark.Obj.BCNLAT));
        this.add(this.getShapeButton(this.perchButton, 35, 64, 34, 32, "Perch", SeaMark.Shp.PERCH, SeaMark.Obj.BCNLAT));
        this.add(this.getShapeButton(this.stakeButton, 35, 96, 34, 32, "Stake", SeaMark.Shp.STAKE, SeaMark.Obj.BCNLAT));
    }

    public void syncPanel() {
        for (SeaMark.Shp shp : this.shapes.keySet()) {
            JRadioButton button = this.shapes.get((Object)shp);
            if (SmedAction.panelMain.mark.getShape() == shp) {
                button.setBorderPainted(true);
                continue;
            }
            button.setBorderPainted(false);
        }
    }

    private JRadioButton getShapeButton(JRadioButton button, int x, int y, int w, int h, String tip, SeaMark.Shp shp, SeaMark.Obj obj) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setToolTipText(Messages.getString(tip));
        button.addActionListener(this.alShape);
        this.shapeButtons.add(button);
        this.shapes.put(shp, button);
        this.objects.put(shp, obj);
        return button;
    }
}

