/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.plugins.pointinfo.PointInfoUtils;
import org.openstreetmap.josm.plugins.pointinfo.addrPlaces;
import org.openstreetmap.josm.plugins.pointinfo.objectWithoutGeometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

class ruianRecord {
    private double m_coor_lat;
    private double m_coor_lon;
    private String m_source;
    private long m_objekt_ruian_id;
    private int m_objekt_podlazi;
    private int m_objekt_byty;
    private String m_objekt_zpusob_vyuziti;
    private String m_objekt_zpusob_vyuziti_kod;
    private String m_objekt_zpusob_vyuziti_key;
    private String m_objekt_zpusob_vyuziti_val;
    private String m_objekt_dokonceni;
    private String m_objekt_plati_od;
    private ArrayList<objectWithoutGeometry> m_so_bez_geometrie;
    private ArrayList<addrPlaces> m_adresni_mista;
    private long m_parcela_ruian_id;
    private String m_parcela_druh_pozemku;
    private String m_parcela_zpusob_vyuziti;
    private String m_parcela_plati_od;
    private long m_ulice_ruian_id;
    private String m_ulice_jmeno;
    private long m_katastr_ruian_id;
    private String m_katastr_nazev;
    private long m_katastr_obec_kod;
    private String m_katastr_obec;
    private long m_katastr_okres_kod;
    private String m_katastr_okres;
    private long m_katastr_kraj_kod;
    private String m_katastr_kraj;

    public ruianRecord() {
        this.init();
    }

    private void init() {
        this.m_coor_lat = 0.0;
        this.m_coor_lon = 0.0;
        this.m_source = "";
        this.m_objekt_ruian_id = 0L;
        this.m_objekt_podlazi = 0;
        this.m_objekt_byty = 0;
        this.m_objekt_zpusob_vyuziti = "";
        this.m_objekt_zpusob_vyuziti_kod = "";
        this.m_objekt_zpusob_vyuziti_key = "";
        this.m_objekt_zpusob_vyuziti_val = "";
        this.m_objekt_dokonceni = "";
        this.m_objekt_plati_od = "";
        this.m_so_bez_geometrie = new ArrayList();
        this.m_adresni_mista = new ArrayList();
        this.m_parcela_ruian_id = 0L;
        this.m_parcela_druh_pozemku = "";
        this.m_parcela_zpusob_vyuziti = "";
        this.m_parcela_plati_od = "";
        this.m_ulice_ruian_id = 0L;
        this.m_ulice_jmeno = "";
        this.m_katastr_ruian_id = 0L;
        this.m_katastr_nazev = "";
        this.m_katastr_obec_kod = 0L;
        this.m_katastr_obec = "";
        this.m_katastr_okres_kod = 0L;
        this.m_katastr_okres = "";
        this.m_katastr_kraj_kod = 0L;
        this.m_katastr_kraj = "";
    }

    public void parseJSON(String jsonStr) {
        JsonArray arr;
        this.init();
        JsonReader jsonReader = Json.createReader((InputStream)new ByteArrayInputStream(jsonStr.getBytes()));
        JsonObject obj = jsonReader.readObject();
        jsonReader.close();
        try {
            JsonObject coorObjekt = obj.getJsonObject("coordinates");
            try {
                this.m_coor_lat = Double.parseDouble(coorObjekt.getString("lat"));
            }
            catch (Exception e) {
                System.out.println("coordinates.lat: " + e.getMessage());
            }
            try {
                this.m_coor_lon = Double.parseDouble(coorObjekt.getString("lon"));
            }
            catch (Exception e) {
                System.out.println("coordinates.lon: " + e.getMessage());
            }
            try {
                this.m_source = obj.getString("source");
            }
            catch (Exception e) {
                System.out.println("source: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.out.println("coordinates: " + e.getMessage());
        }
        try {
            JsonObject stavebniObjekt = obj.getJsonObject("stavebni_objekt");
            try {
                this.m_objekt_ruian_id = Long.parseLong(stavebniObjekt.getString("ruian_id"));
            }
            catch (Exception e) {
                System.out.println("stavebni_objekt.ruian_id: " + e.getMessage());
            }
            try {
                this.m_objekt_podlazi = Integer.parseInt(stavebniObjekt.getString("pocet_podlazi"));
            }
            catch (Exception e) {
                System.out.println("stavebni_objekt.pocet_podlazi: " + e.getMessage());
            }
            try {
                this.m_objekt_byty = Integer.parseInt(stavebniObjekt.getString("pocet_bytu"));
            }
            catch (Exception e) {
                System.out.println("stavebni_objekt.pocet_bytu: " + e.getMessage());
            }
            try {
                this.m_objekt_zpusob_vyuziti = stavebniObjekt.getString("zpusob_vyuziti");
            }
            catch (Exception e) {
                System.out.println("stavebni_objekt.zpusob_vyuziti: " + e.getMessage());
            }
            try {
                this.m_objekt_zpusob_vyuziti_kod = stavebniObjekt.getString("zpusob_vyuziti_kod");
            }
            catch (Exception e) {
                System.out.println("stavebni_objekt.m_objekt_zpusob_vyuziti_kod: " + e.getMessage());
            }
            try {
                this.m_objekt_zpusob_vyuziti_key = stavebniObjekt.getString("zpusob_vyuziti_key");
            }
            catch (Exception e) {
                System.out.println("stavebni_objekt.zpusob_vyuziti_key: " + e.getMessage());
            }
            try {
                this.m_objekt_zpusob_vyuziti_val = stavebniObjekt.getString("zpusob_vyuziti_val");
            }
            catch (Exception e) {
                System.out.println("stavebni_objekt.m_objekt_zpusob_vyuziti_val: " + e.getMessage());
            }
            try {
                this.m_objekt_plati_od = stavebniObjekt.getString("plati_od");
            }
            catch (Exception e) {
                System.out.println("stavebni_objekt.plati_od: " + e.getMessage());
            }
            try {
                this.m_objekt_dokonceni = stavebniObjekt.getString("dokonceni");
            }
            catch (Exception e) {
                System.out.println("stavebni_objekt.dokonceni: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.out.println("stavebni_objekt: " + e.getMessage());
        }
        try {
            arr = obj.getJsonArray("so_bez_geometrie");
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject soBezGeom = arr.getJsonObject(i);
                objectWithoutGeometry so = new objectWithoutGeometry();
                try {
                    so.setRuianID(Long.parseLong(soBezGeom.getString("ruian_id")));
                }
                catch (Exception e) {
                    System.out.println("so_bez_geometrie.ruian_id: " + e.getMessage());
                }
                try {
                    so.setPodlazi(Integer.parseInt(soBezGeom.getString("pocet_podlazi")));
                }
                catch (Exception e) {
                    System.out.println("so_bez_geometrie.pocet_podlazi: " + e.getMessage());
                }
                try {
                    so.setByty(Integer.parseInt(soBezGeom.getString("pocet_bytu")));
                }
                catch (Exception e) {
                    System.out.println("so_bez_geometrie.pocet_bytu: " + e.getMessage());
                }
                try {
                    so.setZpusobVyuziti(soBezGeom.getString("zpusob_vyuziti"));
                }
                catch (Exception e) {
                    System.out.println("so_bez_geometrie.zpusob_vyuziti: " + e.getMessage());
                }
                try {
                    so.setZpusobVyuzitiKod(soBezGeom.getString("zpusob_vyuziti_kod"));
                }
                catch (Exception e) {
                    System.out.println("so_bez_geometrie.zpusob_vyuziti_kod: " + e.getMessage());
                }
                try {
                    so.setZpusobVyuzitiKey(soBezGeom.getString("zpusob_vyuziti_key"));
                }
                catch (Exception e) {
                    System.out.println("so_bez_geometrie.zpusob_vyuziti_key: " + e.getMessage());
                }
                try {
                    so.setZpusobVyuzitiVal(soBezGeom.getString("zpusob_vyuziti_val"));
                }
                catch (Exception e) {
                    System.out.println("so_bez_geometrie.zpusob_vyuziti_val: " + e.getMessage());
                }
                try {
                    so.setDokonceni(soBezGeom.getString("dokonceni"));
                }
                catch (Exception e) {
                    System.out.println("so_bez_geometrie.dokonceni: " + e.getMessage());
                }
                try {
                    so.setPlatiOd(soBezGeom.getString("plati_od"));
                }
                catch (Exception e) {
                    System.out.println("so_bez_geometrie.plati_od: " + e.getMessage());
                }
                try {
                    so.setVzdalenost(Float.parseFloat(soBezGeom.getString("vzdalenost")));
                }
                catch (Exception e) {
                    System.out.println("so_bez_geometrie.vzdalenost: " + e.getMessage());
                }
                this.m_so_bez_geometrie.add(so);
            }
        }
        catch (Exception e) {
            System.out.println("so_bez_geometrie: " + e.getMessage());
        }
        try {
            arr = obj.getJsonArray("adresni_mista");
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject adresniMisto = arr.getJsonObject(i);
                addrPlaces am = new addrPlaces();
                try {
                    am.setRuianID(Long.parseLong(adresniMisto.getString("ruian_id")));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.ruian_id: " + e.getMessage());
                }
                try {
                    JsonArray node = adresniMisto.getJsonArray("pozice");
                    am.setPosition(new LatLon(LatLon.roundToOsmPrecisionStrict((double)node.getJsonNumber(1).doubleValue()), LatLon.roundToOsmPrecisionStrict((double)node.getJsonNumber(0).doubleValue())));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.pozice: " + e.getMessage());
                }
                try {
                    am.setBudovaID(Long.parseLong(adresniMisto.getString("budova_kod")));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.budova_kod: " + e.getMessage());
                }
                try {
                    am.setCisloTyp(adresniMisto.getString("cislo_typ"));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.cislo_typ: " + e.getMessage());
                }
                try {
                    am.setCisloDomovni(adresniMisto.getString("cislo_domovni"));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.cislo_domovni: " + e.getMessage());
                }
                try {
                    am.setCisloOrientacni(adresniMisto.getString("cislo_orientacni"));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.cislo_orientacni: " + e.getMessage());
                }
                try {
                    am.setUliceID(Long.parseLong(adresniMisto.getString("ulice_kod")));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.ulice_kod: " + e.getMessage());
                }
                try {
                    am.setUlice(adresniMisto.getString("ulice"));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.ulice: " + e.getMessage());
                }
                try {
                    am.setCastObceID(Long.parseLong(adresniMisto.getString("cast_obce_kod")));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.cast_obce_kod: " + e.getMessage());
                }
                try {
                    am.setCastObce(adresniMisto.getString("cast_obce"));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.m_cast_obce: " + e.getMessage());
                }
                try {
                    am.setMestskaCastID(Long.parseLong(adresniMisto.getString("mestska_cast_kod")));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.mestska_cast_kod: " + e.getMessage());
                }
                try {
                    am.setMestskaCast(adresniMisto.getString("mestska_cast"));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.mestska_cast: " + e.getMessage());
                }
                try {
                    am.setObecID(Long.parseLong(adresniMisto.getString("obec_kod")));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.obec:_kod " + e.getMessage());
                }
                try {
                    am.setObec(adresniMisto.getString("obec"));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.obec: " + e.getMessage());
                }
                try {
                    am.setOkresID(Long.parseLong(adresniMisto.getString("okres_kod")));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.okres_kod: " + e.getMessage());
                }
                try {
                    am.setOkres(adresniMisto.getString("okres"));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.okres: " + e.getMessage());
                }
                try {
                    am.setKrajID(Long.parseLong(adresniMisto.getString("kraj_kod")));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.kraj_kod: " + e.getMessage());
                }
                try {
                    am.setKraj(adresniMisto.getString("kraj"));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.kraj: " + e.getMessage());
                }
                try {
                    am.setPsc(adresniMisto.getString("psc"));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.psc: " + e.getMessage());
                }
                try {
                    am.setVzdalenost(Float.parseFloat(adresniMisto.getString("vzdalenost")));
                }
                catch (Exception e) {
                    System.out.println("adresni_mista.vzdalenost: " + e.getMessage());
                }
                this.m_adresni_mista.add(am);
            }
        }
        catch (Exception e) {
            System.out.println("adresni_mista: " + e.getMessage());
        }
        try {
            JsonObject parcela = obj.getJsonObject("parcela");
            try {
                this.m_parcela_ruian_id = Long.parseLong(parcela.getString("ruian_id"));
            }
            catch (Exception e) {
                System.out.println("parcela.ruian_id: " + e.getMessage());
            }
            try {
                this.m_parcela_druh_pozemku = parcela.getString("druh_pozemku");
            }
            catch (Exception e) {
                System.out.println("parcela.druh_pozemku: " + e.getMessage());
            }
            try {
                this.m_parcela_zpusob_vyuziti = parcela.getString("zpusob_vyuziti");
            }
            catch (Exception e) {
                System.out.println("parcela.zpusob_vyuziti: " + e.getMessage());
            }
            try {
                this.m_parcela_plati_od = parcela.getString("plati_od");
            }
            catch (Exception e) {
                System.out.println("parcela.plati_od: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.out.println("parcela: " + e.getMessage());
        }
        try {
            JsonObject ulice = obj.getJsonObject("ulice");
            try {
                this.m_ulice_ruian_id = Long.parseLong(ulice.getString("ruian_id"));
            }
            catch (Exception e) {
                System.out.println("ulice.ruian_id: " + e.getMessage());
            }
            try {
                this.m_ulice_jmeno = ulice.getString("jmeno");
            }
            catch (Exception e) {
                System.out.println("ulice.jmeno: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.out.println("ulice: " + e.getMessage());
        }
        try {
            JsonObject katastr = obj.getJsonObject("katastr");
            try {
                this.m_katastr_ruian_id = Long.parseLong(katastr.getString("ruian_id"));
            }
            catch (Exception e) {
                System.out.println("katastr.ruian_id: " + e.getMessage());
            }
            try {
                this.m_katastr_nazev = katastr.getString("nazev");
            }
            catch (Exception e) {
                System.out.println("katastr.nazev: " + e.getMessage());
            }
            try {
                this.m_katastr_obec_kod = Long.parseLong(katastr.getString("obec_kod"));
            }
            catch (Exception e) {
                System.out.println("katastr.obec_kod: " + e.getMessage());
            }
            try {
                this.m_katastr_obec = katastr.getString("obec");
            }
            catch (Exception e) {
                System.out.println("katastr.okres: " + e.getMessage());
            }
            try {
                this.m_katastr_okres_kod = Long.parseLong(katastr.getString("okres_kod"));
            }
            catch (Exception e) {
                System.out.println("katastr.okres_kod: " + e.getMessage());
            }
            try {
                this.m_katastr_okres = katastr.getString("okres");
            }
            catch (Exception e) {
                System.out.println("katastr.okres: " + e.getMessage());
            }
            try {
                this.m_katastr_kraj_kod = Long.parseLong(katastr.getString("kraj_kod"));
            }
            catch (Exception e) {
                System.out.println("katastr.kraj_kod: " + e.getMessage());
            }
            try {
                this.m_katastr_kraj = katastr.getString("kraj");
            }
            catch (Exception e) {
                System.out.println("katastr.kraj: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.out.println("katastr: " + e.getMessage());
        }
    }

    public String getHtml() {
        String icon_ext_link = "<img src=" + this.getClass().getResource("/images/dialogs/open-external-link.png") + " border=0 alt=\"Zobrazit na str\u00e1nk\u00e1ch RUIAN\"/>";
        String icon_copy_tags = "<img src=" + this.getClass().getResource("/images/dialogs/copy-tags.png") + " border=0 alt=\"Zobrazit na str\u00e1nk\u00e1ch RUIAN\"/>";
        String icon_create_addr = "<img src=" + this.getClass().getResource("/images/dialogs/create-addr.png") + " border=0 alt=\"Zobrazit na str\u00e1nk\u00e1ch RUIAN\"/>";
        String icon_create_addr_ruian = "<img src=" + this.getClass().getResource("/images/dialogs/create-addr-ruian.png") + " border=0 alt=\"Zobrazit na str\u00e1nk\u00e1ch RUIAN\"/>";
        String url_cpost = "http://www.postaonline.cz/vyhledani-psc?p_p_id=psc_WAR_pcpvpp&p_p_lifecycle=1&p_p_state=normal&p_p_mode=view&p_p_col_id=column-1&p_p_col_count=1&_psc_WAR_pcpvpp_struts.portlet.action=%2Fview%2FdetailPost&_psc_WAR_pcpvpp_struts.portlet.mode=view&_psc_WAR_pcpvpp_zipCode=";
        String url_stavebni_objekt = "http://vdp.cuzk.cz/vdp/ruian/stavebniobjekty/";
        String url_adresni_misto = "http://vdp.cuzk.cz/vdp/ruian/adresnimista/";
        String url_parcela = "http://vdp.cuzk.cz/vdp/ruian/parcely/";
        String url_katastralni_uzemi = "http://vdp.cuzk.cz/vdp/ruian/katastralniuzemi/";
        String url_ulice = "http://vdp.cuzk.cz/vdp/ruian/ulice/";
        String url_mistni_cast = "http://vdp.cuzk.cz/vdp/ruian/castiobce/";
        String url_mestska_cast = "http://vdp.cuzk.cz/vdp/ruian/mestskecasti/";
        String url_obec = "http://vdp.cuzk.cz/vdp/ruian/obce/";
        String url_okres = "http://vdp.cuzk.cz/vdp/ruian/okresy/";
        String url_kraj = "http://vdp.cuzk.cz/vdp/ruian/vusc/";
        StringBuilder r = new StringBuilder();
        if (this.m_objekt_ruian_id == 0L && this.m_parcela_ruian_id == 0L && this.m_adresni_mista.size() == 0 && this.m_ulice_ruian_id == 0L && this.m_katastr_ruian_id == 0L) {
            return "";
        }
        r.append("<html>");
        r.append("<br/>");
        if (this.m_objekt_ruian_id > 0L) {
            int i;
            r.append("<i><u>Informace o budov\u011b</u></i><br/>");
            r.append("<b>RUIAN id: </b>" + this.m_objekt_ruian_id + "&nbsp;&nbsp;<a href=" + url_stavebni_objekt + this.m_objekt_ruian_id + ">" + icon_ext_link + "</a>");
            r.append("&nbsp;&nbsp;<a href=file://tags.copy/building>" + icon_copy_tags + "</a><br/>");
            if (this.m_adresni_mista.size() == 0) {
                r.append("<b>Budova: </b> bez \u010d.p./\u010d.e<br/>");
            } else if (this.m_adresni_mista.get(0).getCisloTyp().equals("\u010c\u00edslo popisn\u00e9")) {
                r.append("<b>Budova: </b>s \u010d\u00edslem popisn\u00fdm<br/>");
            } else {
                r.append("<b>Budova: </b>s \u010d\u00edslem eviden\u010dn\u00edm<br/>");
            }
            if (this.m_objekt_podlazi > 0) {
                r.append("<b>Po\u010det podla\u017e\u00ed: </b>" + this.m_objekt_podlazi + "<br/>");
            }
            if (this.m_objekt_byty > 0) {
                r.append("<b>Po\u010det byt\u016f: </b>" + this.m_objekt_byty + "<br/>");
            }
            r.append("<b>Zp\u016fsob vyu\u017eit\u00ed: </b>" + this.m_objekt_zpusob_vyuziti + "<br/>");
            r.append("<b>Datum dokon\u010den\u00ed: </b>" + this.m_objekt_dokonceni + "<br/>");
            r.append("<b>Plat\u00ed od: </b>" + this.m_objekt_plati_od + "<br/>");
            r.append("<br/>");
            if (this.m_adresni_mista.size() > 1) {
                r.append("<i><u>Informace o adrese</u></i><br/>");
                i = 0;
                r.append("<b>" + this.m_adresni_mista.get(i).getCisloTyp() + "</b> (v\u00edce adres)<b>: </b>" + this.m_adresni_mista.get(i).getCisloDomovni() + "<br/>");
                r.append("<b>\u010c\u00e1st obce: </b>" + this.m_adresni_mista.get(i).getCastObce());
                r.append("&nbsp;&nbsp;<a href=" + url_mistni_cast + this.m_adresni_mista.get(i).getCastObceID() + ">" + icon_ext_link + "</a><br/>");
                if (this.m_adresni_mista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>" + this.m_adresni_mista.get(i).getMestskaCast());
                    r.append("&nbsp;&nbsp;<a href=" + url_mestska_cast + this.m_adresni_mista.get(i).getMestskaCastID() + ">" + icon_ext_link + "</a><br/>");
                }
                r.append("<b>Obec: </b>" + this.m_adresni_mista.get(i).getObec());
                r.append("&nbsp;&nbsp;<a href=" + url_obec + this.m_adresni_mista.get(i).getObecID() + ">" + icon_ext_link + "</a><br/>");
                r.append("<b>Okres: </b>" + this.m_adresni_mista.get(i).getOkres());
                r.append("&nbsp;&nbsp;<a href=" + url_okres + this.m_adresni_mista.get(i).getOkresID() + ">" + icon_ext_link + "</a><br/>");
                r.append("<b>Kraj: </b>" + this.m_adresni_mista.get(i).getKraj());
                r.append("&nbsp;&nbsp;<a href=" + url_kraj + this.m_adresni_mista.get(i).getKrajID() + ">" + icon_ext_link + "</a><br/>");
            } else if (this.m_adresni_mista.size() == 1 && (this.m_adresni_mista.get(0).getCisloDomovni() == null || this.m_adresni_mista.get(0).getCisloDomovni().isEmpty())) {
                i = 0;
                r.append("<i><u>Informace o adrese</u></i><br/>");
                r.append("<b>Budova: </b>" + this.m_adresni_mista.get(i).getCisloTyp() + "<br/>");
                if (this.m_adresni_mista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>" + this.m_adresni_mista.get(i).getMestskaCast());
                    r.append("&nbsp;&nbsp;<a href=" + url_mestska_cast + this.m_adresni_mista.get(i).getMestskaCastID() + ">" + icon_ext_link + "</a><br/>");
                }
                r.append("<b>Obec: </b>" + this.m_adresni_mista.get(i).getObec());
                r.append("&nbsp;&nbsp;<a href=" + url_obec + this.m_adresni_mista.get(i).getObecID() + ">" + icon_ext_link + "</a><br/>");
                r.append("<b>Okres: </b>" + this.m_adresni_mista.get(i).getOkres());
                r.append("&nbsp;&nbsp;<a href=" + url_okres + this.m_adresni_mista.get(i).getOkresID() + ">" + icon_ext_link + "</a><br/>");
                r.append("<b>Kraj: </b>" + this.m_adresni_mista.get(i).getKraj());
                r.append("&nbsp;&nbsp;<a href=" + url_kraj + this.m_adresni_mista.get(i).getKrajID() + ">" + icon_ext_link + "</a><br/>");
            } else if (this.m_adresni_mista.size() == 1) {
                i = 0;
                String x = "";
                String x_name = "";
                if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                    x = "/" + this.m_adresni_mista.get(i).getCisloOrientacni();
                    x_name = "/orienta\u010dn\u00ed";
                }
                r.append("<i><u>Informace o adrese</u></i><br/>");
                r.append("<b>RUIAN id: </b>" + this.m_adresni_mista.get(i).getRuianID() + "&nbsp;&nbsp;<a href=" + url_adresni_misto + this.m_adresni_mista.get(i).getRuianID() + ">" + icon_ext_link + "</a>");
                r.append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + ">" + icon_copy_tags + "</a>");
                r.append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + ">" + icon_create_addr + "</a>");
                r.append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + ">" + icon_create_addr_ruian + "</a><br/>");
                r.append("<b>" + this.m_adresni_mista.get(i).getCisloTyp() + x_name + ": </b>" + this.m_adresni_mista.get(i).getCisloDomovni() + x);
                r.append("<br/>");
                if (!this.m_adresni_mista.get(i).getUlice().isEmpty()) {
                    r.append("<b>Ulice: </b>" + this.m_adresni_mista.get(i).getUlice());
                    r.append("&nbsp;&nbsp;<a href=" + url_ulice + this.m_adresni_mista.get(i).getUliceID() + ">" + icon_ext_link + "</a><br/>");
                }
                r.append("<b>\u010c\u00e1st obce: </b>" + this.m_adresni_mista.get(i).getCastObce());
                r.append("&nbsp;&nbsp;<a href=" + url_mistni_cast + this.m_adresni_mista.get(i).getCastObceID() + ">" + icon_ext_link + "</a><br/>");
                if (this.m_adresni_mista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>" + this.m_adresni_mista.get(i).getMestskaCast());
                    r.append("&nbsp;&nbsp;<a href=" + url_mestska_cast + this.m_adresni_mista.get(i).getMestskaCastID() + ">" + icon_ext_link + "</a><br/>");
                }
                r.append("<b>Obec: </b>" + this.m_adresni_mista.get(i).getObec());
                r.append("&nbsp;&nbsp;<a href=" + url_obec + this.m_adresni_mista.get(i).getObecID() + ">" + icon_ext_link + "</a><br/>");
                r.append("<b>Okres: </b>" + this.m_adresni_mista.get(i).getOkres());
                r.append("&nbsp;&nbsp;<a href=" + url_okres + this.m_adresni_mista.get(i).getOkresID() + ">" + icon_ext_link + "</a><br/>");
                r.append("<b>Kraj: </b>" + this.m_adresni_mista.get(i).getKraj());
                r.append("&nbsp;&nbsp;<a href=" + url_kraj + this.m_adresni_mista.get(i).getKrajID() + ">" + icon_ext_link + "</a><br/>");
                r.append("<b>PS\u010c: </b>" + this.m_adresni_mista.get(i).getPsc());
                r.append("&nbsp;&nbsp;<a href=" + url_cpost + this.m_adresni_mista.get(i).getPsc() + ">" + icon_ext_link + "</a><br/>");
            }
            r.append("<br/>");
        }
        if (this.m_adresni_mista.size() > 1 && this.m_objekt_ruian_id > 0L) {
            String x = "";
            if (this.m_adresni_mista.get(0).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                x = "ev.";
            }
            r.append("<i><u>Adresn\u00ed m\u00edsta</u></i><br/>");
            for (int i = 0; i < this.m_adresni_mista.size(); ++i) {
                r.append(this.m_adresni_mista.get(i).getUlice() + " " + x + this.m_adresni_mista.get(i).getCisloDomovni());
                if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                    r.append("/" + this.m_adresni_mista.get(i).getCisloOrientacni());
                }
                r.append("&nbsp;&nbsp;<a href=" + url_adresni_misto + this.m_adresni_mista.get(i).getRuianID() + ">" + icon_ext_link + "</a> ");
                r.append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + ">" + icon_copy_tags + "</a>");
                r.append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + ">" + icon_create_addr + "</a>");
                r.append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + ">" + icon_create_addr_ruian + "</a>");
                r.append("<br/>");
            }
            r.append("<br/>");
        }
        if (this.m_parcela_ruian_id > 0L) {
            r.append("<i><u>Informace o pozemku</u></i>");
            r.append("<br/>");
            r.append("<b>RUIAN id: </b>" + this.m_parcela_ruian_id + "&nbsp;&nbsp;<a href=" + url_parcela + this.m_parcela_ruian_id + ">" + icon_ext_link + "</a><br/>");
            r.append("<b>Druh pozemku: </b>" + this.m_parcela_druh_pozemku + "<br/>");
            if (this.m_parcela_zpusob_vyuziti != "") {
                r.append("<b>Zp\u016fsob vyu\u017eit\u00ed: </b>" + this.m_parcela_zpusob_vyuziti + "<br/>");
            }
            r.append("<b>Plat\u00ed od: </b>" + this.m_parcela_plati_od + "<br/>");
            r.append("<br/>");
        }
        if (this.m_ulice_ruian_id > 0L) {
            r.append("<i><u>Informace o ulici</u></i><br/>");
            r.append("<b>RUIAN id: </b>" + this.m_ulice_ruian_id + "&nbsp;&nbsp;<a href=" + url_ulice + this.m_ulice_ruian_id + ">" + icon_ext_link + "</a>");
            r.append("&nbsp;&nbsp;<a href=file://tags.copy/street>" + icon_copy_tags + "</a><br/>");
            r.append("<b>Jm\u00e9no: </b>" + this.m_ulice_jmeno + "<br/>");
            r.append("<br/>");
        }
        if (this.m_katastr_ruian_id > 0L) {
            r.append("<b>Katastr\u00e1ln\u00ed \u00fazem\u00ed: </b>" + this.m_katastr_nazev);
            r.append("&nbsp;&nbsp;<a href=" + url_katastralni_uzemi + this.m_katastr_ruian_id + ">" + icon_ext_link + "</a><br/>");
            r.append("<b>Obec: </b>" + this.m_katastr_obec);
            r.append("&nbsp;&nbsp;<a href=" + url_obec + this.m_katastr_obec_kod + ">" + icon_ext_link + "</a><br/>");
            r.append("<b>Okres: </b>" + this.m_katastr_okres);
            r.append("&nbsp;&nbsp;<a href=" + url_okres + this.m_katastr_okres_kod + ">" + icon_ext_link + "</a><br/>");
            r.append("<b>Kraj: </b>" + this.m_katastr_kraj);
            r.append("&nbsp;&nbsp;<a href=" + url_kraj + this.m_katastr_kraj_kod + ">" + icon_ext_link + "</a><br/>");
            r.append("<br/>");
        }
        if (this.m_adresni_mista.size() > 0 && this.m_objekt_ruian_id == 0L) {
            r.append("<i><u>Adresn\u00ed m\u00edsta v okol\u00ed</u></i><br/>");
            r.append("<table>");
            for (int i = 0; i < this.m_adresni_mista.size(); ++i) {
                String x = "";
                String x_name = "";
                if (this.m_adresni_mista.get(i).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                    x = "ev.";
                }
                x = x + this.m_adresni_mista.get(i).getCisloDomovni();
                if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                    x = x + "/" + this.m_adresni_mista.get(i).getCisloOrientacni();
                    x_name = x_name + "/orienta\u010dn\u00ed";
                }
                r.append("<tr><td bgcolor=#e5e5ff>");
                if (!this.m_adresni_mista.get(i).getUlice().isEmpty()) {
                    r.append(this.m_adresni_mista.get(i).getVzdalenost());
                    r.append("</td><td valign=\"top\"  bgcolor=#e5e5ff>");
                    r.append(this.m_adresni_mista.get(i).getUlice() + " " + x);
                    r.append("<br/><u>" + this.m_adresni_mista.get(i).getObec() + "</u>");
                    r.append("</td><td valign=\"top\"  bgcolor=#e5e5ff>");
                    r.append("<a href=" + url_adresni_misto + this.m_adresni_mista.get(i).getRuianID() + ">" + icon_ext_link + "</a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + ">" + icon_copy_tags + "</a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + ">" + icon_create_addr + "</a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + ">" + icon_create_addr_ruian + "</a>");
                } else {
                    r.append(this.m_adresni_mista.get(i).getVzdalenost());
                    r.append("</td><td valign=\"top\"  bgcolor=#e5e5ff>");
                    r.append(this.m_adresni_mista.get(i).getCastObce() + " " + x + "&nbsp;");
                    if (!this.m_adresni_mista.get(i).getCastObce().equals(this.m_adresni_mista.get(i).getObec())) {
                        r.append("<br/><u>" + this.m_adresni_mista.get(i).getObec() + "</u>");
                    }
                    r.append("</td><td valign=\"top\"  bgcolor=#e5e5ff>");
                    r.append("<a href=" + url_adresni_misto + this.m_adresni_mista.get(i).getRuianID() + ">" + icon_ext_link + "</a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + ">" + icon_copy_tags + "</a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + ">" + icon_create_addr + "</a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + ">" + icon_create_addr_ruian + "</a>");
                }
                r.append("</td></tr>");
            }
            r.append("</table><br/>");
        }
        if (this.m_so_bez_geometrie.size() > 0) {
            r.append("<i><u>Budovy bez geometrie v okol\u00ed</u></i><br/>");
            r.append("<table>");
            for (int i = 0; i < this.m_so_bez_geometrie.size(); ++i) {
                r.append("<tr><td bgcolor=#e5e5ff>");
                r.append(this.m_so_bez_geometrie.get(i).getVzdalenost());
                r.append("</td><td valign=\"top\"  bgcolor=#e5e5ff>");
                r.append(this.m_so_bez_geometrie.get(i).getRuianID());
                if (this.m_so_bez_geometrie.get(i).getZpusobVyuziti().length() > 0) {
                    r.append(" - " + this.m_so_bez_geometrie.get(i).getZpusobVyuziti());
                }
                r.append("</td><td valign=\"top\"  bgcolor=#e5e5ff>");
                r.append("&nbsp;&nbsp;<a href=" + url_stavebni_objekt + this.m_so_bez_geometrie.get(i).getRuianID() + ">" + icon_ext_link + "</a> ");
                r.append("&nbsp;&nbsp;<a href=file://tags.copy/building>" + icon_copy_tags + "</a></br>");
                r.append("</td></tr>");
            }
            r.append("</table><br/>");
            r.append("<br/>");
        }
        r.append("<hr/>");
        r.append("<center><i><small>Zdroj: <a href=\"http://www.ruian.cz/\">" + this.m_source + "</a></small></i></center>");
        r.append("</html>");
        return r.toString();
    }

    String convertDate(String ruianDate) {
        String r = new String();
        String[] parts = ruianDate.split("\\.");
        try {
            int day = Integer.parseInt(parts[0]);
            int month = Integer.parseInt(parts[1]);
            int year = Integer.parseInt(parts[2]);
            r = new Integer(year).toString() + "-" + String.format("%02d", month) + "-" + String.format("%02d", day);
        }
        catch (Exception e) {
            // empty catch block
        }
        return r;
    }

    String tagToString(String k, String v) {
        String r = "\"" + k + "\"=\"" + v + "\"\n";
        return r;
    }

    String getKeys(String keyType) {
        StringBuilder c = new StringBuilder();
        if (keyType.equals("building") && this.m_objekt_ruian_id > 0L) {
            c.append(this.tagToString("ref:ruian:building", Long.toString(this.m_objekt_ruian_id)));
            if (this.m_objekt_zpusob_vyuziti_key.length() > 0 && this.m_objekt_zpusob_vyuziti_val.length() > 0) {
                c.append(this.tagToString(this.m_objekt_zpusob_vyuziti_key, this.m_objekt_zpusob_vyuziti_val));
            }
            if (this.m_objekt_podlazi > 0) {
                c.append(this.tagToString("building:levels", Integer.toString(this.m_objekt_podlazi)));
            }
            if (this.m_objekt_byty > 0) {
                c.append(this.tagToString("building:flats", Integer.toString(this.m_objekt_byty)));
            }
            if (this.m_objekt_dokonceni.length() > 0 && this.convertDate(this.m_objekt_dokonceni).length() > 0) {
                c.append(this.tagToString("start_date", this.convertDate(this.m_objekt_dokonceni)));
            }
            if (this.m_objekt_zpusob_vyuziti_kod.length() > 0) {
                c.append(this.tagToString("building:ruian:type", this.m_objekt_zpusob_vyuziti_kod));
            }
            c.append(this.tagToString("source", "cuzk:ruian"));
        }
        if (keyType.startsWith("address") && this.m_adresni_mista.size() > 0) {
            int i;
            if (this.m_adresni_mista.size() == 0) {
                i = 0;
            } else {
                String[] key = keyType.split(":");
                i = new Integer(key[1]);
                System.out.println("Address ID: " + i);
            }
            if (!this.m_adresni_mista.get(i).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                c.append(this.tagToString("addr:conscriptionnumber", this.m_adresni_mista.get(i).getCisloDomovni()));
            } else {
                c.append(this.tagToString("addr:provisionalnumber", this.m_adresni_mista.get(i).getCisloDomovni()));
            }
            if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                c.append(this.tagToString("addr:streetnumber", this.m_adresni_mista.get(i).getCisloOrientacni()));
            }
            StringBuilder addr = new StringBuilder();
            if (!this.m_adresni_mista.get(i).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                addr.append(this.m_adresni_mista.get(i).getCisloDomovni());
            } else {
                addr.append("ev." + this.m_adresni_mista.get(i).getCisloDomovni());
            }
            if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                addr.append("/" + this.m_adresni_mista.get(i).getCisloOrientacni());
            }
            c.append(this.tagToString("addr:housenumber", addr.toString()));
            if (!this.m_adresni_mista.get(i).getUlice().isEmpty()) {
                c.append(this.tagToString("addr:street", this.m_adresni_mista.get(i).getUlice()));
            }
            if (this.m_adresni_mista.get(i).getRuianID() > 0L) {
                c.append(this.tagToString("ref:ruian:addr", Long.toString(this.m_adresni_mista.get(i).getRuianID())));
            }
            if (!this.m_adresni_mista.get(i).getCastObce().isEmpty()) {
                c.append(this.tagToString("addr:place", this.m_adresni_mista.get(i).getCastObce()));
            }
            if (!this.m_adresni_mista.get(i).getMestskaCast().isEmpty()) {
                c.append(this.tagToString("addr:suburb", this.m_adresni_mista.get(i).getMestskaCast()));
            }
            if (!this.m_adresni_mista.get(i).getObec().isEmpty()) {
                c.append(this.tagToString("addr:city", this.m_adresni_mista.get(i).getObec()));
            }
            if (!this.m_adresni_mista.get(i).getPsc().isEmpty()) {
                c.append(this.tagToString("addr:postcode", this.m_adresni_mista.get(i).getPsc()));
            }
            c.append(this.tagToString("addr:country", "CZ"));
            c.append(this.tagToString("source:addr", "cuzk:ruian"));
        }
        if (keyType.equals("street") && this.m_ulice_ruian_id > 0L) {
            c.append(this.tagToString("ref:ruian:street", Long.toString(this.m_ulice_ruian_id)));
            c.append(this.tagToString("name", this.m_ulice_jmeno));
            c.append(this.tagToString("source", "cuzk:ruian"));
        }
        return c.toString();
    }

    void createAddrPoint(String cmd, String t) {
        Node node;
        LinkedList<AddCommand> commands = new LinkedList<AddCommand>();
        if (cmd.startsWith("tags.create-on-place")) {
            String[] key = cmd.split(":");
            int i = new Integer(key[1]);
            node = new Node(this.m_adresni_mista.get(i).getPosition());
        } else {
            node = new Node(new LatLon(this.m_coor_lat, this.m_coor_lon));
        }
        commands.add(new AddCommand((OsmPrimitive)node));
        LinkedList<Node> coll = new LinkedList<Node>();
        coll.add(node);
        TagCollection tc = new TagCollection();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(t.split("\n")));
        for (String line : list) {
            String[] tag = line.split("\"=\"");
            System.out.println("<" + tag[0] + ">. <" + tag[1] + ">");
            tc.add(new Tag(tag[0].substring(1), tag[1].substring(0, tag[1].length() - 1)));
        }
        tc.applyTo(coll);
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Add new address point", (Object[])new Object[0]), commands));
    }

    public void performAction(String act) {
        System.out.println("act: " + act.substring(7));
        String[] params = act.substring(7).split("/");
        if (!params[0].equals("tags.copy") && !params[0].startsWith("tags.create")) {
            return;
        }
        String task = this.getKeys(params[1]);
        if (params[0].equals("tags.copy") && task.length() > 0) {
            Utils.copyToClipboard((String)task);
            PointInfoUtils.showNotification(I18n.tr((String)"Tags copied to clipboard.", (Object[])new Object[0]), "info");
        }
        if (params[0].startsWith("tags.create") && task.length() > 0) {
            this.createAddrPoint(act.substring(7), task);
            PointInfoUtils.showNotification(I18n.tr((String)"New address point added.", (Object[])new Object[0]), "info");
        }
    }
}

