/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.psd.datareaders;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.PackBits;
import org.apache.sanselan.common.mylzw.BitsToByteInputStream;
import org.apache.sanselan.common.mylzw.MyBitInputStream;
import org.apache.sanselan.formats.psd.ImageContents;
import org.apache.sanselan.formats.psd.PSDHeaderInfo;
import org.apache.sanselan.formats.psd.dataparsers.DataParser;
import org.apache.sanselan.formats.psd.datareaders.DataReader;

public class CompressedDataReader
extends DataReader {
    public CompressedDataReader(DataParser fDataParser) {
        super(fDataParser);
    }

    @Override
    public void readData(InputStream is, BufferedImage bi, ImageContents imageContents, BinaryFileParser bfp) throws ImageReadException, IOException {
        PSDHeaderInfo header = imageContents.header;
        int width = header.Columns;
        int height = header.Rows;
        int scanline_count = height * header.Channels;
        int[] scanline_bytecounts = new int[scanline_count];
        for (int i = 0; i < scanline_count; ++i) {
            scanline_bytecounts[i] = bfp.read2Bytes("scanline_bytecount[" + i + "]", is, "PSD: bad Image Data");
        }
        bfp.setDebug(false);
        int depth = header.Depth;
        int channel_count = this.dataParser.getBasicChannelsCount();
        int[][][] data = new int[channel_count][height][];
        for (int channel = 0; channel < channel_count; ++channel) {
            for (int y = 0; y < height; ++y) {
                int index = channel * height + y;
                byte[] packed = bfp.readByteArray("scanline", scanline_bytecounts[index], is, "PSD: Missing Image Data");
                byte[] unpacked = new PackBits().decompress(packed, width);
                ByteArrayInputStream bais = new ByteArrayInputStream(unpacked);
                MyBitInputStream mbis = new MyBitInputStream(bais, 77);
                BitsToByteInputStream bbis = new BitsToByteInputStream(mbis, 8);
                int[] scanline = bbis.readBitsArray(depth, width);
                data[channel][y] = scanline;
            }
        }
        this.dataParser.parseData(data, bi, imageContents);
    }
}

